/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.shiro.concurrent.SubjectAwareExecutor;
import org.apache.shiro.subject.Subject;

public class SubjectAwareExecutorService
extends SubjectAwareExecutor
implements ExecutorService {
    private ExecutorService targetExecutorService;

    public SubjectAwareExecutorService() {
    }

    public SubjectAwareExecutorService(ExecutorService target) {
        this.setTargetExecutorService(target);
    }

    public ExecutorService getTargetExecutorService() {
        return this.targetExecutorService;
    }

    public void setTargetExecutorService(ExecutorService targetExecutorService) {
        super.setTargetExecutor(targetExecutorService);
        this.targetExecutorService = targetExecutorService;
    }

    @Override
    public void setTargetExecutor(Executor targetExecutor) {
        if (!(targetExecutor instanceof ExecutorService)) {
            String msg = "The " + this.getClass().getName() + " implementation only accepts " + ExecutorService.class.getName() + " target instances.";
            throw new IllegalArgumentException(msg);
        }
        super.setTargetExecutor(targetExecutor);
    }

    @Override
    public void shutdown() {
        this.targetExecutorService.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.targetExecutorService.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.targetExecutorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.targetExecutorService.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.targetExecutorService.awaitTermination(timeout, unit);
    }

    protected <T> Callable<T> associateWithSubject(Callable<T> task) {
        Subject subject = this.getSubject();
        return subject.associateWith(task);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        Callable<T> work = this.associateWithSubject(task);
        return this.targetExecutorService.submit(work);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        Runnable work = this.associateWithSubject(task);
        return this.targetExecutorService.submit(work, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        Runnable work = this.associateWithSubject(task);
        return this.targetExecutorService.submit(work);
    }

    protected <T> Collection<Callable<T>> associateWithSubject(Collection<? extends Callable<T>> tasks) {
        ArrayList<Callable<T>> workItems = new ArrayList<Callable<T>>(tasks.size());
        for (Callable<T> task : tasks) {
            Callable<T> work = this.associateWithSubject(task);
            workItems.add(work);
        }
        return workItems;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        Collection<Callable<T>> workItems = this.associateWithSubject(tasks);
        return this.targetExecutorService.invokeAll(workItems);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        Collection<Callable<T>> workItems = this.associateWithSubject(tasks);
        return this.targetExecutorService.invokeAll(workItems, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        Collection<Callable<T>> workItems = this.associateWithSubject(tasks);
        return this.targetExecutorService.invokeAny(workItems);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Collection<Callable<T>> workItems = this.associateWithSubject(tasks);
        return this.targetExecutorService.invokeAny(workItems, timeout, unit);
    }
}

