/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.acl;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.distributedlog.TestZooKeeperClientBuilder;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.ZooKeeperClusterTestCase;
import org.apache.distributedlog.impl.acl.ZKAccessControl;
import org.apache.distributedlog.thrift.AccessControlEntry;
import org.apache.distributedlog.util.Utils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestZKAccessControl
extends ZooKeeperClusterTestCase {
    private ZooKeeperClient zkc;

    @Before
    public void setup() throws Exception {
        this.zkc = TestZooKeeperClientBuilder.newBuilder().uri(this.createURI("/")).build();
    }

    @After
    public void teardown() throws Exception {
        this.zkc.close();
    }

    private URI createURI(String path) {
        return URI.create("distributedlog://127.0.0.1:" + zkPort + path);
    }

    @Test(timeout=60000L)
    public void testCreateZKAccessControl() throws Exception {
        AccessControlEntry ace = new AccessControlEntry();
        ace.setDenyWrite(true);
        String zkPath = "/create-zk-access-control";
        ZKAccessControl zkac = new ZKAccessControl(ace, zkPath);
        Utils.ioResult((CompletableFuture)zkac.create(this.zkc));
        ZKAccessControl readZKAC = (ZKAccessControl)Utils.ioResult((CompletableFuture)ZKAccessControl.read((ZooKeeperClient)this.zkc, (String)zkPath, null));
        Assert.assertEquals((Object)zkac, (Object)readZKAC);
        ZKAccessControl another = new ZKAccessControl(ace, zkPath);
        try {
            FutureUtils.result((CompletableFuture)another.create(this.zkc));
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
    }

    @Test(timeout=60000L)
    public void testDeleteZKAccessControl() throws Exception {
        String zkPath = "/delete-zk-access-control";
        AccessControlEntry ace = new AccessControlEntry();
        ace.setDenyDelete(true);
        ZKAccessControl zkac = new ZKAccessControl(ace, zkPath);
        Utils.ioResult((CompletableFuture)zkac.create(this.zkc));
        ZKAccessControl readZKAC = (ZKAccessControl)Utils.ioResult((CompletableFuture)ZKAccessControl.read((ZooKeeperClient)this.zkc, (String)zkPath, null));
        Assert.assertEquals((Object)zkac, (Object)readZKAC);
        Utils.ioResult((CompletableFuture)ZKAccessControl.delete((ZooKeeperClient)this.zkc, (String)zkPath));
        try {
            FutureUtils.result((CompletableFuture)ZKAccessControl.read((ZooKeeperClient)this.zkc, (String)zkPath, null));
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
        Utils.ioResult((CompletableFuture)ZKAccessControl.delete((ZooKeeperClient)this.zkc, (String)zkPath));
    }

    @Test(timeout=60000L)
    public void testEmptyZKAccessControl() throws Exception {
        String zkPath = "/empty-access-control";
        this.zkc.get().create(zkPath, new byte[0], this.zkc.getDefaultACL(), CreateMode.PERSISTENT);
        ZKAccessControl readZKAC = (ZKAccessControl)Utils.ioResult((CompletableFuture)ZKAccessControl.read((ZooKeeperClient)this.zkc, (String)zkPath, null));
        Assert.assertEquals((Object)zkPath, (Object)readZKAC.getZKPath());
        Assert.assertEquals((Object)ZKAccessControl.DEFAULT_ACCESS_CONTROL_ENTRY, (Object)readZKAC.getAccessControlEntry());
        Assert.assertTrue((ZKAccessControl.DEFAULT_ACCESS_CONTROL_ENTRY == readZKAC.getAccessControlEntry() ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testCorruptedZKAccessControl() throws Exception {
        String zkPath = "/corrupted-zk-access-control";
        this.zkc.get().create(zkPath, "corrupted-data".getBytes(StandardCharsets.UTF_8), this.zkc.getDefaultACL(), CreateMode.PERSISTENT);
        try {
            Utils.ioResult((CompletableFuture)ZKAccessControl.read((ZooKeeperClient)this.zkc, (String)zkPath, null));
        }
        catch (ZKAccessControl.CorruptedAccessControlException corruptedAccessControlException) {
            // empty catch block
        }
    }

    @Test(timeout=60000L)
    public void testUpdateZKAccessControl() throws Exception {
        String zkPath = "/update-zk-access-control";
        AccessControlEntry ace = new AccessControlEntry();
        ace.setDenyDelete(true);
        ZKAccessControl zkac = new ZKAccessControl(ace, zkPath);
        Utils.ioResult((CompletableFuture)zkac.create(this.zkc));
        ZKAccessControl readZKAC = (ZKAccessControl)Utils.ioResult((CompletableFuture)ZKAccessControl.read((ZooKeeperClient)this.zkc, (String)zkPath, null));
        Assert.assertEquals((Object)zkac, (Object)readZKAC);
        ace.setDenyRelease(true);
        ZKAccessControl newZKAC = new ZKAccessControl(ace, zkPath);
        Utils.ioResult((CompletableFuture)newZKAC.update(this.zkc));
        ZKAccessControl readZKAC2 = (ZKAccessControl)Utils.ioResult((CompletableFuture)ZKAccessControl.read((ZooKeeperClient)this.zkc, (String)zkPath, null));
        Assert.assertEquals((Object)newZKAC, (Object)readZKAC2);
        try {
            FutureUtils.result((CompletableFuture)readZKAC.update(this.zkc));
        }
        catch (KeeperException.BadVersionException badVersionException) {
            // empty catch block
        }
        readZKAC2.getAccessControlEntry().setDenyTruncate(true);
        Utils.ioResult((CompletableFuture)readZKAC2.update(this.zkc));
        ZKAccessControl readZKAC3 = (ZKAccessControl)Utils.ioResult((CompletableFuture)ZKAccessControl.read((ZooKeeperClient)this.zkc, (String)zkPath, null));
        Assert.assertEquals((Object)readZKAC2, (Object)readZKAC3);
    }
}

