/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import org.apache.cassandra.auth.AuthCacheMBean;
import org.apache.cassandra.auth.CacheRefresher;
import org.apache.cassandra.concurrent.ExecutorFactory;
import org.apache.cassandra.concurrent.ExecutorPlus;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.concurrent.Shutdownable;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.utils.ExecutorUtils;
import org.apache.cassandra.utils.MBeanWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthCache<K, V>
implements AuthCacheMBean,
Shutdownable {
    private static final Logger logger = LoggerFactory.getLogger(AuthCache.class);
    public static final String MBEAN_NAME_BASE = "org.apache.cassandra.auth:type=";
    private volatile ScheduledFuture cacheRefresher = null;
    private static final Set<Shutdownable> REGISTRY = new HashSet<Shutdownable>(4);
    protected volatile LoadingCache<K, V> cache;
    private ExecutorPlus cacheRefreshExecutor;
    private final String name;
    private final IntConsumer setValidityDelegate;
    private final IntSupplier getValidityDelegate;
    private final IntConsumer setUpdateIntervalDelegate;
    private final IntSupplier getUpdateIntervalDelegate;
    private final IntConsumer setMaxEntriesDelegate;
    private final IntSupplier getMaxEntriesDelegate;
    private final Consumer<Boolean> setActiveUpdate;
    private final BooleanSupplier getActiveUpdate;
    private final Function<K, V> loadFunction;
    private final Supplier<Map<K, V>> bulkLoadFunction;
    private final BooleanSupplier enableCache;
    private final BiPredicate<K, V> invalidateCondition;

    public static void shutdownAllAndWait(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        ExecutorUtils.shutdownNowAndWait(timeout, unit, REGISTRY);
    }

    protected AuthCache(String name, IntConsumer setValidityDelegate, IntSupplier getValidityDelegate, IntConsumer setUpdateIntervalDelegate, IntSupplier getUpdateIntervalDelegate, IntConsumer setMaxEntriesDelegate, IntSupplier getMaxEntriesDelegate, Consumer<Boolean> setActiveUpdate, BooleanSupplier getActiveUpdate, Function<K, V> loadFunction, Supplier<Map<K, V>> bulkLoadFunction, BooleanSupplier cacheEnabledDelegate) {
        this(name, setValidityDelegate, getValidityDelegate, setUpdateIntervalDelegate, getUpdateIntervalDelegate, setMaxEntriesDelegate, getMaxEntriesDelegate, setActiveUpdate, getActiveUpdate, loadFunction, bulkLoadFunction, cacheEnabledDelegate, (k, v) -> false);
    }

    protected AuthCache(String name, IntConsumer setValidityDelegate, IntSupplier getValidityDelegate, IntConsumer setUpdateIntervalDelegate, IntSupplier getUpdateIntervalDelegate, IntConsumer setMaxEntriesDelegate, IntSupplier getMaxEntriesDelegate, Consumer<Boolean> setActiveUpdate, BooleanSupplier getActiveUpdate, Function<K, V> loadFunction, Supplier<Map<K, V>> bulkLoadFunction, BooleanSupplier cacheEnabledDelegate, BiPredicate<K, V> invalidationCondition) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.setValidityDelegate = (IntConsumer)Preconditions.checkNotNull((Object)setValidityDelegate);
        this.getValidityDelegate = (IntSupplier)Preconditions.checkNotNull((Object)getValidityDelegate);
        this.setUpdateIntervalDelegate = (IntConsumer)Preconditions.checkNotNull((Object)setUpdateIntervalDelegate);
        this.getUpdateIntervalDelegate = (IntSupplier)Preconditions.checkNotNull((Object)getUpdateIntervalDelegate);
        this.setMaxEntriesDelegate = (IntConsumer)Preconditions.checkNotNull((Object)setMaxEntriesDelegate);
        this.getMaxEntriesDelegate = (IntSupplier)Preconditions.checkNotNull((Object)getMaxEntriesDelegate);
        this.setActiveUpdate = (Consumer)Preconditions.checkNotNull(setActiveUpdate);
        this.getActiveUpdate = (BooleanSupplier)Preconditions.checkNotNull((Object)getActiveUpdate);
        this.loadFunction = (Function)Preconditions.checkNotNull(loadFunction);
        this.bulkLoadFunction = (Supplier)Preconditions.checkNotNull(bulkLoadFunction);
        this.enableCache = (BooleanSupplier)Preconditions.checkNotNull((Object)cacheEnabledDelegate);
        this.invalidateCondition = (BiPredicate)Preconditions.checkNotNull(invalidationCondition);
        this.init();
    }

    protected void init() {
        this.cacheRefreshExecutor = ExecutorFactory.Global.executorFactory().sequential(this.name + "Refresh");
        this.cache = this.initCache(null);
        MBeanWrapper.instance.registerMBean((Object)this, this.getObjectName());
        REGISTRY.add(this);
    }

    protected void unregisterMBean() {
        MBeanWrapper.instance.unregisterMBean(this.getObjectName(), MBeanWrapper.OnException.LOG);
    }

    protected String getObjectName() {
        return MBEAN_NAME_BASE + this.name;
    }

    public Map<K, V> getAll() {
        if (this.cache == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.cache.asMap());
    }

    public V get(K k) {
        if (this.cache == null) {
            return this.loadFunction.apply(k);
        }
        return (V)this.cache.get(k);
    }

    @Override
    public synchronized void invalidate() {
        this.cache = this.initCache(null);
    }

    public void invalidate(K k) {
        if (this.cache != null) {
            this.cache.invalidate(k);
        }
    }

    @Override
    public synchronized void setValidity(int validityPeriod) {
        if (CassandraRelevantProperties.DISABLE_AUTH_CACHES_REMOTE_CONFIGURATION.getBoolean()) {
            throw new UnsupportedOperationException("Remote configuration of auth caches is disabled");
        }
        this.setValidityDelegate.accept(validityPeriod);
        this.cache = this.initCache(this.cache);
    }

    @Override
    public int getValidity() {
        return this.getValidityDelegate.getAsInt();
    }

    @Override
    public synchronized void setUpdateInterval(int updateInterval) {
        if (CassandraRelevantProperties.DISABLE_AUTH_CACHES_REMOTE_CONFIGURATION.getBoolean()) {
            throw new UnsupportedOperationException("Remote configuration of auth caches is disabled");
        }
        this.setUpdateIntervalDelegate.accept(updateInterval);
        this.cache = this.initCache(this.cache);
    }

    @Override
    public int getUpdateInterval() {
        return this.getUpdateIntervalDelegate.getAsInt();
    }

    @Override
    public synchronized void setMaxEntries(int maxEntries) {
        if (CassandraRelevantProperties.DISABLE_AUTH_CACHES_REMOTE_CONFIGURATION.getBoolean()) {
            throw new UnsupportedOperationException("Remote configuration of auth caches is disabled");
        }
        this.setMaxEntriesDelegate.accept(maxEntries);
        this.cache = this.initCache(this.cache);
    }

    @Override
    public int getMaxEntries() {
        return this.getMaxEntriesDelegate.getAsInt();
    }

    @Override
    public boolean getActiveUpdate() {
        return this.getActiveUpdate.getAsBoolean();
    }

    @Override
    public synchronized void setActiveUpdate(boolean update) {
        if (CassandraRelevantProperties.DISABLE_AUTH_CACHES_REMOTE_CONFIGURATION.getBoolean()) {
            throw new UnsupportedOperationException("Remote configuration of auth caches is disabled");
        }
        this.setActiveUpdate.accept(update);
        this.cache = this.initCache(this.cache);
    }

    @Override
    public long getEstimatedSize() {
        return this.cache == null ? 0L : this.cache.estimatedSize();
    }

    protected LoadingCache<K, V> initCache(LoadingCache<K, V> existing) {
        LoadingCache updatedCache;
        if (!this.enableCache.getAsBoolean()) {
            return null;
        }
        if (this.getValidity() <= 0) {
            return null;
        }
        boolean activeUpdate = this.getActiveUpdate();
        logger.info("(Re)initializing {} (validity period/update interval/max entries/active update) ({}/{}/{}/{})", new Object[]{this.name, this.getValidity(), this.getUpdateInterval(), this.getMaxEntries(), activeUpdate});
        if (existing == null) {
            updatedCache = Caffeine.newBuilder().refreshAfterWrite(activeUpdate ? (long)this.getValidity() : (long)this.getUpdateInterval(), TimeUnit.MILLISECONDS).expireAfterWrite((long)this.getValidity(), TimeUnit.MILLISECONDS).maximumSize((long)this.getMaxEntries()).executor((Executor)this.cacheRefreshExecutor).build(this.loadFunction::apply);
        } else {
            updatedCache = this.cache;
            this.cache.policy().refreshAfterWrite().ifPresent(policy -> policy.setRefreshesAfter(activeUpdate ? (long)this.getValidity() : (long)this.getUpdateInterval(), TimeUnit.MILLISECONDS));
            this.cache.policy().expireAfterWrite().ifPresent(policy -> policy.setExpiresAfter((long)this.getValidity(), TimeUnit.MILLISECONDS));
            this.cache.policy().eviction().ifPresent(policy -> policy.setMaximum((long)this.getMaxEntries()));
        }
        if (this.cacheRefresher != null) {
            this.cacheRefresher.cancel(false);
            this.cacheRefresher = null;
        }
        if (activeUpdate) {
            this.cacheRefresher = ScheduledExecutors.optionalTasks.scheduleAtFixedRate(CacheRefresher.create(this.name, updatedCache, this.invalidateCondition), this.getUpdateInterval(), this.getUpdateInterval(), TimeUnit.MILLISECONDS);
        }
        return updatedCache;
    }

    @Override
    public boolean isTerminated() {
        return this.cacheRefreshExecutor.isTerminated();
    }

    @Override
    public void shutdown() {
        this.cacheRefreshExecutor.shutdown();
    }

    @Override
    public Object shutdownNow() {
        return this.cacheRefreshExecutor.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit units) throws InterruptedException {
        return this.cacheRefreshExecutor.awaitTermination(timeout, units);
    }

    public void warm() {
        if (this.cache == null) {
            logger.info("{} cache not enabled, skipping pre-warming", (Object)this.name);
            return;
        }
        int retries = CassandraRelevantProperties.AUTH_CACHE_WARMING_MAX_RETRIES.getInt(10);
        long retryInterval = CassandraRelevantProperties.AUTH_CACHE_WARMING_RETRY_INTERVAL_MS.getLong(1000L);
        while (retries-- > 0) {
            try {
                Map<K, V> entries = this.bulkLoadFunction.get();
                this.cache.putAll(entries);
                break;
            }
            catch (Exception e) {
                Uninterruptibles.sleepUninterruptibly((long)retryInterval, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }
    }

    public static interface BulkLoader<K, V> {
        default public Supplier<Map<K, V>> bulkLoader() {
            return Collections::emptyMap;
        }
    }
}

