/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.function.LongPredicate;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionIterator;
import org.apache.cassandra.db.compaction.CompactionStrategyManager;
import org.apache.cassandra.db.compaction.CompactionTask;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableRewriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.cassandra.utils.TimeUUID;

public class Upgrader {
    private final ColumnFamilyStore cfs;
    private final SSTableReader sstable;
    private final LifecycleTransaction transaction;
    private final File directory;
    private final CompactionController controller;
    private final CompactionStrategyManager strategyManager;
    private final long estimatedRows;
    private final OutputHandler outputHandler;

    public Upgrader(ColumnFamilyStore cfs, LifecycleTransaction txn, OutputHandler outputHandler) {
        this.cfs = cfs;
        this.transaction = txn;
        this.sstable = txn.onlyOne();
        this.outputHandler = outputHandler;
        this.directory = new File(this.sstable.getFilename()).parent();
        this.controller = new UpgradeController(cfs);
        this.strategyManager = cfs.getCompactionStrategyManager();
        long estimatedTotalKeys = Math.max((long)cfs.metadata().params.minIndexInterval, SSTableReader.getApproximateKeyCount(Collections.singletonList(this.sstable)));
        long estimatedSSTables = Math.max(1L, SSTableReader.getTotalBytes(Collections.singletonList(this.sstable)) / this.strategyManager.getMaxSSTableBytes());
        this.estimatedRows = (long)Math.ceil((double)estimatedTotalKeys / (double)estimatedSSTables);
    }

    private SSTableWriter createCompactionWriter(StatsMetadata metadata) {
        MetadataCollector sstableMetadataCollector = new MetadataCollector(this.cfs.getComparator());
        sstableMetadataCollector.sstableLevel(this.sstable.getSSTableLevel());
        Descriptor descriptor = this.cfs.newSSTableDescriptor(this.directory);
        return ((SSTableWriter.Builder)((SSTableWriter.Builder)((SSTableWriter.Builder)((SSTableWriter.Builder)((SSTableWriter.Builder)((SSTable.Builder)((SSTableWriter.Builder)((SSTableWriter.Builder)((SSTableWriter.Builder)((SSTableWriter.Builder)descriptor.getFormat().getWriterFactory().builder(descriptor)).setKeyCount(this.estimatedRows)).setRepairedAt(metadata.repairedAt)).setPendingRepair(metadata.pendingRepair)).setTransientSSTable(metadata.isTransient)).setTableMetadataRef(this.cfs.metadata)).setMetadataCollector(sstableMetadataCollector)).setSerializationHeader(SerializationHeader.make(this.cfs.metadata(), Sets.newHashSet((Object[])new SSTableReader[]{this.sstable})))).addDefaultComponents(this.cfs.indexManager.listIndexGroups())).setSecondaryIndexGroups(this.cfs.indexManager.listIndexGroups())).build(this.transaction, this.cfs);
    }

    public void upgrade(boolean keepOriginals) {
        this.outputHandler.output("Upgrading " + this.sstable);
        long nowInSec = FBUtilities.nowInSeconds();
        try (SSTableRewriter writer = SSTableRewriter.construct(this.cfs, this.transaction, keepOriginals, CompactionTask.getMaxDataAge(this.transaction.originals()));
             AbstractCompactionStrategy.ScannerList scanners = this.strategyManager.getScanners(this.transaction.originals());
             CompactionIterator iter = new CompactionIterator(this.transaction.opType(), scanners.scanners, this.controller, nowInSec, TimeUUID.Generator.nextTimeUUID());){
            writer.switchWriter(this.createCompactionWriter(this.sstable.getSSTableMetadata()));
            iter.setTargetDirectory(writer.currentWriter().getFilename());
            while (iter.hasNext()) {
                writer.append(iter.next());
            }
            writer.finish();
            this.outputHandler.output("Upgrade of " + this.sstable + " complete.");
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.controller.close();
        }
    }

    private static class UpgradeController
    extends CompactionController {
        public UpgradeController(ColumnFamilyStore cfs) {
            super(cfs, Integer.MAX_VALUE);
        }

        @Override
        public LongPredicate getPurgeEvaluator(DecoratedKey key) {
            return time -> false;
        }
    }
}

