/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import java.util.function.ToLongFunction;
import java.util.stream.StreamSupport;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.KeyspaceMetrics;
import org.apache.cassandra.metrics.MetricNameFactory;

public class StorageMetrics {
    private static final MetricNameFactory factory = new DefaultNameFactory("Storage");
    public static final Counter load = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("Load"));
    public static final Counter uncompressedLoad = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("UncompressedLoad"));
    public static final Gauge<Long> unreplicatedLoad = StorageMetrics.createSummingGauge("UnreplicatedLoad", metric -> (Long)metric.unreplicatedLiveDiskSpaceUsed.getValue());
    public static final Gauge<Long> unreplicatedUncompressedLoad = StorageMetrics.createSummingGauge("UnreplicatedUncompressedLoad", metric -> (Long)metric.unreplicatedUncompressedLiveDiskSpaceUsed.getValue());
    public static final Counter uncaughtExceptions = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("Exceptions"));
    public static final Counter totalHintsInProgress = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("TotalHintsInProgress"));
    public static final Counter totalHints = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("TotalHints"));
    public static final Counter repairExceptions = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("RepairExceptions"));
    public static final Counter totalOpsForInvalidToken = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("TotalOpsForInvalidToken"));
    public static final Counter startupOpsForInvalidToken = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("StartupOpsForInvalidToken"));

    private static Gauge<Long> createSummingGauge(String name, ToLongFunction<KeyspaceMetrics> extractor) {
        return CassandraMetricsRegistry.Metrics.register(factory.createMetricName(name), () -> StreamSupport.stream(Keyspace.all().spliterator(), false).mapToLong(keyspace -> extractor.applyAsLong(keyspace.metric)).sum());
    }
}

