/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import javax.management.ObjectName;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MBeanWrapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mx4jTool {
    private static final Logger logger = LoggerFactory.getLogger(Mx4jTool.class);

    public static boolean maybeLoad() {
        try {
            logger.trace("Will try to load mx4j now, if it's in the classpath");
            MBeanWrapper mbs = MBeanWrapper.instance;
            ObjectName processorName = new ObjectName("Server:name=XSLTProcessor");
            Class<?> httpAdaptorClass = Class.forName("mx4j.tools.adaptor.http.HttpAdaptor");
            Object httpAdaptor = httpAdaptorClass.newInstance();
            httpAdaptorClass.getMethod("setHost", String.class).invoke(httpAdaptor, Mx4jTool.getAddress());
            httpAdaptorClass.getMethod("setPort", Integer.TYPE).invoke(httpAdaptor, Mx4jTool.getPort());
            ObjectName httpName = new ObjectName("system:name=http");
            mbs.registerMBean(httpAdaptor, httpName);
            Class<?> xsltProcessorClass = Class.forName("mx4j.tools.adaptor.http.XSLTProcessor");
            Object xsltProcessor = xsltProcessorClass.newInstance();
            httpAdaptorClass.getMethod("setProcessor", Class.forName("mx4j.tools.adaptor.http.ProcessorMBean")).invoke(httpAdaptor, xsltProcessor);
            mbs.registerMBean(xsltProcessor, processorName);
            httpAdaptorClass.getMethod("start", new Class[0]).invoke(httpAdaptor, new Object[0]);
            logger.info("mx4j successfuly loaded");
            return true;
        }
        catch (ClassNotFoundException e) {
            logger.trace("Will not load MX4J, mx4j-tools.jar is not in the classpath");
        }
        catch (Exception e) {
            logger.warn("Could not start register mbean in JMX", (Throwable)e);
        }
        return false;
    }

    private static String getAddress() {
        String sAddress = CassandraRelevantProperties.MX4JADDRESS.getString();
        if (StringUtils.isEmpty((CharSequence)sAddress)) {
            sAddress = FBUtilities.getBroadcastAddressAndPort().getAddress().getHostAddress();
        }
        return sAddress;
    }

    private static int getPort() {
        int port = 8081;
        String sPort = CassandraRelevantProperties.MX4JPORT.getString();
        if (StringUtils.isNotEmpty((CharSequence)sPort)) {
            port = Integer.parseInt(sPort);
        }
        return port;
    }
}

