/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.LongPredicate;
import net.openhft.chronicle.core.internal.invariant.longs.LongBiCondition;
import net.openhft.chronicle.core.internal.invariant.longs.LongCondition;
import net.openhft.chronicle.core.internal.invariant.longs.LongTriCondition;
import net.openhft.chronicle.core.util.LongBiPredicate;
import net.openhft.chronicle.core.util.LongTriPredicate;

public final class Longs {
    private Longs() {
    }

    public static long requireNonNegative(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException(Longs.failDescription(Longs.negative().negate(), value));
        }
        return value;
    }

    public static long require(LongPredicate requirement, long value) {
        return Longs.require(requirement, value, IllegalArgumentException::new);
    }

    public static <X extends RuntimeException> long require(LongPredicate requirement, long value, Function<String, X> exceptionMapper) {
        Objects.requireNonNull(exceptionMapper);
        if (!requirement.test(value)) {
            throw (RuntimeException)exceptionMapper.apply(Longs.failDescription(requirement, value));
        }
        return value;
    }

    public static long require(LongBiPredicate requirement, long value, long otherValue) {
        if (!requirement.test(value, otherValue)) {
            throw new IllegalArgumentException(Longs.failDescription(requirement, value, otherValue));
        }
        return value;
    }

    public static <X extends RuntimeException> long require(LongBiPredicate requirement, long value, long otherValue, Function<String, X> exceptionMapper) {
        Objects.requireNonNull(exceptionMapper);
        if (!requirement.test(value, otherValue)) {
            throw (RuntimeException)exceptionMapper.apply(Longs.failDescription(requirement, value, otherValue));
        }
        return value;
    }

    public static long require(LongTriPredicate requirement, long value, long otherFirstValue, long otherSecondValue) {
        return Longs.require(requirement, value, otherFirstValue, otherSecondValue, IllegalArgumentException::new);
    }

    public static <X extends RuntimeException> long require(LongTriPredicate requirement, long value, long otherFirstValue, long otherSecondValue, Function<String, X> exceptionMapper) {
        Objects.requireNonNull(exceptionMapper);
        if (!requirement.test(value, otherFirstValue, otherSecondValue)) {
            throw (RuntimeException)exceptionMapper.apply(Longs.failDescription(requirement, value, otherFirstValue, otherSecondValue));
        }
        return value;
    }

    public static boolean assertIfEnabled(LongPredicate requirement, long value) {
        return true;
    }

    public static boolean assertIfEnabled(LongBiPredicate requirement, long value, long otherValue) {
        return true;
    }

    public static boolean assertIfEnabled(LongTriPredicate requirement, long value, long otherFirstValue, long otherSecondValue) {
        return true;
    }

    public static String failDescription(LongPredicate requirement, long value) {
        return String.format("The provided value (%d) is illegal because it does not satisfy the provided requirement: %d %s", value, value, requirement);
    }

    public static String failDescription(LongBiPredicate requirement, long value, long otherValue) {
        return String.format("The provided value (%d) is illegal because it does not satisfy the provided requirement: %d %s %d", value, value, requirement, otherValue);
    }

    public static String failDescription(LongTriPredicate requirement, long value, long otherFirstValue, long otherSecondValue) {
        return String.format("The provided value (%d) is illegal because it does not satisfy the provided requirement: %d %s (%d, %d)", value, value, requirement, otherFirstValue, otherSecondValue);
    }

    public static LongPredicate positive() {
        return LongCondition.POSITIVE;
    }

    public static LongPredicate negative() {
        return LongCondition.NEGATIVE;
    }

    public static LongPredicate nonNegative() {
        return LongCondition.NON_NEGATIVE;
    }

    public static LongPredicate zero() {
        return LongCondition.ZERO;
    }

    public static LongPredicate byteConvertible() {
        return LongCondition.BYTE_CONVERTIBLE;
    }

    public static LongPredicate shortConvertible() {
        return LongCondition.SHORT_CONVERTIBLE;
    }

    public static LongPredicate evenPowerOfTwo() {
        return LongCondition.EVEN_POWER_OF_TWO;
    }

    public static LongPredicate shortAligned() {
        return LongCondition.SHORT_ALIGNED;
    }

    public static LongPredicate intAligned() {
        return LongCondition.INT_ALIGNED;
    }

    public static LongPredicate longAligned() {
        return LongCondition.LONG_ALIGNED;
    }

    public static LongBiPredicate equalTo() {
        return LongBiCondition.EQUAL_TO;
    }

    public static LongBiPredicate greaterThan() {
        return LongBiCondition.GREATER_THAN;
    }

    public static LongBiPredicate greaterOrEqual() {
        return LongBiCondition.GREATER_OR_EQUAL;
    }

    public static LongBiPredicate lessThan() {
        return LongBiCondition.LESS_THAN;
    }

    public static LongBiPredicate lessOrEqual() {
        return LongBiCondition.LESS_OR_EQUAL;
    }

    public static LongBiPredicate betweenZeroAnd() {
        return LongBiCondition.BETWEEN_ZERO_AND;
    }

    public static LongBiPredicate betweenZeroAndClosed() {
        return LongBiCondition.BETWEEN_ZERO_AND_CLOSED;
    }

    public static LongBiPredicate powerOfTwo() {
        return LongBiCondition.POWER_OF_TWO;
    }

    public static LongBiPredicate log2() {
        return LongBiCondition.LOG2;
    }

    public static LongTriPredicate between() {
        return LongTriCondition.BETWEEN;
    }

    public static LongTriPredicate betweenClosed() {
        return LongTriCondition.BETWEEN_CLOSED;
    }

    public static LongTriPredicate betweenZeroAndReserving() {
        return LongTriCondition.BETWEEN_ZERO_AND_ENSURING;
    }
}

