/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal;

import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.internal.Script;
import org.apache.commons.jexl3.parser.ASTIdentifier;
import org.apache.commons.jexl3.parser.ASTIdentifierAccess;
import org.apache.commons.jexl3.parser.JexlNode;

public class Dumper {
    private final StringBuilder strb = new StringBuilder();
    private int indent;

    public static String toString(JexlScript script) {
        return new Dumper(script).toString();
    }

    private Dumper(JexlScript script) {
        this.dump((JexlNode)((Script)script).script, null);
    }

    private void dump(JexlNode node, Object data) {
        int num = node.jjtGetNumChildren();
        this.indent();
        this.strb.append(node.getClass().getSimpleName());
        if (node instanceof ASTIdentifier || node instanceof ASTIdentifierAccess) {
            this.strb.append("@");
            this.strb.append(node.toString());
        }
        this.strb.append('(');
        ++this.indent;
        for (int c = 0; c < num; ++c) {
            JexlNode child = node.jjtGetChild(c);
            if (c > 0) {
                this.strb.append(',');
            }
            this.strb.append('\n');
            this.dump(child, data);
        }
        --this.indent;
        if (num > 0) {
            this.strb.append('\n');
            this.indent();
        }
        this.strb.append(')');
    }

    private void indent() {
        for (int i = 0; i < this.indent; ++i) {
            this.strb.append("  ");
        }
    }

    public String toString() {
        return this.strb.toString();
    }
}

