/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.SortedSet;
import org.apache.rat.ImplementationException;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.license.ILicenseFamily;

public interface BuilderParams {
    default public Method get(String name) {
        try {
            return this.getClass().getMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ImplementationException(String.format("method '%s' is not found in %s", name, this.getClass()));
        }
        catch (IllegalArgumentException e) {
            throw new ImplementationException(String.format("method '%s' in %s can not be retrieved", name, this.getClass()), e);
        }
    }

    public Map<String, IHeaderMatcher> matcherMap();

    public SortedSet<ILicenseFamily> licenseFamilies();
}

