/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.fluent.models.SecurityPartnerProviderPropertiesFormat;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.SecurityPartnerProviderConnectionStatus;
import com.azure.resourcemanager.network.models.SecurityProviderName;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class SecurityPartnerProviderInner
extends Resource {
    @JsonProperty(value="properties")
    private SecurityPartnerProviderPropertiesFormat innerProperties;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="id")
    private String id;

    private SecurityPartnerProviderPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public SecurityPartnerProviderInner withId(String id) {
        this.id = id;
        return this;
    }

    public SecurityPartnerProviderInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public SecurityPartnerProviderInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public SecurityProviderName securityProviderName() {
        return this.innerProperties() == null ? null : this.innerProperties().securityProviderName();
    }

    public SecurityPartnerProviderInner withSecurityProviderName(SecurityProviderName securityProviderName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityPartnerProviderPropertiesFormat();
        }
        this.innerProperties().withSecurityProviderName(securityProviderName);
        return this;
    }

    public SecurityPartnerProviderConnectionStatus connectionStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionStatus();
    }

    public SubResource virtualHub() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualHub();
    }

    public SecurityPartnerProviderInner withVirtualHub(SubResource virtualHub) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityPartnerProviderPropertiesFormat();
        }
        this.innerProperties().withVirtualHub(virtualHub);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

