/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.validator.resource;

import org.apache.dolphinscheduler.api.dto.resources.RenameFileDto;
import org.apache.dolphinscheduler.api.validator.resource.AbstractResourceValidator;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.repository.TenantDao;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.springframework.stereotype.Component;

@Component
public class RenameFileDtoValidator
extends AbstractResourceValidator<RenameFileDto> {
    public RenameFileDtoValidator(StorageOperator storageOperator, TenantDao tenantDao) {
        super(storageOperator, tenantDao);
    }

    @Override
    public void validate(RenameFileDto renameFileDto) {
        String originFileAbsolutePath = renameFileDto.getOriginFileAbsolutePath();
        User loginUser = renameFileDto.getLoginUser();
        String targetFileAbsolutePath = renameFileDto.getTargetFileAbsolutePath();
        this.exceptionResourceAbsolutePathInvalidated(originFileAbsolutePath);
        this.exceptionResourceNotExists(originFileAbsolutePath);
        this.exceptionResourceIsNotFile(originFileAbsolutePath);
        this.exceptionUserNoResourcePermission(loginUser, originFileAbsolutePath);
        this.exceptionResourceAbsolutePathInvalidated(targetFileAbsolutePath);
        this.exceptionResourceExists(targetFileAbsolutePath);
        this.exceptionResourceIsNotFile(targetFileAbsolutePath);
        this.exceptionUserNoResourcePermission(loginUser, targetFileAbsolutePath);
    }
}

