/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.keys.cryptography.AsymmetricSignatureAlgorithm;
import com.azure.security.keyvault.keys.cryptography.ISignatureTransform;
import com.azure.security.keyvault.keys.cryptography.SignatureEncoding;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.Provider;
import java.security.Signature;

abstract class Ecdsa
extends AsymmetricSignatureAlgorithm {
    private final ClientLogger logger = new ClientLogger(Ecdsa.class);

    protected Ecdsa() {
        super("NONEwithECDSA");
    }

    public ISignatureTransform createSignatureTransform(KeyPair key, Provider provider) {
        return new EcdsaSignatureTransform(key, provider, this);
    }

    public abstract int getDigestLength();

    public abstract int getCoordLength();

    class EcdsaSignatureTransform
    implements ISignatureTransform {
        private static final String ALGORITHM = "NONEwithECDSA";
        private final KeyPair keyPair;
        private final Provider provider;
        private final Ecdsa algorithm;

        EcdsaSignatureTransform(KeyPair keyPair, Provider provider, Ecdsa algorithm) {
            this.keyPair = keyPair;
            this.provider = provider;
            this.algorithm = algorithm;
        }

        @Override
        public byte[] sign(byte[] digest) throws GeneralSecurityException {
            this.checkDigestLength(digest);
            Signature signature = Signature.getInstance(ALGORITHM, this.provider);
            signature.initSign(this.keyPair.getPrivate());
            signature.update(digest);
            return SignatureEncoding.fromAsn1Der(signature.sign(), this.algorithm);
        }

        @Override
        public boolean verify(byte[] digest, byte[] signature) throws GeneralSecurityException {
            Signature verify = Signature.getInstance(ALGORITHM, this.provider);
            this.checkDigestLength(digest);
            signature = SignatureEncoding.toAsn1Der(signature, this.algorithm);
            verify.initVerify(this.keyPair.getPublic());
            verify.update(digest);
            return verify.verify(signature);
        }

        private void checkDigestLength(byte[] digest) {
            if (digest.length != Ecdsa.this.getDigestLength()) {
                throw Ecdsa.this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Invalid digest length."));
            }
        }
    }
}

