/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model;

import com.qcloud.cos.internal.SdkFilterInputStream;
import com.qcloud.cos.utils.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.client.methods.HttpRequestBase;

public class COSObjectInputStream
extends SdkFilterInputStream {
    private final HttpRequestBase httpRequest;
    private boolean eof;

    public COSObjectInputStream(InputStream in, HttpRequestBase httpRequest) {
        super(in);
        this.httpRequest = httpRequest;
    }

    @Override
    public void abort() {
        this.doAbort();
    }

    private void doAbort() {
        if (this.httpRequest != null) {
            this.httpRequest.abort();
        }
        IOUtils.closeQuietly(this.in, null);
    }

    public HttpRequestBase getHttpRequest() {
        return this.httpRequest;
    }

    @Override
    public int available() throws IOException {
        int estimate = super.available();
        return estimate == 0 ? 1 : estimate;
    }

    @Override
    public int read() throws IOException {
        int value = super.read();
        if (value == -1) {
            this.eof = true;
        }
        return value;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int value = super.read(b, off, len);
        if (value == -1) {
            this.eof = true;
        }
        return value;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.eof = false;
    }

    @Override
    public void close() throws IOException {
        if (this.eof) {
            super.close();
            this.httpRequest.releaseConnection();
        } else {
            this.doAbort();
        }
    }
}

