/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert.service;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.dolphinscheduler.alert.service.EventLoop;
import org.apache.dolphinscheduler.alert.service.EventPendingQueue;
import org.apache.dolphinscheduler.common.thread.BaseDaemonThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventLoop<T>
extends BaseDaemonThread
implements EventLoop<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractEventLoop.class);
    private final EventPendingQueue<T> eventPendingQueue;
    private final AtomicInteger handlingEventCount;
    private final int eventHandleWorkerNum;
    private final ThreadPoolExecutor threadPoolExecutor;
    private final AtomicBoolean runningFlag = new AtomicBoolean(false);

    protected AbstractEventLoop(String name, ThreadPoolExecutor threadPoolExecutor, EventPendingQueue<T> eventPendingQueue) {
        super(name);
        this.handlingEventCount = new AtomicInteger(0);
        this.eventHandleWorkerNum = threadPoolExecutor.getMaximumPoolSize();
        this.threadPoolExecutor = threadPoolExecutor;
        this.eventPendingQueue = eventPendingQueue;
    }

    @Override
    public synchronized void start() {
        if (!this.runningFlag.compareAndSet(false, true)) {
            throw new IllegalArgumentException(this.getClass().getName() + " is already started");
        }
        log.info("{} starting...", (Object)this.getClass().getName());
        super.start();
        log.info("{} started...", (Object)this.getClass().getName());
    }

    public void run() {
        while (this.runningFlag.get()) {
            try {
                if (this.handlingEventCount.get() >= this.eventHandleWorkerNum) {
                    log.debug("There is no idle event worker, waiting for a while...");
                    Thread.sleep(1000L);
                    continue;
                }
                T pendingEvent = this.eventPendingQueue.take();
                this.handlingEventCount.incrementAndGet();
                CompletableFuture.runAsync(() -> this.handleEvent(pendingEvent), this.threadPoolExecutor).whenComplete((aVoid, throwable) -> {
                    if (throwable != null) {
                        log.error("Handle event: {} error", pendingEvent, throwable);
                    }
                    this.handlingEventCount.decrementAndGet();
                });
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                log.error("Loop event thread has been interrupted...");
                break;
            }
            catch (Exception ex) {
                log.error("Loop event error", (Throwable)ex);
            }
        }
    }

    @Override
    public int getHandlingEventCount() {
        return this.handlingEventCount.get();
    }

    @Override
    public void shutdown() {
        if (!this.runningFlag.compareAndSet(true, false)) {
            log.warn(this.getClass().getName() + " is not started");
        }
    }
}

