/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool.vendor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.pool.ValidConnectionChecker;
import com.alibaba.druid.pool.ValidConnectionCheckerAdapter;
import com.alibaba.druid.util.JdbcUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class OceanBaseValidConnectionChecker
extends ValidConnectionCheckerAdapter
implements ValidConnectionChecker {
    private String commonValidateQuery = "SELECT 'x' FROM DUAL";
    private DbType dbType;

    public OceanBaseValidConnectionChecker() {
        this.configFromProperties(System.getProperties());
        this.dbType = null;
    }

    public OceanBaseValidConnectionChecker(DbType dbType) {
        this.dbType = dbType;
        this.configFromProperties(System.getProperties());
    }

    @Override
    public boolean isValidConnection(Connection c, String validateQuery, int validationQueryTimeout) throws Exception {
        if (c.isClosed()) {
            return false;
        }
        if ((validateQuery == null || validateQuery.isEmpty()) && this.dbType != null) {
            validateQuery = this.commonValidateQuery;
        }
        Statement stmt = null;
        try {
            stmt = c.createStatement();
            if (validationQueryTimeout > 0) {
                stmt.setQueryTimeout(validationQueryTimeout);
            }
            stmt.execute(validateQuery);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            JdbcUtils.close(stmt);
        }
    }
}

