/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.workflow.trigger;

import java.io.Serializable;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionTypeEnum;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.model.SerialCommandDto;
import org.apache.dolphinscheduler.dao.repository.CommandDao;
import org.apache.dolphinscheduler.dao.repository.SerialCommandDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowDefinitionLogDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowInstanceDao;
import org.apache.dolphinscheduler.server.master.engine.workflow.trigger.IWorkflowTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractWorkflowInstanceTrigger<TriggerRequest, TriggerResponse>
implements IWorkflowTrigger<TriggerRequest, TriggerResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractWorkflowInstanceTrigger.class);
    @Autowired
    private WorkflowInstanceDao workflowInstanceDao;
    @Autowired
    private CommandDao commandDao;
    @Autowired
    protected SerialCommandDao serialCommandDao;
    @Autowired
    protected WorkflowDefinitionLogDao workflowDefinitionLogDao;

    @Override
    @Transactional
    public TriggerResponse triggerWorkflow(TriggerRequest triggerRequest) {
        WorkflowInstance workflowInstance = this.constructWorkflowInstance(triggerRequest);
        Long workflowDefinitionCode = workflowInstance.getWorkflowDefinitionCode();
        int workflowDefinitionVersion = workflowInstance.getWorkflowDefinitionVersion();
        WorkflowDefinitionLog workflowDefinition = this.workflowDefinitionLogDao.queryByDefinitionCodeAndVersion(workflowDefinitionCode.longValue(), workflowDefinitionVersion);
        if (workflowDefinition == null) {
            throw new IllegalStateException("Workflow definition not found: " + workflowDefinitionCode + " version: " + workflowDefinitionVersion);
        }
        Command command = this.constructTriggerCommand(triggerRequest, workflowInstance);
        if (workflowDefinition.getExecutionType() == WorkflowExecutionTypeEnum.PARALLEL) {
            this.workflowInstanceDao.updateById((Object)workflowInstance);
            this.commandDao.insert((Object)command);
        } else {
            workflowInstance.setState(WorkflowExecutionStatus.SERIAL_WAIT);
            this.workflowInstanceDao.updateById((Object)workflowInstance);
            this.serialCommandDao.insert((Object)SerialCommandDto.newSerialCommand((Command)command).toEntity());
        }
        return this.onTriggerSuccess(workflowInstance);
    }

    protected abstract WorkflowInstance constructWorkflowInstance(TriggerRequest var1);

    protected abstract Command constructTriggerCommand(TriggerRequest var1, WorkflowInstance var2);

    protected abstract TriggerResponse onTriggerSuccess(WorkflowInstance var1);

    protected WorkflowInstance getWorkflowInstance(Integer workflowInstanceId) {
        WorkflowInstance workflowInstance = (WorkflowInstance)this.workflowInstanceDao.queryById((Serializable)workflowInstanceId);
        if (workflowInstance == null) {
            throw new IllegalStateException("Workflow instance not found: " + workflowInstanceId);
        }
        return workflowInstance;
    }
}

