/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.failover;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.repository.WorkflowInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.apache.dolphinscheduler.registry.api.utils.RegistryUtils;
import org.apache.dolphinscheduler.server.master.cluster.ClusterManager;
import org.apache.dolphinscheduler.server.master.cluster.MasterServerMetadata;
import org.apache.dolphinscheduler.server.master.cluster.WorkerServerMetadata;
import org.apache.dolphinscheduler.server.master.engine.IWorkflowRepository;
import org.apache.dolphinscheduler.server.master.engine.system.event.GlobalMasterFailoverEvent;
import org.apache.dolphinscheduler.server.master.engine.system.event.MasterFailoverEvent;
import org.apache.dolphinscheduler.server.master.engine.system.event.WorkerFailoverEvent;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.ITaskExecutionRunnable;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.apache.dolphinscheduler.server.master.failover.IFailoverCoordinator;
import org.apache.dolphinscheduler.server.master.failover.TaskFailover;
import org.apache.dolphinscheduler.server.master.failover.WorkflowFailover;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FailoverCoordinator
implements IFailoverCoordinator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FailoverCoordinator.class);
    @Autowired
    private RegistryClient registryClient;
    @Autowired
    private ClusterManager clusterManager;
    @Autowired
    private IWorkflowRepository workflowRepository;
    @Autowired
    private TaskFailover taskFailover;
    @Autowired
    private WorkflowInstanceDao workflowInstanceDao;
    @Autowired
    private WorkflowFailover workflowFailover;

    @Override
    public void globalMasterFailover(GlobalMasterFailoverEvent globalMasterFailoverEvent) {
        StopWatch failoverTimeCost = StopWatch.createStarted();
        log.info("Global master failover starting");
        List masterAddressWhichContainsUnFinishedWorkflow = this.workflowInstanceDao.queryNeedFailoverMasters();
        for (String masterAddress : masterAddressWhichContainsUnFinishedWorkflow) {
            Optional<MasterServerMetadata> aliveMasterOptional = this.clusterManager.getMasterClusters().getServer(masterAddress);
            if (aliveMasterOptional.isPresent()) {
                MasterServerMetadata aliveMasterServerMetadata = aliveMasterOptional.get();
                log.info("The master[{}] is alive, do global master failover on it", (Object)aliveMasterServerMetadata);
                this.doMasterFailover(masterAddress, aliveMasterServerMetadata.getServerStartupTime(), RegistryUtils.getGlobalMasterFailoverNodePath((String)masterAddress));
                continue;
            }
            log.info("The master[{}] is not alive, do global master failover on it", (Object)masterAddress);
            this.doMasterFailover(masterAddress, globalMasterFailoverEvent.getEventTime().getTime(), RegistryUtils.getGlobalMasterFailoverNodePath((String)masterAddress));
        }
        failoverTimeCost.stop();
        log.info("Global master failover finished, cost: {}/ms", (Object)failoverTimeCost.getTime());
    }

    @Override
    public void failoverMaster(MasterFailoverEvent masterFailoverEvent) {
        MasterServerMetadata aliveMasterServerMetadata;
        MasterServerMetadata masterServerMetadata = masterFailoverEvent.getMasterServerMetadata();
        log.info("Master[{}] failover starting", (Object)masterServerMetadata);
        String masterAddress = masterServerMetadata.getAddress();
        Optional<MasterServerMetadata> aliveMasterOptional = this.clusterManager.getMasterClusters().getServer(masterAddress);
        if (aliveMasterOptional.isPresent() && (aliveMasterServerMetadata = aliveMasterOptional.get()).getServerStartupTime() == masterServerMetadata.getServerStartupTime()) {
            log.info("The master[{}] is alive, maybe it reconnect to registry skip failover", (Object)masterServerMetadata);
            return;
        }
        this.doMasterFailover(masterServerMetadata.getAddress(), masterFailoverEvent.getEventTime().getTime(), RegistryUtils.getFailoveredNodePath((String)masterServerMetadata.getAddress(), (long)masterServerMetadata.getServerStartupTime(), (int)masterServerMetadata.getProcessId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMasterFailover(String masterAddress, long workflowFailoverDeadline, String masterFailoverNodePath) {
        StopWatch failoverTimeCost = StopWatch.createStarted();
        this.registryClient.getLock(RegistryUtils.getMasterFailoverLockPath((String)masterAddress));
        try {
            if (this.registryClient.exists(masterFailoverNodePath) && String.valueOf(workflowFailoverDeadline).equals(this.registryClient.get(masterFailoverNodePath))) {
                log.error("The master[{}/{}] is exist at: {}, means it has already been failovered, skip failover", new Object[]{masterAddress, workflowFailoverDeadline, masterFailoverNodePath});
                return;
            }
            List<WorkflowInstance> needFailoverWorkflows = this.getFailoverWorkflowsForMaster(masterAddress, new Date(workflowFailoverDeadline));
            needFailoverWorkflows.forEach(this.workflowFailover::failoverWorkflow);
            this.registryClient.persist(masterFailoverNodePath, String.valueOf(workflowFailoverDeadline));
            failoverTimeCost.stop();
            log.info("Master[{}] failover {} workflows finished, cost: {}/ms", new Object[]{masterAddress, needFailoverWorkflows.size(), failoverTimeCost.getTime()});
        }
        finally {
            this.registryClient.releaseLock(RegistryNodeType.MASTER_FAILOVER_LOCK.getRegistryPath());
        }
    }

    private List<WorkflowInstance> getFailoverWorkflowsForMaster(String masterAddress, Date masterCrashTime) {
        List workflowInstances = this.workflowInstanceDao.queryNeedFailoverWorkflowInstances(masterAddress);
        return workflowInstances.stream().filter(workflowInstance -> {
            if (this.workflowRepository.contains(workflowInstance.getId())) {
                return false;
            }
            Date restartTime = workflowInstance.getRestartTime();
            if (restartTime != null) {
                return restartTime.before(masterCrashTime);
            }
            Date startTime = workflowInstance.getStartTime();
            return startTime.before(masterCrashTime);
        }).collect(Collectors.toList());
    }

    @Override
    public void failoverWorker(WorkerFailoverEvent workerFailoverEvent) {
        WorkerServerMetadata aliveWorkerServerMetadata;
        WorkerServerMetadata workerServerMetadata = workerFailoverEvent.getWorkerServerMetadata();
        log.info("Worker[{}] failover starting", (Object)workerServerMetadata);
        Optional<WorkerServerMetadata> aliveWorkerOptional = this.clusterManager.getWorkerClusters().getServer(workerServerMetadata.getAddress());
        if (aliveWorkerOptional.isPresent() && (aliveWorkerServerMetadata = aliveWorkerOptional.get()).getServerStartupTime() == workerServerMetadata.getServerStartupTime()) {
            log.info("The worker[{}] is alive, maybe it reconnect to registry skip failover", (Object)workerServerMetadata);
            return;
        }
        this.doWorkerFailover(workerServerMetadata.getAddress(), System.currentTimeMillis(), RegistryUtils.getFailoveredNodePath((String)workerServerMetadata.getAddress(), (long)workerServerMetadata.getServerStartupTime(), (int)workerServerMetadata.getProcessId()));
    }

    @Override
    public void cleanHistoryFailoverFinishedMarks() {
        Collection failoverFinishedMarkSuffixes = this.registryClient.getChildrenKeys(RegistryNodeType.FAILOVER_FINISH_NODES.getRegistryPath());
        if (CollectionUtils.isEmpty((Collection)failoverFinishedMarkSuffixes)) {
            return;
        }
        for (String failoverFinishedMarkSuffix : failoverFinishedMarkSuffixes) {
            String failoverFinishedMarkFullPath = RegistryNodeType.FAILOVER_FINISH_NODES.getRegistryPath() + "/" + failoverFinishedMarkSuffix;
            try {
                String failoverFinishTime = this.registryClient.get(failoverFinishedMarkFullPath);
                if (System.currentTimeMillis() - Long.parseLong(failoverFinishTime) <= TimeUnit.DAYS.toMillis(7L)) continue;
                this.registryClient.remove(failoverFinishedMarkFullPath);
                log.info("Clear the failover finished node: {} which failover time is before the current time minus 1 week", (Object)failoverFinishedMarkFullPath);
            }
            catch (Exception ex) {
                log.error("Failed to clean the failoverFinishedNode: {}", (Object)failoverFinishedMarkFullPath, (Object)ex);
            }
        }
    }

    private void doWorkerFailover(String workerAddress, long taskFailoverDeadline, String workerFailoverNodePath) {
        StopWatch failoverTimeCost = StopWatch.createStarted();
        List<ITaskExecutionRunnable> needFailoverTasks = this.getFailoverTaskForWorker(workerAddress, new Date(taskFailoverDeadline));
        needFailoverTasks.forEach(this.taskFailover::failoverTask);
        this.registryClient.persist(workerFailoverNodePath, String.valueOf(System.currentTimeMillis()));
        failoverTimeCost.stop();
        log.info("Worker[{}] failover {} tasks finished, cost: {}/ms", new Object[]{workerAddress, needFailoverTasks.size(), failoverTimeCost.getTime()});
    }

    private List<ITaskExecutionRunnable> getFailoverTaskForWorker(String workerAddress, Date taskFailoverDeadline) {
        return this.workflowRepository.getAll().stream().map(IWorkflowExecutionRunnable::getWorkflowExecutionGraph).flatMap(workflowExecutionGraph -> workflowExecutionGraph.getActiveTaskExecutionRunnable().stream()).filter(ITaskExecutionRunnable::isTaskInstanceInitialized).filter(taskExecutionRunnable -> workerAddress.equals(taskExecutionRunnable.getTaskInstance().getHost())).filter(taskExecutionRunnable -> {
            TaskExecutionStatus state = taskExecutionRunnable.getTaskInstance().getState();
            return state == TaskExecutionStatus.DISPATCH || state == TaskExecutionStatus.RUNNING_EXECUTION;
        }).filter(taskExecutionRunnable -> {
            Date submitTime = taskExecutionRunnable.getTaskInstance().getSubmitTime();
            return submitTime != null && submitTime.before(taskFailoverDeadline);
        }).collect(Collectors.toList());
    }
}

