// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

#pragma once
#include <string>

namespace doris {
namespace version {

extern const char* doris_build_version_prefix();
extern int doris_build_version_major();
extern int doris_build_version_minor();
extern int doris_build_version_patch();
extern int doris_build_version_hotfix();
extern const char* doris_build_version_rc_version();

extern const char* doris_build_version();
extern const char* doris_build_hash();
extern const char* doris_build_short_hash();
extern const char* doris_build_time();
extern const char* doris_build_info();
extern const std::string doris_feature_list();

} // namespace version

} // namespace doris
