/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.persist;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.tephra.metrics.MetricsCollector;
import org.apache.tephra.persist.TransactionEdit;
import org.apache.tephra.persist.TransactionLog;
import org.apache.tephra.persist.TransactionLogReader;
import org.apache.tephra.persist.TransactionLogWriter;
import org.apache.tephra.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.tephra.shaded.com.google.common.base.Stopwatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransactionLog
implements TransactionLog {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTransactionLog.class);
    private final AtomicLong logSequence = new AtomicLong();
    private final MetricsCollector metricsCollector;
    protected long timestamp;
    private volatile boolean initialized;
    private volatile boolean closing;
    private volatile boolean closed;
    private long writtenUpTo = 0L;
    private volatile long syncedUpTo = 0L;
    private final Queue<Entry> pendingWrites = new ConcurrentLinkedQueue<Entry>();
    private TransactionLogWriter writer;
    private int countSinceLastSync = 0;
    private long positionBeforeWrite = -1L;
    private final Stopwatch stopWatch = new Stopwatch();
    private final long slowAppendThreshold;

    AbstractTransactionLog(long timestamp, MetricsCollector metricsCollector, Configuration conf) {
        this.timestamp = timestamp;
        this.metricsCollector = metricsCollector;
        this.slowAppendThreshold = conf.getLong("data.tx.log.slow.append.threshold", 1000L);
    }

    private synchronized void init() throws IOException {
        if (this.initialized) {
            return;
        }
        this.writer = this.createWriter();
        this.initialized = true;
    }

    protected abstract TransactionLogWriter createWriter() throws IOException;

    @Override
    public abstract String getName();

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void append(TransactionEdit edit) throws IOException {
        this.append(Collections.singletonList(edit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(List<TransactionEdit> edits) throws IOException {
        if (this.closing) {
            throw new IOException("Log " + this.getName() + " is closing or already closed, cannot append");
        }
        if (!this.initialized) {
            this.init();
        }
        AtomicLong atomicLong = this.logSequence;
        synchronized (atomicLong) {
            for (TransactionEdit edit : edits) {
                this.pendingWrites.add(new Entry(new LongWritable(this.logSequence.getAndIncrement()), edit));
            }
        }
        this.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Entry[] getPendingWrites() {
        AbstractTransactionLog abstractTransactionLog = this;
        synchronized (abstractTransactionLog) {
            if (this.pendingWrites.isEmpty()) {
                return null;
            }
            Entry[] entriesToSync = new Entry[this.pendingWrites.size()];
            for (int i = 0; i < entriesToSync.length; ++i) {
                entriesToSync[i] = this.pendingWrites.remove();
            }
            return entriesToSync;
        }
    }

    private void startTimerIfNeeded(TransactionLogWriter writer, int entryCount) throws IOException {
        if (this.positionBeforeWrite == -1L) {
            this.positionBeforeWrite = writer.getPosition();
            this.countSinceLastSync = 0;
            this.stopWatch.reset().start();
        }
        this.countSinceLastSync += entryCount;
    }

    private void stopTimer(TransactionLogWriter writer) throws IOException {
        if (this.positionBeforeWrite != -1L) {
            this.stopWatch.stop();
            long elapsed = this.stopWatch.elapsedMillis();
            long bytesWritten = writer.getPosition() - this.positionBeforeWrite;
            if (elapsed >= this.slowAppendThreshold) {
                LOG.info("Slow append to log {}, took {} ms for {} entr{} and {} bytes.", new Object[]{this.getName(), elapsed, this.countSinceLastSync, this.countSinceLastSync == 1 ? "y" : "ies", bytesWritten});
            }
            this.metricsCollector.histogram("wal.sync.size", this.countSinceLastSync);
            this.metricsCollector.histogram("wal.sync.bytes", (int)bytesWritten);
        }
        this.positionBeforeWrite = -1L;
        this.countSinceLastSync = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync() throws IOException {
        long latestSeq = 0L;
        int entryCount = 0;
        AbstractTransactionLog abstractTransactionLog = this;
        synchronized (abstractTransactionLog) {
            if (this.closed) {
                if (this.pendingWrites.isEmpty()) {
                    return;
                }
                throw new IOException("Unexpected state: Writer is closed but there are pending edits. Cannot guarantee that edits were persisted");
            }
            Entry[] currentPending = this.getPendingWrites();
            if (currentPending != null) {
                entryCount = currentPending.length;
                this.startTimerIfNeeded(this.writer, entryCount);
                this.writer.commitMarker(entryCount);
                for (Entry e : currentPending) {
                    this.writer.append(e);
                }
                this.writtenUpTo = latestSeq = currentPending[currentPending.length - 1].getKey().get();
            }
        }
        if (this.syncedUpTo >= latestSeq) {
            return;
        }
        abstractTransactionLog = this;
        synchronized (abstractTransactionLog) {
            if (this.syncedUpTo >= latestSeq) {
                return;
            }
            if (this.closed) {
                throw new IOException(String.format("Unexpected state: Writer is closed but there are unsynced edits up to sequence id %d, and writes have been synced up to sequence id %d. Cannot guarantee that edits are persisted.", latestSeq, this.syncedUpTo));
            }
            this.writer.sync();
            this.syncedUpTo = this.writtenUpTo;
            this.stopTimer(this.writer);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closing = true;
        if (!this.pendingWrites.isEmpty()) {
            this.sync();
        }
        if (this.writer != null) {
            this.writer.close();
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public abstract TransactionLogReader getReader() throws IOException;

    @Deprecated
    @VisibleForTesting
    static class CaskEntry
    implements Writable {
        private LongWritable key;
        private co.cask.tephra.persist.TransactionEdit edit;

        public CaskEntry() {
            this.key = new LongWritable();
            this.edit = new co.cask.tephra.persist.TransactionEdit();
        }

        CaskEntry(LongWritable key, co.cask.tephra.persist.TransactionEdit edit) {
            this.key = key;
            this.edit = edit;
        }

        public LongWritable getKey() {
            return this.key;
        }

        public co.cask.tephra.persist.TransactionEdit getEdit() {
            return this.edit;
        }

        public void write(DataOutput out) throws IOException {
            this.key.write(out);
            this.edit.write(out);
        }

        public void readFields(DataInput in) throws IOException {
            this.key.readFields(in);
            this.edit.readFields(in);
        }
    }

    public static class Entry
    implements Writable {
        private LongWritable key;
        private TransactionEdit edit;

        public Entry() {
            this.key = new LongWritable();
            this.edit = new TransactionEdit();
        }

        public Entry(LongWritable key, TransactionEdit edit) {
            this.key = key;
            this.edit = edit;
        }

        public LongWritable getKey() {
            return this.key;
        }

        public TransactionEdit getEdit() {
            return this.edit;
        }

        public void write(DataOutput out) throws IOException {
            this.key.write(out);
            this.edit.write(out);
        }

        public void readFields(DataInput in) throws IOException {
            this.key.readFields(in);
            this.edit.readFields(in);
        }
    }
}

