/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.shaded.org.apache.twill.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.tephra.shaded.org.apache.twill.filesystem.LocalLocationFactory;
import org.apache.tephra.shaded.org.apache.twill.filesystem.Location;
import org.apache.tephra.shaded.org.apache.twill.filesystem.LocationFactory;

final class LocalLocation
implements Location {
    private final File file;
    private final LocalLocationFactory locationFactory;

    LocalLocation(LocalLocationFactory locationFactory, File file) {
        this.file = file;
        this.locationFactory = locationFactory;
    }

    @Override
    public boolean exists() throws IOException {
        return this.file.exists();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.ensureDirectory(this.file.getParentFile());
        return new FileOutputStream(this.file);
    }

    @Override
    public OutputStream getOutputStream(String permission) throws IOException {
        this.ensureDirectory(this.file.getParentFile());
        Set<PosixFilePermission> permissions = this.parsePermissions(permission);
        Path path = this.file.toPath();
        SeekableByteChannel channel = Files.newByteChannel(path, EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE), PosixFilePermissions.asFileAttribute(permissions));
        Files.setPosixFilePermissions(path, permissions);
        return Channels.newOutputStream(channel);
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public boolean createNew() throws IOException {
        return this.file.createNewFile();
    }

    @Override
    public boolean createNew(String permission) throws IOException {
        Set<PosixFilePermission> permissions = this.parsePermissions(permission);
        try {
            Path path = Files.createFile(this.file.toPath(), PosixFilePermissions.asFileAttribute(permissions));
            Files.setPosixFilePermissions(path, permissions);
            return true;
        }
        catch (FileAlreadyExistsException e) {
            return false;
        }
    }

    @Override
    public String getPermissions() throws IOException {
        return PosixFilePermissions.toString(Files.getPosixFilePermissions(this.file.toPath(), new LinkOption[0]));
    }

    @Override
    public void setPermissions(String permission) throws IOException {
        Files.setPosixFilePermissions(this.file.toPath(), this.parsePermissions(permission));
    }

    @Override
    public Location append(String child) throws IOException {
        return new LocalLocation(this.locationFactory, new File(this.file, child));
    }

    @Override
    public Location getTempFile(String suffix) throws IOException {
        String newName = this.file.getAbsolutePath() + "." + UUID.randomUUID() + (suffix == null ? ".tmp" : suffix);
        return new LocalLocation(this.locationFactory, new File(newName));
    }

    @Override
    public URI toURI() {
        return this.file.toURI();
    }

    @Override
    public boolean delete() throws IOException {
        return this.file.delete();
    }

    @Override
    public boolean delete(boolean recursive) throws IOException {
        if (!recursive) {
            return this.delete();
        }
        LinkedList<File> stack = new LinkedList<File>();
        stack.add(this.file);
        while (!stack.isEmpty()) {
            File f = (File)stack.peekLast();
            File[] files = f.listFiles();
            if (files != null && files.length != 0) {
                Collections.addAll(stack, files);
                continue;
            }
            if (!f.delete()) {
                return false;
            }
            stack.pollLast();
        }
        return true;
    }

    @Override
    public Location renameTo(Location destination) throws IOException {
        Path target = Files.move(this.file.toPath(), ((LocalLocation)destination).file.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        if (target != null) {
            return new LocalLocation(this.locationFactory, target.toFile());
        }
        return null;
    }

    @Override
    public boolean mkdirs() throws IOException {
        return this.file.mkdirs();
    }

    @Override
    public long length() throws IOException {
        return this.file.length();
    }

    @Override
    public long lastModified() {
        return this.file.lastModified();
    }

    @Override
    public boolean isDirectory() throws IOException {
        return this.file.isDirectory();
    }

    @Override
    public List<Location> list() throws IOException {
        File[] files = this.file.listFiles();
        ArrayList<LocalLocation> result = new ArrayList<LocalLocation>();
        if (files != null) {
            for (File file : files) {
                result.add(new LocalLocation(this.locationFactory, file));
            }
        } else if (!this.file.exists()) {
            throw new FileNotFoundException("File " + this.file + " does not exist.");
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public LocationFactory getLocationFactory() {
        return this.locationFactory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalLocation that = (LocalLocation)o;
        return this.file.equals(that.file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String toString() {
        return this.file.toString();
    }

    private void ensureDirectory(File dir) throws IOException {
        if (!(dir.isDirectory() || dir.mkdirs() || dir.isDirectory())) {
            throw new IOException("Failed to create directory " + dir);
        }
    }

    private Set<PosixFilePermission> parsePermissions(String permission) {
        Set<PosixFilePermission> permissions;
        if (permission.length() == 3) {
            permissions = this.parseNumericPermissions(permission);
        } else if (permission.length() == 9) {
            permissions = PosixFilePermissions.fromString(permission);
        } else {
            throw new IllegalArgumentException("Invalid permission " + permission + ". Permission should either be a three digit or nine character string.");
        }
        return permissions;
    }

    private Set<PosixFilePermission> parseNumericPermissions(String permission) {
        String posixPermission = "";
        for (int i = 0; i < 3; ++i) {
            int digit = permission.charAt(i) - 48;
            if (digit < 0 || digit > 7) {
                throw new IllegalArgumentException("Invalid permission " + permission + ". Only digits between 0-7 are allowed.");
            }
            posixPermission = posixPermission + ((digit & 4) != 0 ? "r" : "-");
            posixPermission = posixPermission + ((digit & 2) != 0 ? "w" : "-");
            posixPermission = posixPermission + ((digit & 1) != 0 ? "x" : "-");
        }
        return PosixFilePermissions.fromString(posixPermission);
    }
}

