/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.metadata;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.metastore.components.tables.TableMetadataUnit;
import org.apache.drill.metastore.metadata.BaseMetadata;
import org.apache.drill.metastore.metadata.LocationProvider;
import org.apache.hadoop.fs.Path;

public class SegmentMetadata
extends BaseMetadata
implements LocationProvider {
    private final SchemaPath column;
    private final Path path;
    private final List<String> partitionValues;
    private final Set<Path> locations;

    private SegmentMetadata(SegmentMetadataBuilder builder) {
        super(builder);
        this.column = builder.column;
        this.path = builder.path;
        this.partitionValues = builder.partitionValues;
        this.locations = builder.locations;
    }

    public SchemaPath getColumn() {
        return this.column;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public Path getLocation() {
        return this.path;
    }

    public List<String> getPartitionValues() {
        return this.partitionValues;
    }

    public Set<Path> getLocations() {
        return this.locations;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SegmentMetadata that = (SegmentMetadata)o;
        return Objects.equals(this.column, that.column) && Objects.equals(this.path, that.path) && Objects.equals(this.partitionValues, that.partitionValues) && Objects.equals(this.locations, that.locations);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.column, this.path, this.partitionValues, this.locations);
    }

    public String toString() {
        return new StringJoiner(",\n", SegmentMetadata.class.getSimpleName() + "[\n", "]").add("column=" + this.column).add("path=" + this.path).add("partitionValues=" + this.partitionValues).add("locations=" + this.locations).add("tableInfo=" + this.tableInfo).add("metadataInfo=" + this.metadataInfo).add("schema=" + this.schema).add("columnsStatistics=" + this.columnsStatistics).add("metadataStatistics=" + this.metadataStatistics).add("lastModifiedTime=" + this.lastModifiedTime).toString();
    }

    @Override
    protected void toMetadataUnitBuilder(TableMetadataUnit.Builder builder) {
        if (this.column != null) {
            builder.column(this.column.toString());
        }
        builder.path(this.path.toUri().getPath());
        builder.location(this.getLocation().toUri().getPath());
        builder.partitionValues(this.partitionValues);
        builder.locations(this.locations.stream().map(location -> location.toUri().getPath()).collect(Collectors.toList()));
    }

    public SegmentMetadataBuilder toBuilder() {
        return ((SegmentMetadataBuilder)((SegmentMetadataBuilder)((SegmentMetadataBuilder)((SegmentMetadataBuilder)((SegmentMetadataBuilder)((SegmentMetadataBuilder)SegmentMetadata.builder().tableInfo(this.tableInfo)).metadataInfo(this.metadataInfo)).path(this.path).locations(this.locations).schema(this.schema)).columnsStatistics(this.columnsStatistics)).metadataStatistics(this.metadataStatistics.values())).lastModifiedTime(this.lastModifiedTime)).column(this.column).partitionValues(this.partitionValues);
    }

    public static SegmentMetadataBuilder builder() {
        return new SegmentMetadataBuilder();
    }

    public static class SegmentMetadataBuilder
    extends BaseMetadata.BaseMetadataBuilder<SegmentMetadataBuilder> {
        private SchemaPath column;
        private List<String> partitionValues;
        private Path path;
        private Set<Path> locations;

        public SegmentMetadataBuilder locations(Set<Path> locations) {
            this.locations = locations;
            return this.self();
        }

        public SegmentMetadataBuilder path(Path path) {
            this.path = path;
            return this.self();
        }

        public SegmentMetadataBuilder partitionValues(List<String> partitionValues) {
            this.partitionValues = partitionValues;
            return this.self();
        }

        public SegmentMetadataBuilder column(SchemaPath column) {
            this.column = column;
            return this.self();
        }

        @Override
        protected void checkRequiredValues() {
            super.checkRequiredValues();
            Objects.requireNonNull(this.path, "path was not set");
            Objects.requireNonNull(this.locations, "locations were not set");
        }

        @Override
        public SegmentMetadata build() {
            this.checkRequiredValues();
            return new SegmentMetadata(this);
        }

        @Override
        protected SegmentMetadataBuilder self() {
            return this;
        }

        @Override
        protected SegmentMetadataBuilder metadataUnitInternal(TableMetadataUnit unit) {
            if (unit.locations() != null) {
                this.locations(unit.locations().stream().map(Path::new).collect(Collectors.toSet()));
            }
            if (unit.path() != null) {
                this.path(new Path(unit.path()));
            }
            this.partitionValues(unit.partitionValues());
            this.column(SchemaPath.parseFromString((String)unit.column()));
            return this.self();
        }
    }
}

