/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.iceberg.operate;

import java.util.List;
import org.apache.drill.metastore.MetastoreColumn;
import org.apache.drill.metastore.iceberg.IcebergMetastoreContext;
import org.apache.drill.metastore.iceberg.transform.FilterTransformer;
import org.apache.drill.metastore.operate.AbstractRead;
import org.apache.drill.metastore.operate.MetadataTypeValidator;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.IcebergGenerics;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.types.Types;

public class IcebergRead<T>
extends AbstractRead<T> {
    private final IcebergMetastoreContext<T> context;
    private final String[] defaultColumns;

    public IcebergRead(MetadataTypeValidator metadataTypeValidator, IcebergMetastoreContext<T> context) {
        super(metadataTypeValidator);
        this.context = context;
        this.defaultColumns = (String[])context.table().schema().columns().stream().map(Types.NestedField::name).toArray(String[]::new);
    }

    protected List<T> internalExecute() {
        String[] selectedColumns = this.columns.isEmpty() ? this.defaultColumns : (String[])this.columns.stream().map(MetastoreColumn::columnName).toArray(String[]::new);
        FilterTransformer filterTransformer = this.context.transformer().filter();
        Expression rowFilter = filterTransformer.combine(filterTransformer.transform(this.metadataTypes), filterTransformer.transform(this.filter));
        CloseableIterable records = IcebergGenerics.read((Table)this.context.table()).select(selectedColumns).where(rowFilter).build();
        return this.context.transformer().outputData().columns(selectedColumns).records(Lists.newArrayList((Iterable)records)).execute();
    }
}

