/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import com.google.errorprone.annotations.RestrictedApi;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.favored.FavoredNodesManager;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MetricsSnapshot;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.ProcedureSyncWait;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotHelper;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.snapshot.SnapshotTTLExpiredException;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RestoreSnapshotProcedure
extends AbstractStateMachineTableProcedure<MasterProcedureProtos.RestoreSnapshotState> {
    private static final Logger LOG = LoggerFactory.getLogger(RestoreSnapshotProcedure.class);
    private TableDescriptor modifiedTableDescriptor;
    private List<RegionInfo> regionsToRestore = null;
    private List<RegionInfo> regionsToRemove = null;
    private List<RegionInfo> regionsToAdd = null;
    private Map<String, Pair<String, String>> parentsToChildrenPairMap = new HashMap<String, Pair<String, String>>();
    private SnapshotProtos.SnapshotDescription snapshot;
    private boolean restoreAcl;
    private MonitoredTask monitorStatus = null;

    public RestoreSnapshotProcedure() {
    }

    public RestoreSnapshotProcedure(MasterProcedureEnv env, TableDescriptor tableDescriptor, SnapshotProtos.SnapshotDescription snapshot) throws HBaseIOException {
        this(env, tableDescriptor, snapshot, false);
    }

    public RestoreSnapshotProcedure(MasterProcedureEnv env, TableDescriptor tableDescriptor, SnapshotProtos.SnapshotDescription snapshot, boolean restoreAcl) throws HBaseIOException {
        super(env);
        this.modifiedTableDescriptor = tableDescriptor;
        this.preflightChecks(env, null);
        this.snapshot = snapshot;
        this.restoreAcl = restoreAcl;
        this.getMonitorStatus();
    }

    private MonitoredTask getMonitorStatus() {
        if (this.monitorStatus == null) {
            this.monitorStatus = TaskMonitor.get().createStatus("Restoring  snapshot '" + this.snapshot.getName() + "' to table " + this.getTableName());
        }
        return this.monitorStatus;
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.RestoreSnapshotState state) throws InterruptedException {
        LOG.trace("{} execute state={}", (Object)this, (Object)state);
        this.getMonitorStatus();
        try {
            switch (state) {
                case RESTORE_SNAPSHOT_PRE_OPERATION: {
                    this.prepareRestore(env);
                    this.setNextState(MasterProcedureProtos.RestoreSnapshotState.RESTORE_SNAPSHOT_UPDATE_TABLE_DESCRIPTOR);
                    break;
                }
                case RESTORE_SNAPSHOT_UPDATE_TABLE_DESCRIPTOR: {
                    this.updateTableDescriptor(env);
                    this.setNextState(MasterProcedureProtos.RestoreSnapshotState.RESTORE_SNAPSHOT_WRITE_FS_LAYOUT);
                    break;
                }
                case RESTORE_SNAPSHOT_WRITE_FS_LAYOUT: {
                    this.restoreSnapshot(env);
                    this.setNextState(MasterProcedureProtos.RestoreSnapshotState.RESTORE_SNAPSHOT_UPDATE_META);
                    break;
                }
                case RESTORE_SNAPSHOT_UPDATE_META: {
                    this.updateMETA(env);
                    this.setNextState(MasterProcedureProtos.RestoreSnapshotState.RESTORE_SNAPSHOT_RESTORE_ACL);
                    break;
                }
                case RESTORE_SNAPSHOT_RESTORE_ACL: {
                    this.restoreSnapshotAcl(env);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException("unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            if (this.isRollbackSupported(state)) {
                this.setFailure("master-restore-snapshot", e);
            }
            LOG.warn("Retriable error trying to restore snapshot=" + this.snapshot.getName() + " to table=" + this.getTableName() + " (in state=" + state + ")", (Throwable)e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.RestoreSnapshotState state) throws IOException {
        if (state == MasterProcedureProtos.RestoreSnapshotState.RESTORE_SNAPSHOT_PRE_OPERATION) {
            return;
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    protected boolean isRollbackSupported(MasterProcedureProtos.RestoreSnapshotState state) {
        switch (state) {
            case RESTORE_SNAPSHOT_PRE_OPERATION: {
                return true;
            }
        }
        return false;
    }

    protected MasterProcedureProtos.RestoreSnapshotState getState(int stateId) {
        return MasterProcedureProtos.RestoreSnapshotState.valueOf((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.RestoreSnapshotState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.RestoreSnapshotState getInitialState() {
        return MasterProcedureProtos.RestoreSnapshotState.RESTORE_SNAPSHOT_PRE_OPERATION;
    }

    @Override
    public TableName getTableName() {
        return this.modifiedTableDescriptor.getTableName();
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.EDIT;
    }

    public boolean abort(MasterProcedureEnv env) {
        return false;
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" (table=");
        sb.append(this.getTableName());
        sb.append(" snapshot=");
        sb.append(this.snapshot);
        sb.append(")");
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.RestoreSnapshotStateData.Builder restoreSnapshotMsg = MasterProcedureProtos.RestoreSnapshotStateData.newBuilder().setUserInfo(MasterProcedureUtil.toProtoUserInfo(this.getUser())).setSnapshot(this.snapshot).setModifiedTableSchema(ProtobufUtil.toTableSchema((TableDescriptor)this.modifiedTableDescriptor));
        if (this.regionsToRestore != null) {
            for (RegionInfo hri : this.regionsToRestore) {
                restoreSnapshotMsg.addRegionInfoForRestore(ProtobufUtil.toRegionInfo((RegionInfo)hri));
            }
        }
        if (this.regionsToRemove != null) {
            for (RegionInfo hri : this.regionsToRemove) {
                restoreSnapshotMsg.addRegionInfoForRemove(ProtobufUtil.toRegionInfo((RegionInfo)hri));
            }
        }
        if (this.regionsToAdd != null) {
            for (RegionInfo hri : this.regionsToAdd) {
                restoreSnapshotMsg.addRegionInfoForAdd(ProtobufUtil.toRegionInfo((RegionInfo)hri));
            }
        }
        if (!this.parentsToChildrenPairMap.isEmpty()) {
            for (Map.Entry<String, Pair<String, String>> entry : this.parentsToChildrenPairMap.entrySet()) {
                MasterProcedureProtos.RestoreParentToChildRegionsPair.Builder parentToChildrenPair = MasterProcedureProtos.RestoreParentToChildRegionsPair.newBuilder().setParentRegionName(entry.getKey()).setChild1RegionName((String)entry.getValue().getFirst()).setChild2RegionName((String)entry.getValue().getSecond());
                restoreSnapshotMsg.addParentToChildRegionsPairList(parentToChildrenPair);
            }
        }
        restoreSnapshotMsg.setRestoreAcl(this.restoreAcl);
        serializer.serialize((Message)restoreSnapshotMsg.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.RestoreSnapshotStateData restoreSnapshotMsg = (MasterProcedureProtos.RestoreSnapshotStateData)serializer.deserialize(MasterProcedureProtos.RestoreSnapshotStateData.class);
        this.setUser(MasterProcedureUtil.toUserInfo(restoreSnapshotMsg.getUserInfo()));
        this.snapshot = restoreSnapshotMsg.getSnapshot();
        this.modifiedTableDescriptor = ProtobufUtil.toTableDescriptor((HBaseProtos.TableSchema)restoreSnapshotMsg.getModifiedTableSchema());
        if (restoreSnapshotMsg.getRegionInfoForRestoreCount() == 0) {
            this.regionsToRestore = null;
        } else {
            this.regionsToRestore = new ArrayList<RegionInfo>(restoreSnapshotMsg.getRegionInfoForRestoreCount());
            for (HBaseProtos.RegionInfo hri : restoreSnapshotMsg.getRegionInfoForRestoreList()) {
                this.regionsToRestore.add(ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)hri));
            }
        }
        if (restoreSnapshotMsg.getRegionInfoForRemoveCount() == 0) {
            this.regionsToRemove = null;
        } else {
            this.regionsToRemove = new ArrayList<RegionInfo>(restoreSnapshotMsg.getRegionInfoForRemoveCount());
            for (HBaseProtos.RegionInfo hri : restoreSnapshotMsg.getRegionInfoForRemoveList()) {
                this.regionsToRemove.add(ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)hri));
            }
        }
        if (restoreSnapshotMsg.getRegionInfoForAddCount() == 0) {
            this.regionsToAdd = null;
        } else {
            this.regionsToAdd = new ArrayList<RegionInfo>(restoreSnapshotMsg.getRegionInfoForAddCount());
            for (HBaseProtos.RegionInfo hri : restoreSnapshotMsg.getRegionInfoForAddList()) {
                this.regionsToAdd.add(ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)hri));
            }
        }
        if (restoreSnapshotMsg.getParentToChildRegionsPairListCount() > 0) {
            for (MasterProcedureProtos.RestoreParentToChildRegionsPair parentToChildrenPair : restoreSnapshotMsg.getParentToChildRegionsPairListList()) {
                this.parentsToChildrenPairMap.put(parentToChildrenPair.getParentRegionName(), (Pair<String, String>)new Pair((Object)parentToChildrenPair.getChild1RegionName(), (Object)parentToChildrenPair.getChild2RegionName()));
            }
        }
        if (restoreSnapshotMsg.hasRestoreAcl()) {
            this.restoreAcl = restoreSnapshotMsg.getRestoreAcl();
        }
    }

    private void prepareRestore(MasterProcedureEnv env) throws IOException {
        TableName tableName = this.getTableName();
        if (!env.getMasterServices().getTableDescriptors().exists(tableName)) {
            throw new TableNotFoundException(tableName);
        }
        if (SnapshotDescriptionUtils.isExpiredSnapshot(this.snapshot.getTtl(), this.snapshot.getCreationTime(), EnvironmentEdgeManager.currentTime())) {
            throw new SnapshotTTLExpiredException(ProtobufUtil.createSnapshotDesc((SnapshotProtos.SnapshotDescription)this.snapshot));
        }
        env.getMasterServices().checkTableModifiable(tableName);
        if (this.modifiedTableDescriptor.getColumnFamilyCount() == 0) {
            throw new DoNotRetryIOException("Table " + this.getTableName().toString() + " should have at least one column family.");
        }
        if (!this.getTableName().isSystemTable()) {
            MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
            SnapshotManifest manifest = SnapshotManifest.open(env.getMasterConfiguration(), mfs.getFileSystem(), SnapshotDescriptionUtils.getCompletedSnapshotDir(this.snapshot, mfs.getRootDir()), this.snapshot);
            int snapshotRegionCount = manifest.getRegionManifestsMap().size();
            int tableRegionCount = ProcedureSyncWait.getMasterQuotaManager(env).getRegionCountOfTable(tableName);
            if (snapshotRegionCount > 0 && tableRegionCount != snapshotRegionCount) {
                ProcedureSyncWait.getMasterQuotaManager(env).checkAndUpdateNamespaceRegionQuota(tableName, snapshotRegionCount);
            }
        }
    }

    private void updateTableDescriptor(MasterProcedureEnv env) throws IOException {
        env.getMasterServices().getTableDescriptors().update(this.modifiedTableDescriptor);
    }

    private void restoreSnapshot(MasterProcedureEnv env) throws IOException {
        MasterFileSystem fileSystemManager = env.getMasterServices().getMasterFileSystem();
        FileSystem fs = fileSystemManager.getFileSystem();
        Path rootDir = fileSystemManager.getRootDir();
        ForeignExceptionDispatcher monitorException = new ForeignExceptionDispatcher();
        Configuration conf = new Configuration(env.getMasterConfiguration());
        LOG.info("Starting restore snapshot=" + ClientSnapshotDescriptionUtils.toString((SnapshotProtos.SnapshotDescription)this.snapshot));
        try {
            Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(this.snapshot, rootDir);
            SnapshotManifest manifest = SnapshotManifest.open(conf, fs, snapshotDir, this.snapshot);
            RestoreSnapshotHelper restoreHelper = new RestoreSnapshotHelper(conf, fs, manifest, this.modifiedTableDescriptor, rootDir, monitorException, this.getMonitorStatus());
            RestoreSnapshotHelper.RestoreMetaChanges metaChanges = restoreHelper.restoreHdfsRegions();
            this.regionsToRestore = metaChanges.getRegionsToRestore();
            this.regionsToRemove = metaChanges.getRegionsToRemove();
            this.regionsToAdd = metaChanges.getRegionsToAdd();
            this.parentsToChildrenPairMap = metaChanges.getParentToChildrenPairMap();
        }
        catch (IOException e) {
            String msg = "restore snapshot=" + ClientSnapshotDescriptionUtils.toString((SnapshotProtos.SnapshotDescription)this.snapshot) + " failed in on-disk restore. Try re-running the restore command.";
            LOG.error(msg, (Throwable)e);
            monitorException.receive(new ForeignException(env.getMasterServices().getServerName().toString(), e));
            throw new IOException(msg, e);
        }
    }

    private void updateMETA(MasterProcedureEnv env) throws IOException {
        try {
            Connection conn = env.getMasterServices().getConnection();
            int regionReplication = this.modifiedTableDescriptor.getRegionReplication();
            this.getMonitorStatus().setStatus("Preparing to restore each region");
            if (this.regionsToRemove != null) {
                MetaTableAccessor.deleteRegionInfos((Connection)conn, this.regionsToRemove);
                this.deleteRegionsFromInMemoryStates(this.regionsToRemove, env, regionReplication);
            }
            if (this.regionsToAdd != null) {
                MetaTableAccessor.addRegionsToMeta((Connection)conn, this.regionsToAdd, (int)regionReplication);
                this.addRegionsToInMemoryStates(this.regionsToAdd, env, regionReplication);
            }
            if (this.regionsToRestore != null) {
                MetaTableAccessor.overwriteRegions((Connection)conn, this.regionsToRestore, (int)regionReplication);
                this.deleteRegionsFromInMemoryStates(this.regionsToRestore, env, regionReplication);
                this.addRegionsToInMemoryStates(this.regionsToRestore, env, regionReplication);
            }
            RestoreSnapshotHelper.RestoreMetaChanges metaChanges = new RestoreSnapshotHelper.RestoreMetaChanges(this.modifiedTableDescriptor, this.parentsToChildrenPairMap);
            metaChanges.updateMetaParentRegions(conn, this.regionsToAdd);
            LOG.info("Restore snapshot=" + ClientSnapshotDescriptionUtils.toString((SnapshotProtos.SnapshotDescription)this.snapshot) + " on table=" + this.getTableName() + " completed!");
        }
        catch (IOException e) {
            ForeignExceptionDispatcher monitorException = new ForeignExceptionDispatcher();
            String msg = "restore snapshot=" + ClientSnapshotDescriptionUtils.toString((SnapshotProtos.SnapshotDescription)this.snapshot) + " failed in meta update. Try re-running the restore command.";
            LOG.error(msg, (Throwable)e);
            monitorException.receive(new ForeignException(env.getMasterServices().getServerName().toString(), e));
            throw new IOException(msg, e);
        }
        this.monitorStatus.markComplete("Restore snapshot '" + this.snapshot.getName() + "'!");
        MetricsSnapshot metricsSnapshot = new MetricsSnapshot();
        metricsSnapshot.addSnapshotRestore(this.monitorStatus.getCompletionTimestamp() - this.monitorStatus.getStartTime());
    }

    private void deleteRegionsFromInMemoryStates(List<RegionInfo> regionInfos, MasterProcedureEnv env, int regionReplication) {
        FavoredNodesManager fnm = env.getMasterServices().getFavoredNodesManager();
        env.getAssignmentManager().getRegionStates().deleteRegions(regionInfos);
        env.getMasterServices().getServerManager().removeRegions(regionInfos);
        if (fnm != null) {
            fnm.deleteFavoredNodesForRegions(regionInfos);
        }
        if (regionReplication > 1) {
            for (RegionInfo regionInfo : regionInfos) {
                for (int i = 1; i < regionReplication; ++i) {
                    RegionInfo regionInfoForReplica = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)regionInfo, (int)i);
                    env.getAssignmentManager().getRegionStates().deleteRegion(regionInfoForReplica);
                    env.getMasterServices().getServerManager().removeRegion(regionInfoForReplica);
                    if (fnm == null) continue;
                    fnm.deleteFavoredNodesForRegion(regionInfoForReplica);
                }
            }
        }
    }

    private void addRegionsToInMemoryStates(List<RegionInfo> regionInfos, MasterProcedureEnv env, int regionReplication) {
        AssignmentManager am = env.getAssignmentManager();
        for (RegionInfo regionInfo : regionInfos) {
            if (regionInfo.isSplit()) {
                am.getRegionStates().updateRegionState(regionInfo, RegionState.State.SPLIT);
                continue;
            }
            am.getRegionStates().updateRegionState(regionInfo, RegionState.State.CLOSED);
            for (int i = 1; i < regionReplication; ++i) {
                RegionInfo regionInfoForReplica = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)regionInfo, (int)i);
                am.getRegionStates().updateRegionState(regionInfoForReplica, RegionState.State.CLOSED);
            }
        }
    }

    private void restoreSnapshotAcl(MasterProcedureEnv env) throws IOException {
        if (this.restoreAcl && this.snapshot.hasUsersAndPermissions() && this.snapshot.getUsersAndPermissions() != null && SnapshotDescriptionUtils.isSecurityAvailable(env.getMasterServices().getConfiguration())) {
            RestoreSnapshotHelper.restoreSnapshotAcl(this.snapshot, TableName.valueOf((String)this.snapshot.getTable()), env.getMasterServices().getConfiguration());
        }
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    public boolean getRestoreAcl() {
        return this.restoreAcl;
    }
}

