/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.druid;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.drill.common.PlanStringBuilder;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.base.AbstractBase;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.druid.DruidStoragePlugin;
import org.apache.drill.exec.store.druid.common.DruidFilter;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

@JsonTypeName(value="druid-datasource-scan")
public class DruidSubScan
extends AbstractBase
implements SubScan {
    public static final String OPERATOR_TYPE = "DRUID_SUB_SCAN";
    @JsonIgnore
    private final DruidStoragePlugin druidStoragePlugin;
    private final List<DruidSubScanSpec> scanSpec;
    private final List<SchemaPath> columns;
    private final int maxRecordsToRead;

    @JsonCreator
    public DruidSubScan(@JacksonInject StoragePluginRegistry registry, @JsonProperty(value="userName") String userName, @JsonProperty(value="config") StoragePluginConfig config, @JsonProperty(value="scanSpec") LinkedList<DruidSubScanSpec> datasourceScanSpecList, @JsonProperty(value="columns") List<SchemaPath> columns, @JsonProperty(value="maxRecordsToRead") int maxRecordsToRead) {
        super(userName);
        this.druidStoragePlugin = (DruidStoragePlugin)registry.resolve(config, DruidStoragePlugin.class);
        this.scanSpec = datasourceScanSpecList;
        this.columns = columns;
        this.maxRecordsToRead = maxRecordsToRead;
    }

    public DruidSubScan(String userName, DruidStoragePlugin plugin, List<DruidSubScanSpec> dataSourceInfoList, List<SchemaPath> columns, int maxRecordsToRead) {
        super(userName);
        this.druidStoragePlugin = plugin;
        this.scanSpec = dataSourceInfoList;
        this.columns = columns;
        this.maxRecordsToRead = maxRecordsToRead;
    }

    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return (T)physicalVisitor.visitSubScan((SubScan)this, value);
    }

    @JsonIgnore
    public List<DruidSubScanSpec> getScanSpec() {
        return this.scanSpec;
    }

    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    public int getMaxRecordsToRead() {
        return this.maxRecordsToRead;
    }

    @JsonIgnore
    public boolean isExecutable() {
        return false;
    }

    @JsonIgnore
    public DruidStoragePlugin getStorageEngine() {
        return this.druidStoragePlugin;
    }

    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument((boolean)children.isEmpty());
        return new DruidSubScan(this.getUserName(), this.druidStoragePlugin, this.scanSpec, this.columns, this.maxRecordsToRead);
    }

    @JsonIgnore
    public String getOperatorType() {
        return OPERATOR_TYPE;
    }

    public Iterator<PhysicalOperator> iterator() {
        return Collections.emptyIterator();
    }

    public static class DruidSubScanSpec {
        protected final String dataSourceName;
        protected final DruidFilter filter;
        protected final long dataSourceSize;
        protected final String maxTime;
        protected final String minTime;

        @JsonCreator
        public DruidSubScanSpec(@JsonProperty(value="dataSourceName") String dataSourceName, @JsonProperty(value="filter") DruidFilter filter, @JsonProperty(value="dataSourceSize") long dataSourceSize, @JsonProperty(value="minTime") String minTime, @JsonProperty(value="maxTime") String maxTime) {
            this.dataSourceName = dataSourceName;
            this.filter = filter;
            this.dataSourceSize = dataSourceSize;
            this.minTime = minTime;
            this.maxTime = maxTime;
        }

        public String getDataSourceName() {
            return this.dataSourceName;
        }

        public DruidFilter getFilter() {
            return this.filter;
        }

        public long getDataSourceSize() {
            return this.dataSourceSize;
        }

        public String getMinTime() {
            return this.minTime;
        }

        public String getMaxTime() {
            return this.maxTime;
        }

        public String toString() {
            return new PlanStringBuilder((Object)this).field("dataSourceName", this.dataSourceName).field("filter", (Object)this.filter).field("dataSourceSize", (Object)this.dataSourceSize).field("minTime", this.minTime).field("maxTime", this.maxTime).toString();
        }
    }
}

