/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.druid.common;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.apache.drill.exec.store.druid.common.DruidAndFilter;
import org.apache.drill.exec.store.druid.common.DruidBoundFilter;
import org.apache.drill.exec.store.druid.common.DruidCompareOp;
import org.apache.drill.exec.store.druid.common.DruidFilter;
import org.apache.drill.exec.store.druid.common.DruidInFilter;
import org.apache.drill.exec.store.druid.common.DruidNotFilter;
import org.apache.drill.exec.store.druid.common.DruidOrFilter;
import org.apache.drill.exec.store.druid.common.DruidRegexFilter;
import org.apache.drill.exec.store.druid.common.DruidSearchFilter;
import org.apache.drill.exec.store.druid.common.DruidSelectorFilter;

public class DruidFilterDeserializer
extends JsonDeserializer<DruidFilter> {
    public DruidFilter deserialize(JsonParser jp, DeserializationContext context) throws IOException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        ObjectNode root = (ObjectNode)mapper.readTree(jp);
        boolean filterKnowsItsType = root.has("type");
        if (filterKnowsItsType) {
            DruidCompareOp type = DruidCompareOp.get(root.get("type").asText());
            switch (type) {
                case TYPE_SELECTOR: {
                    return (DruidFilter)mapper.readValue(root.toString(), DruidSelectorFilter.class);
                }
                case TYPE_BOUND: {
                    return (DruidFilter)mapper.readValue(root.toString(), DruidBoundFilter.class);
                }
                case TYPE_IN: {
                    return (DruidFilter)mapper.readValue(root.toString(), DruidInFilter.class);
                }
                case TYPE_REGEX: {
                    return (DruidFilter)mapper.readValue(root.toString(), DruidRegexFilter.class);
                }
                case TYPE_SEARCH: {
                    return (DruidFilter)mapper.readValue(root.toString(), DruidSearchFilter.class);
                }
                case AND: {
                    return (DruidFilter)mapper.readValue(root.toString(), DruidAndFilter.class);
                }
                case OR: {
                    return (DruidFilter)mapper.readValue(root.toString(), DruidOrFilter.class);
                }
                case NOT: {
                    return (DruidFilter)mapper.readValue(root.toString(), DruidNotFilter.class);
                }
            }
        }
        if (filterKnowsItsType && root.get("type").asText().equals(DruidCompareOp.TYPE_SELECTOR.getCompareOp())) {
            return (DruidFilter)mapper.readValue(root.toString(), DruidSelectorFilter.class);
        }
        return (DruidFilter)mapper.readValue(root.toString(), DruidSelectorFilter.class);
    }
}

