/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.iceberg.plan;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Util;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.planner.common.DrillLimitRelBase;
import org.apache.drill.exec.planner.logical.DrillOptiq;
import org.apache.drill.exec.planner.logical.DrillParseContext;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.dfs.FileSystemPlugin;
import org.apache.drill.exec.store.iceberg.IcebergGroupScan;
import org.apache.drill.exec.store.iceberg.plan.DrillExprToIcebergTranslator;
import org.apache.drill.exec.store.plan.AbstractPluginImplementor;
import org.apache.drill.exec.store.plan.rel.PluginFilterRel;
import org.apache.drill.exec.store.plan.rel.PluginLimitRel;
import org.apache.drill.exec.store.plan.rel.PluginProjectRel;
import org.apache.drill.exec.store.plan.rel.StoragePluginTableScan;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.types.Types;

public class IcebergPluginImplementor
extends AbstractPluginImplementor {
    private IcebergGroupScan groupScan;

    public void implement(StoragePluginTableScan scan) {
        this.groupScan = (IcebergGroupScan)scan.getGroupScan();
    }

    public void implement(PluginFilterRel filter) throws IOException {
        this.visitChild(filter.getInput());
        RexNode condition = filter.getCondition();
        LogicalExpression expression = DrillOptiq.toDrill((DrillParseContext)new DrillParseContext(PrelUtil.getPlannerSettings((RelOptPlanner)filter.getCluster().getPlanner())), (RelNode)filter.getInput(), (RexNode)condition);
        this.groupScan = this.groupScan.toBuilder().condition(expression).build();
    }

    public void implement(PluginProjectRel project) throws IOException {
        this.visitChild(project.getInput());
        DrillParseContext context = new DrillParseContext(PrelUtil.getPlannerSettings((RelOptPlanner)project.getCluster().getPlanner()));
        RelNode input = project.getInput();
        List<SchemaPath> projects = project.getProjects().stream().map(e -> (SchemaPath)DrillOptiq.toDrill((DrillParseContext)context, (RelNode)input, (RexNode)e)).collect(Collectors.toList());
        this.groupScan = this.groupScan.clone(projects);
    }

    public boolean canImplement(Filter filter) {
        RexNode condition = filter.getCondition();
        LogicalExpression logicalExpression = DrillOptiq.toDrill((DrillParseContext)new DrillParseContext(PrelUtil.getPlannerSettings((RelOptPlanner)filter.getCluster().getPlanner())), (RelNode)filter.getInput(), (RexNode)condition);
        Expression expression = (Expression)logicalExpression.accept(DrillExprToIcebergTranslator.INSTANCE, null);
        if (expression != null) {
            try {
                GroupScan scan = this.findGroupScan((RelNode)filter);
                if (!(scan instanceof IcebergGroupScan)) {
                    return false;
                }
                IcebergGroupScan groupScan = (IcebergGroupScan)scan;
                expression = Binder.bind((Types.StructType)groupScan.getTableScan().schema().asStruct(), (Expression)expression, (boolean)true);
            }
            catch (ValidationException e) {
                return false;
            }
        }
        return expression != null;
    }

    public void implement(PluginLimitRel limit) throws IOException {
        this.visitChild(limit.getInput());
        int maxRecords = this.getArtificialLimit((DrillLimitRelBase)limit);
        if (maxRecords >= 0) {
            this.groupScan = this.groupScan.applyLimit(maxRecords);
        }
    }

    public boolean canImplement(DrillLimitRelBase limit) {
        if (this.hasPluginGroupScan((RelNode)limit)) {
            FirstLimitFinder finder = new FirstLimitFinder();
            limit.getInput().accept((RelShuttle)finder);
            int oldLimit = this.getArtificialLimit(finder.getFetch(), finder.getOffset());
            int newLimit = this.getArtificialLimit(limit);
            return newLimit >= 0 && (oldLimit < 0 || newLimit < oldLimit);
        }
        return false;
    }

    public boolean artificialLimit() {
        return true;
    }

    protected Class<? extends StoragePlugin> supportedPlugin() {
        return FileSystemPlugin.class;
    }

    public boolean splitProject(Project project) {
        return true;
    }

    public boolean canImplement(Project project) {
        return this.hasPluginGroupScan((RelNode)project);
    }

    public GroupScan getPhysicalOperator() {
        return this.groupScan;
    }

    protected boolean hasPluginGroupScan(RelNode node) {
        return this.findGroupScan(node) instanceof IcebergGroupScan;
    }

    private int rexLiteralIntValue(RexLiteral offset) {
        return ((BigDecimal)offset.getValue()).intValue();
    }

    private int getArtificialLimit(DrillLimitRelBase limit) {
        return this.getArtificialLimit(limit.getFetch(), limit.getOffset());
    }

    private int getArtificialLimit(RexNode fetch, RexNode offset) {
        int maxRows = -1;
        if (fetch != null) {
            maxRows = this.rexLiteralIntValue((RexLiteral)fetch);
            if (offset != null) {
                maxRows += this.rexLiteralIntValue((RexLiteral)offset);
            }
        }
        return maxRows;
    }

    private static class FirstLimitFinder
    extends RelShuttleImpl {
        private RexNode fetch;
        private RexNode offset;

        private FirstLimitFinder() {
        }

        public RelNode visit(RelNode other) {
            if (other instanceof DrillLimitRelBase) {
                DrillLimitRelBase limitRelBase = (DrillLimitRelBase)other;
                this.fetch = limitRelBase.getFetch();
                this.offset = limitRelBase.getOffset();
                return other;
            }
            if (other instanceof RelSubset) {
                RelSubset relSubset = (RelSubset)other;
                ((RelNode)Util.first((Object)relSubset.getBest(), (Object)relSubset.getOriginal())).accept((RelShuttle)this);
            }
            return super.visit(other);
        }

        public RexNode getFetch() {
            return this.fetch;
        }

        public RexNode getOffset() {
            return this.offset;
        }
    }
}

