/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import org.apache.iceberg.StructLike;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.BoundTerm;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.types.Type;

public class BoundTransform<S, T>
implements BoundTerm<T> {
    private final BoundReference<S> ref;
    private final Transform<S, T> transform;

    BoundTransform(BoundReference<S> ref, Transform<S, T> transform) {
        this.ref = ref;
        this.transform = transform;
    }

    @Override
    public T eval(StructLike struct) {
        return this.transform.apply(this.ref.eval(struct));
    }

    @Override
    public BoundReference<S> ref() {
        return this.ref;
    }

    public Transform<S, T> transform() {
        return this.transform;
    }

    @Override
    public Type type() {
        return this.transform.getResultType(this.ref.type());
    }

    public String toString() {
        return this.transform + "(" + this.ref + ")";
    }
}

