/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import org.jooq.Configuration;
import org.jooq.ExecuteType;
import org.jooq.Record;
import org.jooq.RecordContext;
import org.jooq.RecordListener;
import org.jooq.RecordListenerProvider;
import org.jooq.conf.InvocationOrder;
import org.jooq.exception.ControlFlowSignal;
import org.jooq.impl.AbstractScope;
import org.jooq.impl.DefaultRecordContext;
import org.jooq.impl.RecordOperation;
import org.jooq.impl.Tools;

final class RecordDelegate<R extends Record> {
    private final Configuration configuration;
    private final R record;
    private final RecordLifecycleType type;

    RecordDelegate(Configuration configuration, R record) {
        this(configuration, record, RecordLifecycleType.LOAD);
    }

    RecordDelegate(Configuration configuration, R record, RecordLifecycleType type) {
        this.configuration = configuration;
        this.record = record;
        this.type = type;
    }

    static final <R extends Record> RecordDelegate<R> delegate(Configuration configuration, R record) {
        return new RecordDelegate<R>(configuration, record);
    }

    static final <R extends Record> RecordDelegate<R> delegate(Configuration configuration, R record, RecordLifecycleType type) {
        return new RecordDelegate<R>(configuration, record, type);
    }

    final <E extends Exception> R operate(RecordOperation<? super R, E> operation) throws E {
        Exception exception;
        AbstractScope ctx;
        RecordListener[] listeners;
        block29: {
            RecordListenerProvider[] providers = null;
            listeners = null;
            ctx = null;
            exception = null;
            if (this.configuration != null && (providers = this.configuration.recordListenerProviders()) != null && providers.length > 0) {
                listeners = new RecordListener[providers.length];
                ctx = new DefaultRecordContext(this.configuration, this.executeType(), new Record[]{this.record});
                for (int i = 0; i < providers.length; ++i) {
                    listeners[i] = providers[i].provide();
                }
            }
            if (listeners != null) {
                block19: for (RecordListener recordListener : ctx == null || ctx.settings().getRecordListenerStartInvocationOrder() != InvocationOrder.REVERSE ? Arrays.asList(listeners) : Tools.reverseIterable(listeners)) {
                    switch (this.type) {
                        case LOAD: {
                            recordListener.loadStart((RecordContext)((Object)ctx));
                            continue block19;
                        }
                        case REFRESH: {
                            recordListener.refreshStart((RecordContext)((Object)ctx));
                            continue block19;
                        }
                        case STORE: {
                            recordListener.storeStart((RecordContext)((Object)ctx));
                            continue block19;
                        }
                        case INSERT: {
                            recordListener.insertStart((RecordContext)((Object)ctx));
                            continue block19;
                        }
                        case UPDATE: {
                            recordListener.updateStart((RecordContext)((Object)ctx));
                            continue block19;
                        }
                        case DELETE: {
                            recordListener.deleteStart((RecordContext)((Object)ctx));
                            continue block19;
                        }
                    }
                    throw new IllegalStateException("Type not supported: " + (Object)((Object)this.type));
                }
            }
            if (Tools.attachRecords(this.configuration)) {
                this.record.attach(this.configuration);
            }
            if (operation != null) {
                try {
                    operation.operate(this.record);
                }
                catch (Exception e) {
                    exception = e;
                    if (e instanceof ControlFlowSignal) break block29;
                    if (ctx != null) {
                        ((DefaultRecordContext)ctx).exception = e;
                    }
                    if (listeners == null) break block29;
                    for (RecordListener listener : listeners) {
                        listener.exception((RecordContext)((Object)ctx));
                    }
                }
            }
        }
        if (listeners != null) {
            block21: for (RecordListener recordListener : ctx == null || ctx.settings().getRecordListenerEndInvocationOrder() != InvocationOrder.REVERSE ? Arrays.asList(listeners) : Tools.reverseIterable(listeners)) {
                switch (this.type) {
                    case LOAD: {
                        recordListener.loadEnd((RecordContext)((Object)ctx));
                        continue block21;
                    }
                    case REFRESH: {
                        recordListener.refreshEnd((RecordContext)((Object)ctx));
                        continue block21;
                    }
                    case STORE: {
                        recordListener.storeEnd((RecordContext)((Object)ctx));
                        continue block21;
                    }
                    case INSERT: {
                        recordListener.insertEnd((RecordContext)((Object)ctx));
                        continue block21;
                    }
                    case UPDATE: {
                        recordListener.updateEnd((RecordContext)((Object)ctx));
                        continue block21;
                    }
                    case DELETE: {
                        recordListener.deleteEnd((RecordContext)((Object)ctx));
                        continue block21;
                    }
                }
                throw new IllegalStateException("Type not supported: " + (Object)((Object)this.type));
            }
        }
        if (exception != null) {
            throw exception;
        }
        return this.record;
    }

    private final ExecuteType executeType() {
        return this.type == RecordLifecycleType.LOAD || this.type == RecordLifecycleType.REFRESH ? ExecuteType.READ : ExecuteType.WRITE;
    }

    static enum RecordLifecycleType {
        LOAD,
        REFRESH,
        STORE,
        INSERT,
        UPDATE,
        DELETE;

    }
}

