/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.math.BigDecimal;
import org.jooq.Configuration;
import org.jooq.Field;
import org.jooq.Param;
import org.jooq.impl.AbstractFunction;
import org.jooq.impl.DSL;
import org.jooq.impl.Tools;

final class Round<T extends Number>
extends AbstractFunction<T> {
    private static final long serialVersionUID = -7273879239726265322L;
    private final Field<T> argument;
    private final Field<Integer> decimals;

    Round(Field<T> argument) {
        this(argument, null);
    }

    Round(Field<T> argument, Field<Integer> decimals) {
        super("round", argument.getDataType(), argument);
        this.argument = argument;
        this.decimals = decimals;
    }

    @Override
    final Field<T> getFunction0(Configuration configuration) {
        switch (configuration.family()) {
            case DERBY: {
                if (this.decimals == null) {
                    return DSL.when(this.argument.sub(DSL.floor(this.argument)).lessThan(0.5), DSL.floor(this.argument)).otherwise(DSL.ceil(this.argument));
                }
                if (this.decimals instanceof Param) {
                    Integer decimalsValue = (Integer)((Param)this.decimals).getValue();
                    Param<BigDecimal> factor = DSL.val(BigDecimal.ONE.movePointRight(decimalsValue));
                    Field<T> mul = this.argument.mul(factor);
                    return DSL.when(mul.sub(DSL.floor(mul)).lessThan(0.5), DSL.floor(mul).div(factor)).otherwise(DSL.ceil(mul).div(factor));
                }
            }
            case POSTGRES: {
                if (this.decimals == null) {
                    return DSL.function("round", this.getDataType(), this.argument);
                }
                return DSL.function("round", this.getDataType(), Tools.castIfNeeded(this.argument, BigDecimal.class), this.decimals);
            }
        }
        if (this.decimals == null) {
            return DSL.function("round", this.getDataType(), this.argument);
        }
        return DSL.function("round", this.getDataType(), this.argument, this.decimals);
    }
}

