/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.elasticsearch.schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchSchemaFactory;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.store.AbstractSchemaFactory;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.elasticsearch.ElasticsearchStoragePlugin;
import org.apache.drill.exec.store.elasticsearch.schema.ElasticsearchDrillSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchDrillSchemaFactory
extends AbstractSchemaFactory {
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchDrillSchemaFactory.class);
    private final ElasticsearchStoragePlugin plugin;
    private final ElasticsearchSchemaFactory delegate;

    public ElasticsearchDrillSchemaFactory(String name, ElasticsearchStoragePlugin plugin) {
        super(name);
        this.plugin = plugin;
        this.delegate = new ElasticsearchSchemaFactory();
    }

    public void registerSchemas(SchemaConfig schemaConfig, SchemaPlus parent) throws JsonProcessingException {
        ElasticsearchDrillSchema schema;
        if (this.plugin.getConfig().getAuthMode() == StoragePluginConfig.AuthMode.SHARED_USER) {
            Schema elasticsearchSchema = this.delegate.create(parent, this.getName(), this.plugin.getConfig().toConfigMap());
            schema = new ElasticsearchDrillSchema(this.getName(), (StoragePlugin)this.plugin, elasticsearchSchema);
        } else if (this.plugin.getConfig().getAuthMode() == StoragePluginConfig.AuthMode.USER_TRANSLATION) {
            Schema elasticsearchUTSchema = this.delegate.create(parent, this.getName(), this.plugin.getConfig().toConfigMap(schemaConfig.getUserName()));
            schema = new ElasticsearchDrillSchema(this.getName(), (StoragePlugin)this.plugin, elasticsearchUTSchema);
        } else {
            throw UserException.internalError().message("User Impersonation not supported as an authentication mode for ElasticSearch.  The only authentication modes supported are SHARED_USER and USER_TRANSLATION", new Object[0]).build(logger);
        }
        parent.add(this.getName(), (Schema)schema);
    }
}

