/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetNamespaceRequest
extends BmcRequest<Void> {
    private String opcClientRequestId;
    private String compartmentId;

    @ConstructorProperties(value={"opcClientRequestId", "compartmentId"})
    GetNamespaceRequest(String opcClientRequestId, String compartmentId) {
        this.opcClientRequestId = opcClientRequestId;
        this.compartmentId = compartmentId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().opcClientRequestId(this.opcClientRequestId).compartmentId(this.compartmentId);
    }

    public String toString() {
        return "GetNamespaceRequest(super=" + super.toString() + ", opcClientRequestId=" + this.getOpcClientRequestId() + ", compartmentId=" + this.getCompartmentId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetNamespaceRequest)) {
            return false;
        }
        GetNamespaceRequest other = (GetNamespaceRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$opcClientRequestId = this.getOpcClientRequestId();
        String other$opcClientRequestId = other.getOpcClientRequestId();
        if (this$opcClientRequestId == null ? other$opcClientRequestId != null : !this$opcClientRequestId.equals(other$opcClientRequestId)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        return !(this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetNamespaceRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $opcClientRequestId = this.getOpcClientRequestId();
        result = result * 59 + ($opcClientRequestId == null ? 43 : $opcClientRequestId.hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        return result;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetNamespaceRequest, Void> {
        private String opcClientRequestId;
        private String compartmentId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetNamespaceRequest o) {
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.compartmentId(o.getCompartmentId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetNamespaceRequest build() {
            GetNamespaceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public GetNamespaceRequest buildWithoutInvocationCallback() {
            return new GetNamespaceRequest(this.opcClientRequestId, this.compartmentId);
        }

        public String toString() {
            return "GetNamespaceRequest.Builder(opcClientRequestId=" + this.opcClientRequestId + ", compartmentId=" + this.compartmentId + ")";
        }
    }
}

