/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.BaseMutationPlan;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ByteUtil;

public class PostLocalIndexDDLCompiler {
    private final PhoenixConnection connection;
    private final String tableName;

    public PostLocalIndexDDLCompiler(PhoenixConnection connection, String tableName) {
        this.connection = connection;
        this.tableName = tableName;
    }

    public MutationPlan compile(PTable index) throws SQLException {
        try (PhoenixStatement statement = new PhoenixStatement(this.connection);){
            String query = "SELECT count(*) FROM " + this.tableName;
            QueryPlan plan = statement.compileQuery(query);
            TableRef tableRef = plan.getTableRef();
            Scan scan = plan.getContext().getScan();
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            PTable dataTable = tableRef.getTable();
            ArrayList indexes = Lists.newArrayListWithExpectedSize((int)1);
            for (PTable indexTable : dataTable.getIndexes()) {
                if (!indexTable.getKey().equals(index.getKey())) continue;
                index = indexTable;
                break;
            }
            indexes.add(index);
            IndexMaintainer.serialize(dataTable, ptr, indexes, plan.getContext().getConnection());
            scan.setAttribute("_LocalIndexBuild", ByteUtil.copyKeyBytesIfNecessary(ptr));
            IndexMaintainer indexMaintainer = index.getIndexMaintainer(dataTable, this.connection);
            for (ColumnReference columnRef : indexMaintainer.getAllColumns()) {
                if (index.getImmutableStorageScheme() == PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS) {
                    scan.addFamily(columnRef.getFamily());
                    continue;
                }
                scan.addColumn(columnRef.getFamily(), columnRef.getQualifier());
            }
            if (dataTable.isTransactional()) {
                scan.setAttribute("_TxState", this.connection.getMutationState().encodeTransaction());
            }
            PostLocalIndexDDLMutationPlan postLocalIndexDDLMutationPlan = new PostLocalIndexDDLMutationPlan(plan, dataTable);
            return postLocalIndexDDLMutationPlan;
        }
    }

    private class PostLocalIndexDDLMutationPlan
    extends BaseMutationPlan {
        private final QueryPlan plan;
        private final PTable dataTable;

        private PostLocalIndexDDLMutationPlan(QueryPlan plan, PTable dataTable) {
            super(plan.getContext(), PhoenixStatement.Operation.UPSERT);
            this.plan = plan;
            this.dataTable = dataTable;
        }

        @Override
        public MutationState execute() throws SQLException {
            PostLocalIndexDDLCompiler.this.connection.getMutationState().commitDDLFence(this.dataTable);
            Tuple tuple = this.plan.iterator().next();
            long rowCount = 0L;
            if (tuple != null) {
                Cell kv = tuple.getValue(0);
                ImmutableBytesWritable tmpPtr = new ImmutableBytesWritable(kv.getValueArray(), kv.getValueOffset(), kv.getValueLength());
                rowCount = PLong.INSTANCE.getCodec().decodeLong(tmpPtr, SortOrder.getDefault());
            }
            return new MutationState(0, 0L, PostLocalIndexDDLCompiler.this.connection, rowCount);
        }
    }
}

