/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.ScannerContextUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.htrace.Span;
import org.apache.htrace.Trace;
import org.apache.phoenix.compat.hbase.coprocessor.CompatBaseScannerRegionObserver;
import org.apache.phoenix.coprocessor.BaseRegionScanner;
import org.apache.phoenix.coprocessor.DelegateRegionScanner;
import org.apache.phoenix.coprocessor.PagedRegionScanner;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.filter.PagedFilter;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.iterate.NonAggregateRegionScannerFactory;
import org.apache.phoenix.schema.StaleRegionBoundaryCacheException;
import org.apache.phoenix.schema.types.PUnsignedTinyint;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.ServerUtil;

public abstract class BaseScannerRegionObserver
extends CompatBaseScannerRegionObserver {
    public static final String AGGREGATORS = "_Aggs";
    public static final String UNORDERED_GROUP_BY_EXPRESSIONS = "_UnorderedGroupByExpressions";
    public static final String KEY_ORDERED_GROUP_BY_EXPRESSIONS = "_OrderedGroupByExpressions";
    public static final String ESTIMATED_DISTINCT_VALUES = "_EstDistinctValues";
    public static final String NON_AGGREGATE_QUERY = "_NonAggregateQuery";
    public static final String TOPN = "_TopN";
    public static final String UNGROUPED_AGG = "_UngroupedAgg";
    public static final String DELETE_AGG = "_DeleteAgg";
    public static final String UPSERT_SELECT_TABLE = "_UpsertSelectTable";
    public static final String UPSERT_SELECT_EXPRS = "_UpsertSelectExprs";
    public static final String DELETE_CQ = "_DeleteCQ";
    public static final String DELETE_CF = "_DeleteCF";
    public static final String EMPTY_CF = "_EmptyCF";
    public static final String EMPTY_COLUMN_QUALIFIER = "_EmptyColumnQualifier";
    public static final String SPECIFIC_ARRAY_INDEX = "_SpecificArrayIndex";
    public static final String GROUP_BY_LIMIT = "_GroupByLimit";
    public static final String LOCAL_INDEX = "_LocalIndex";
    public static final String LOCAL_INDEX_BUILD = "_LocalIndexBuild";
    public static final String INDEX_REBUILD_PAGING = "_IndexRebuildPaging";
    public static final String INDEX_REBUILD_PAGE_ROWS = "_IndexRebuildPageRows";
    public static final String SERVER_PAGE_SIZE_MS = "_ServerPageSizeMs";
    public static final String INDEX_REBUILD_VERIFY_TYPE = "_IndexRebuildVerifyType";
    public static final String INDEX_RETRY_VERIFY = "_IndexRetryVerify";
    public static final String INDEX_REBUILD_DISABLE_LOGGING_VERIFY_TYPE = "_IndexRebuildDisableLoggingVerifyType";
    public static final String INDEX_REBUILD_DISABLE_LOGGING_BEYOND_MAXLOOKBACK_AGE = "_IndexRebuildDisableLoggingBeyondMaxLookbackAge";
    public static final String LOCAL_INDEX_FILTER = "_LocalIndexFilter";
    public static final String LOCAL_INDEX_LIMIT = "_LocalIndexLimit";
    public static final String LOCAL_INDEX_FILTER_STR = "_LocalIndexFilterStr";
    public static final String LOCAL_INDEX_BUILD_PROTO = "_LocalIndexBuild";
    public static final String LOCAL_INDEX_JOIN_SCHEMA = "_LocalIndexJoinSchema";
    public static final String DATA_TABLE_COLUMNS_TO_JOIN = "_DataTableColumnsToJoin";
    public static final String COLUMNS_STORED_IN_SINGLE_CELL = "_ColumnsStoredInSingleCell";
    public static final String VIEW_CONSTANTS = "_ViewConstants";
    public static final String EXPECTED_UPPER_REGION_KEY = "_ExpectedUpperRegionKey";
    public static final String REVERSE_SCAN = "_ReverseScan";
    public static final String ANALYZE_TABLE = "_ANALYZETABLE";
    public static final String REBUILD_INDEXES = "_RebuildIndexes";
    public static final String TX_STATE = "_TxState";
    public static final String GUIDEPOST_WIDTH_BYTES = "_GUIDEPOST_WIDTH_BYTES";
    public static final String GUIDEPOST_PER_REGION = "_GUIDEPOST_PER_REGION";
    public static final String UPGRADE_DESC_ROW_KEY = "_UPGRADE_DESC_ROW_KEY";
    public static final String SCAN_REGION_SERVER = "_SCAN_REGION_SERVER";
    public static final String RUN_UPDATE_STATS_ASYNC_ATTRIB = "_RunUpdateStatsAsync";
    public static final String SKIP_REGION_BOUNDARY_CHECK = "_SKIP_REGION_BOUNDARY_CHECK";
    public static final String TX_SCN = "_TxScn";
    public static final String PHOENIX_TTL = "_PhoenixTTL";
    public static final String MASK_PHOENIX_TTL_EXPIRED = "_MASK_TTL_EXPIRED";
    public static final String DELETE_PHOENIX_TTL_EXPIRED = "_DELETE_TTL_EXPIRED";
    public static final String PHOENIX_TTL_SCAN_TABLE_NAME = "_PhoenixTTLScanTableName";
    public static final String SCAN_ACTUAL_START_ROW = "_ScanActualStartRow";
    public static final String REPLAY_WRITES = "_IGNORE_NEWER_MUTATIONS";
    public static final String SCAN_OFFSET = "_RowOffset";
    public static final String SCAN_START_ROW_SUFFIX = "_ScanStartRowSuffix";
    public static final String SCAN_STOP_ROW_SUFFIX = "_ScanStopRowSuffix";
    public static final String MIN_QUALIFIER = "_MinQualifier";
    public static final String MAX_QUALIFIER = "_MaxQualifier";
    public static final String USE_NEW_VALUE_COLUMN_QUALIFIER = "_UseNewValueColumnQualifier";
    public static final String QUALIFIER_ENCODING_SCHEME = "_QualifierEncodingScheme";
    public static final String IMMUTABLE_STORAGE_ENCODING_SCHEME = "_ImmutableStorageEncodingScheme";
    public static final String USE_ENCODED_COLUMN_QUALIFIER_LIST = "_UseEncodedColumnQualifierList";
    public static final String CLIENT_VERSION = "_ClientVersion";
    public static final String CHECK_VERIFY_COLUMN = "_CheckVerifyColumn";
    public static final String PHYSICAL_DATA_TABLE_NAME = "_PhysicalDataTableName";
    public static final String EMPTY_COLUMN_FAMILY_NAME = "_EmptyCFName";
    public static final String EMPTY_COLUMN_QUALIFIER_NAME = "_EmptyCQName";
    public static final String INDEX_ROW_KEY = "_IndexRowKey";
    public static final byte[] REPLAY_TABLE_AND_INDEX_WRITES = PUnsignedTinyint.INSTANCE.toBytes(1);
    public static final byte[] REPLAY_ONLY_INDEX_WRITES = PUnsignedTinyint.INSTANCE.toBytes(2);
    public static final byte[] REPLAY_INDEX_REBUILD_WRITES = PUnsignedTinyint.INSTANCE.toBytes(3);
    public static final String CUSTOM_ANNOTATIONS = "_Annot";
    public static final String SCANNER_OPENED_TRACE_INFO = "Scanner opened on server";

    public String toString() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private static void throwIfScanOutOfRegion(Scan scan, Region region) throws DoNotRetryIOException {
        boolean isStaleRegionBoundaries;
        boolean isLocalIndex = ScanUtil.isLocalIndex(scan);
        byte[] lowerInclusiveScanKey = scan.getStartRow();
        byte[] upperExclusiveScanKey = scan.getStopRow();
        byte[] lowerInclusiveRegionKey = region.getRegionInfo().getStartKey();
        byte[] upperExclusiveRegionKey = region.getRegionInfo().getEndKey();
        if (isLocalIndex) {
            byte[] expectedUpperRegionKey = scan.getAttribute(EXPECTED_UPPER_REGION_KEY) == null ? scan.getStopRow() : scan.getAttribute(EXPECTED_UPPER_REGION_KEY);
            byte[] actualStartRow = scan.getAttribute(SCAN_ACTUAL_START_ROW);
            isStaleRegionBoundaries = expectedUpperRegionKey != null && Bytes.compareTo((byte[])upperExclusiveRegionKey, (byte[])expectedUpperRegionKey) != 0 || actualStartRow != null && Bytes.compareTo((byte[])actualStartRow, (byte[])lowerInclusiveRegionKey) < 0;
        } else {
            boolean bl = isStaleRegionBoundaries = Bytes.compareTo((byte[])lowerInclusiveScanKey, (byte[])lowerInclusiveRegionKey) < 0 || Bytes.compareTo((byte[])upperExclusiveScanKey, (byte[])upperExclusiveRegionKey) > 0 && upperExclusiveRegionKey.length != 0 || upperExclusiveRegionKey.length != 0 && upperExclusiveScanKey.length == 0;
        }
        if (isStaleRegionBoundaries) {
            StaleRegionBoundaryCacheException cause = new StaleRegionBoundaryCacheException(region.getRegionInfo().getTable().getNameAsString());
            throw new DoNotRetryIOException(cause.getMessage(), (Throwable)cause);
        }
        if (isLocalIndex) {
            ScanUtil.setupLocalIndexScan(scan);
        }
    }

    protected abstract boolean isRegionObserverFor(Scan var1);

    protected abstract RegionScanner doPostScannerOpen(ObserverContext<RegionCoprocessorEnvironment> var1, Scan var2, RegionScanner var3) throws Throwable;

    protected boolean skipRegionBoundaryCheck(Scan scan) {
        byte[] skipCheckBytes = scan.getAttribute(SKIP_REGION_BOUNDARY_CHECK);
        return skipCheckBytes != null && Bytes.toBoolean((byte[])skipCheckBytes);
    }

    public void preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan) throws IOException {
        byte[] txnScn = scan.getAttribute(TX_SCN);
        if (txnScn != null) {
            TimeRange timeRange = scan.getTimeRange();
            scan.setTimeRange(timeRange.getMin(), Bytes.toLong((byte[])txnScn));
        }
        if (this.isRegionObserverFor(scan)) {
            byte[] pageSizeMsBytes;
            if (!this.skipRegionBoundaryCheck(scan) || ScanUtil.isLocalIndex(scan)) {
                BaseScannerRegionObserver.throwIfScanOutOfRegion(scan, ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion());
            }
            ScanUtil.setupReverseScan(scan);
            if (scan.getFilter() != null && !(scan.getFilter() instanceof PagedFilter) && (pageSizeMsBytes = scan.getAttribute(SERVER_PAGE_SIZE_MS)) != null) {
                scan.setFilter((Filter)new PagedFilter(scan.getFilter(), ScanUtil.getPageSizeMsForFilter(scan)));
            }
        }
    }

    public final RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        try {
            if (!this.isRegionObserverFor(scan)) {
                return s;
            }
            return new RegionScannerHolder(c, scan, (RegionScanner)(s instanceof BaseRegionScanner ? s : new PagedRegionScanner(((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion(), s, scan)));
        }
        catch (Throwable t) {
            if (t instanceof NotServingRegionException) {
                StaleRegionBoundaryCacheException cause = new StaleRegionBoundaryCacheException(((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo().getTable().getNameAsString());
                throw new DoNotRetryIOException(cause.getMessage(), (Throwable)cause);
            }
            ServerUtil.throwIOException(((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo().getRegionNameAsString(), t);
            return null;
        }
    }

    RegionScanner getWrappedScanner(ObserverContext<RegionCoprocessorEnvironment> c, RegionScanner s, int offset, Scan scan, ColumnReference[] dataColumns, TupleProjector tupleProjector, Region dataRegion, IndexMaintainer indexMaintainer, byte[][] viewConstants, TupleProjector projector, ImmutableBytesWritable ptr, boolean useQualiferAsListIndex) {
        NonAggregateRegionScannerFactory regionScannerFactory = new NonAggregateRegionScannerFactory((RegionCoprocessorEnvironment)c.getEnvironment());
        return regionScannerFactory.getWrappedScanner((RegionCoprocessorEnvironment)c.getEnvironment(), s, null, null, offset, scan, dataColumns, tupleProjector, dataRegion, indexMaintainer, null, viewConstants, null, null, projector, ptr, useQualiferAsListIndex);
    }

    private class RegionScannerHolder
    extends DelegateRegionScanner {
        private final Scan scan;
        private final ObserverContext<RegionCoprocessorEnvironment> c;
        private boolean wasOverriden;

        public RegionScannerHolder(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner scanner) {
            super(scanner);
            this.c = c;
            this.scan = scan;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void overrideDelegate() throws IOException {
            if (this.wasOverriden) {
                return;
            }
            boolean success = false;
            Span savedSpan = Trace.currentSpan();
            final Span child = Trace.startSpan((String)BaseScannerRegionObserver.SCANNER_OPENED_TRACE_INFO, (Span)savedSpan).getSpan();
            try {
                RegionScanner scanner = BaseScannerRegionObserver.this.doPostScannerOpen(this.c, this.scan, this.delegate);
                this.delegate = scanner = new DelegateRegionScanner(scanner){

                    @Override
                    public void close() throws IOException {
                        try {
                            this.delegate.close();
                        }
                        finally {
                            if (child != null) {
                                child.stop();
                            }
                        }
                    }
                };
                this.wasOverriden = true;
                success = true;
            }
            catch (Throwable t) {
                ServerUtil.throwIOException(((RegionCoprocessorEnvironment)this.c.getEnvironment()).getRegionInfo().getRegionNameAsString(), t);
            }
            finally {
                try {
                    if (!success && child != null) {
                        child.stop();
                    }
                }
                finally {
                    Trace.continueSpan((Span)savedSpan);
                }
            }
        }

        @Override
        public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
            this.overrideDelegate();
            boolean res = super.next(result);
            ScannerContextUtil.incrementSizeProgress(scannerContext, result);
            ScannerContextUtil.updateTimeProgress(scannerContext);
            return res;
        }

        @Override
        public boolean next(List<Cell> result) throws IOException {
            this.overrideDelegate();
            return super.next(result);
        }

        @Override
        public boolean nextRaw(List<Cell> result, ScannerContext scannerContext) throws IOException {
            this.overrideDelegate();
            boolean res = super.nextRaw(result);
            ScannerContextUtil.incrementSizeProgress(scannerContext, result);
            ScannerContextUtil.updateTimeProgress(scannerContext);
            return res;
        }

        @Override
        public boolean nextRaw(List<Cell> result) throws IOException {
            this.overrideDelegate();
            return super.nextRaw(result);
        }
    }

    public static enum ReplayWrite {
        TABLE_AND_INDEX,
        INDEX_ONLY,
        REBUILD_INDEX_ONLY;


        public static ReplayWrite fromBytes(byte[] replayWriteBytes) {
            if (replayWriteBytes == null) {
                return null;
            }
            if (Bytes.compareTo((byte[])REPLAY_TABLE_AND_INDEX_WRITES, (byte[])replayWriteBytes) == 0) {
                return TABLE_AND_INDEX;
            }
            if (Bytes.compareTo((byte[])REPLAY_ONLY_INDEX_WRITES, (byte[])replayWriteBytes) == 0) {
                return INDEX_ONLY;
            }
            if (Bytes.compareTo((byte[])REPLAY_INDEX_REBUILD_WRITES, (byte[])replayWriteBytes) == 0) {
                return REBUILD_INDEX_ONLY;
            }
            throw new IllegalArgumentException("Unknown ReplayWrite code of " + Bytes.toStringBinary((byte[])replayWriteBytes));
        }
    }
}

