/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.expression.BaseSingleExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;

public class CoerceExpression
extends BaseSingleExpression {
    private PDataType toType;
    private SortOrder toSortOrder;
    private Integer maxLength;
    private boolean rowKeyOrderOptimizable;

    public CoerceExpression() {
    }

    public static Expression create(Expression expression, PDataType toType) throws SQLException {
        if (toType == expression.getDataType()) {
            return expression;
        }
        return new CoerceExpression(expression, toType);
    }

    public static Expression create(Expression expression, PDataType toType, SortOrder toSortOrder, Integer maxLength) throws SQLException {
        return CoerceExpression.create(expression, toType, toSortOrder, maxLength, true);
    }

    public static Expression create(Expression expression, PDataType toType, SortOrder toSortOrder, Integer maxLength, boolean rowKeyOrderOptimizable) throws SQLException {
        if (toType == expression.getDataType() && toSortOrder == expression.getSortOrder() && (maxLength == null || maxLength.equals(expression.getMaxLength()))) {
            return expression;
        }
        return new CoerceExpression(expression, toType, toSortOrder, maxLength, rowKeyOrderOptimizable);
    }

    CoerceExpression(Expression expression, PDataType toType) {
        this(expression, toType, expression.getSortOrder(), null, true);
    }

    CoerceExpression(Expression expression, PDataType toType, SortOrder toSortOrder, Integer maxLength, boolean rowKeyOrderOptimizable) {
        this((List<Expression>)ImmutableList.of((Object)expression), toType, toSortOrder, maxLength, rowKeyOrderOptimizable);
    }

    public CoerceExpression(List<Expression> children, PDataType toType, SortOrder toSortOrder, Integer maxLength, boolean rowKeyOrderOptimizable) {
        super(children);
        Preconditions.checkNotNull((Object)((Object)toSortOrder));
        this.toType = toType;
        this.toSortOrder = toSortOrder;
        this.maxLength = maxLength;
        this.rowKeyOrderOptimizable = rowKeyOrderOptimizable;
    }

    public CoerceExpression clone(List<Expression> children) {
        return new CoerceExpression(children, this.getDataType(), this.getSortOrder(), this.getMaxLength(), this.rowKeyOrderOptimizable);
    }

    @Override
    public Integer getMaxLength() {
        return this.maxLength;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.maxLength == null ? 0 : this.maxLength.hashCode());
        result = 31 * result + (this.toSortOrder == null ? 0 : this.toSortOrder.hashCode());
        result = 31 * result + (this.toType == null ? 0 : this.toType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoerceExpression other = (CoerceExpression)obj;
        if (this.maxLength == null ? other.maxLength != null : !this.maxLength.equals(other.maxLength)) {
            return false;
        }
        if (this.toSortOrder != other.toSortOrder) {
            return false;
        }
        if (this.toType == null ? other.toType != null : !this.toType.equals(other.toType)) {
            return false;
        }
        return this.rowKeyOrderOptimizable == other.rowKeyOrderOptimizable;
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        int ordinal = WritableUtils.readVInt((DataInput)input);
        this.rowKeyOrderOptimizable = false;
        if (ordinal < 0) {
            this.rowKeyOrderOptimizable = true;
            ordinal = -(ordinal + 1);
        }
        this.toType = PDataType.values()[ordinal];
        this.toSortOrder = SortOrder.fromSystemValue(WritableUtils.readVInt((DataInput)input));
        int byteSize = WritableUtils.readVInt((DataInput)input);
        this.maxLength = byteSize == -1 ? null : Integer.valueOf(byteSize);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        if (this.rowKeyOrderOptimizable) {
            WritableUtils.writeVInt((DataOutput)output, (int)(-(this.toType.ordinal() + 1)));
        } else {
            WritableUtils.writeVInt((DataOutput)output, (int)this.toType.ordinal());
        }
        WritableUtils.writeVInt((DataOutput)output, (int)this.toSortOrder.getSystemValue());
        WritableUtils.writeVInt((DataOutput)output, (int)(this.maxLength == null ? -1 : this.maxLength));
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (this.getChild().evaluate(tuple, ptr)) {
            this.getDataType().coerceBytes(ptr, null, this.getChild().getDataType(), this.getChild().getMaxLength(), null, this.getChild().getSortOrder(), this.maxLength, null, this.getSortOrder(), this.rowKeyOrderOptimizable);
            return true;
        }
        return false;
    }

    @Override
    public PDataType getDataType() {
        return this.toType;
    }

    @Override
    public SortOrder getSortOrder() {
        return this.toSortOrder;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        List<T> l = this.acceptChildren(visitor, visitor.visitEnter(this));
        T t = visitor.visitLeave(this, l);
        if (t == null) {
            t = visitor.defaultReturn(this, l);
        }
        return t;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("TO_" + this.toType.toString() + "(");
        for (int i = 0; i < this.children.size() - 1; ++i) {
            buf.append(this.children.get(i) + ", ");
        }
        buf.append(this.children.get(this.children.size() - 1) + ")");
        return buf.toString();
    }
}

