/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.aggregator;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.ColumnExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.aggregator.DistinctValueWithCountClientAggregator;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.util.ByteUtil;

public class PercentileClientAggregator
extends DistinctValueWithCountClientAggregator {
    private final List<Expression> exps;

    public PercentileClientAggregator(List<Expression> exps, SortOrder sortOrder) {
        super(sortOrder);
        this.exps = exps;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (this.cachedResult == null) {
            ColumnExpression columnExp = (ColumnExpression)this.exps.get(0);
            LiteralExpression isAscendingExpression = (LiteralExpression)this.exps.get(1);
            boolean isAscending = (Boolean)isAscendingExpression.getValue();
            LiteralExpression percentileExp = (LiteralExpression)this.exps.get(2);
            float p = ((Number)percentileExp.getValue()).floatValue();
            Map<Object, Integer> sorted = this.getSortedValueVsCount(isAscending, columnExp.getDataType());
            float i = p * (float)this.totalCount + 0.5f;
            long k = (long)i;
            float f = i - (float)k;
            Object o1 = null;
            Object o2 = null;
            long distinctCountsSum = 0L;
            for (Map.Entry<Object, Integer> entry : sorted.entrySet()) {
                if (o1 != null) {
                    o2 = entry.getKey();
                    break;
                }
                if ((distinctCountsSum += (long)entry.getValue().intValue()) == k) {
                    o1 = entry.getKey();
                    continue;
                }
                if (distinctCountsSum <= k) continue;
                o1 = o2 = entry.getKey();
                break;
            }
            double result = 0.0;
            Number n1 = (Number)o1;
            if (o1 == null && o2 == null) {
                ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
                return true;
            }
            if (o2 == null || o1 == o2) {
                result = n1.doubleValue();
            } else {
                Number n2 = (Number)o2;
                result = n1.doubleValue() * (double)(1.0f - f) + n2.doubleValue() * (double)f;
            }
            this.cachedResult = new BigDecimal(result);
        }
        if (this.buffer == null) {
            this.initBuffer();
        }
        this.buffer = PDecimal.INSTANCE.toBytes(this.cachedResult);
        ptr.set(this.buffer);
        return true;
    }

    @Override
    protected PDataType getResultDataType() {
        return PDecimal.INSTANCE;
    }
}

