/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.CeilMonthExpression;
import org.apache.phoenix.expression.function.CeilWeekExpression;
import org.apache.phoenix.expression.function.CeilYearExpression;
import org.apache.phoenix.expression.function.RoundDateExpression;
import org.apache.phoenix.expression.function.TimeUnit;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;

@FunctionParseNode.BuiltInFunction(name="CEIL", args={@FunctionParseNode.Argument(allowedTypes={PDate.class}), @FunctionParseNode.Argument(allowedTypes={PVarchar.class, PInteger.class}, defaultValue="null", isConstant=true), @FunctionParseNode.Argument(allowedTypes={PInteger.class}, defaultValue="1", isConstant=true)}, classType=FunctionParseNode.FunctionClassType.DERIVED)
public class CeilDateExpression
extends RoundDateExpression {
    public CeilDateExpression() {
    }

    public static Expression create(Expression expr, TimeUnit timeUnit) throws SQLException {
        return CeilDateExpression.create(expr, timeUnit, 1);
    }

    public static Expression create(Expression expr, TimeUnit timeUnit, int multiplier) throws SQLException {
        Expression timeUnitExpr = CeilDateExpression.getTimeUnitExpr(timeUnit);
        Expression defaultMultiplierExpr = CeilDateExpression.getMultiplierExpr(multiplier);
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{expr, timeUnitExpr, defaultMultiplierExpr});
        return CeilDateExpression.create(expressions);
    }

    public static Expression create(List<Expression> children) throws SQLException {
        Object timeUnitValue = ((LiteralExpression)children.get(1)).getValue();
        TimeUnit timeUnit = TimeUnit.getTimeUnit(timeUnitValue != null ? timeUnitValue.toString() : null);
        switch (timeUnit) {
            case WEEK: {
                return new CeilWeekExpression(children);
            }
            case MONTH: {
                return new CeilMonthExpression(children);
            }
            case YEAR: {
                return new CeilYearExpression(children);
            }
        }
        return new CeilDateExpression(children);
    }

    public CeilDateExpression(List<Expression> children) {
        super(children);
    }

    @Override
    protected long getRoundUpAmount() {
        return this.divBy - 1L;
    }

    @Override
    public String getName() {
        return "CEIL";
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (((Expression)this.children.get(0)).evaluate(tuple, ptr)) {
            if (ptr.getLength() == 0) {
                return true;
            }
            PDataType dataType = this.getDataType();
            long time = dataType.getCodec().decodeLong(ptr, ((Expression)this.children.get(0)).getSortOrder());
            long value = this.roundTime(time);
            Date d = new Date(value);
            byte[] byteValue = dataType.toBytes(d);
            ptr.set(byteValue);
            return true;
        }
        return false;
    }
}

