/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.monitoring.CombinableMetric;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.monitoring.ScanMetricsHolder;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.ServerUtil;

public class ScanningResultIterator
implements ResultIterator {
    private final ResultScanner scanner;
    private final ScanMetricsHolder scanMetricsHolder;
    boolean scanMetricsUpdated;
    boolean scanMetricsEnabled;

    public ScanningResultIterator(ResultScanner scanner, Scan scan, ScanMetricsHolder scanMetricsHolder) {
        this.scanner = scanner;
        this.scanMetricsHolder = scanMetricsHolder;
        this.scanMetricsUpdated = false;
        this.scanMetricsEnabled = scan.isScanMetricsEnabled();
    }

    @Override
    public void close() throws SQLException {
        this.scanner.close();
        this.updateMetrics();
    }

    private void changeMetric(CombinableMetric metric, Long value) {
        if (value != null) {
            metric.change(value);
        }
    }

    private void changeMetric(GlobalClientMetrics metric, Long value) {
        if (value != null) {
            metric.update(value);
        }
    }

    private void updateMetrics() {
        if (this.scanMetricsEnabled && !this.scanMetricsUpdated) {
            ScanMetrics scanMetrics = this.scanner.getScanMetrics();
            Map scanMetricsMap = scanMetrics.getMetricsMap();
            this.scanMetricsHolder.setScanMetricMap(scanMetricsMap);
            this.changeMetric(this.scanMetricsHolder.getCountOfRPCcalls(), (Long)scanMetricsMap.get("RPC_CALLS"));
            this.changeMetric(this.scanMetricsHolder.getCountOfRemoteRPCcalls(), (Long)scanMetricsMap.get("REMOTE_RPC_CALLS"));
            this.changeMetric(this.scanMetricsHolder.getSumOfMillisSecBetweenNexts(), (Long)scanMetricsMap.get("MILLIS_BETWEEN_NEXTS"));
            this.changeMetric(this.scanMetricsHolder.getCountOfNSRE(), (Long)scanMetricsMap.get("NOT_SERVING_REGION_EXCEPTION"));
            this.changeMetric(this.scanMetricsHolder.getCountOfBytesInResults(), (Long)scanMetricsMap.get("BYTES_IN_RESULTS"));
            this.changeMetric(this.scanMetricsHolder.getCountOfBytesInRemoteResults(), (Long)scanMetricsMap.get("BYTES_IN_REMOTE_RESULTS"));
            this.changeMetric(this.scanMetricsHolder.getCountOfRegions(), (Long)scanMetricsMap.get("REGIONS_SCANNED"));
            this.changeMetric(this.scanMetricsHolder.getCountOfRPCRetries(), (Long)scanMetricsMap.get("RPC_RETRIES"));
            this.changeMetric(this.scanMetricsHolder.getCountOfRemoteRPCRetries(), (Long)scanMetricsMap.get("REMOTE_RPC_RETRIES"));
            this.changeMetric(this.scanMetricsHolder.getCountOfRowsScanned(), (Long)scanMetricsMap.get("ROWS_SCANNED"));
            this.changeMetric(this.scanMetricsHolder.getCountOfRowsFiltered(), (Long)scanMetricsMap.get("ROWS_FILTERED"));
            this.changeMetric(GlobalClientMetrics.GLOBAL_SCAN_BYTES, (Long)scanMetricsMap.get("BYTES_IN_RESULTS"));
            this.changeMetric(GlobalClientMetrics.GLOBAL_HBASE_COUNT_RPC_CALLS, (Long)scanMetricsMap.get("RPC_CALLS"));
            this.changeMetric(GlobalClientMetrics.GLOBAL_HBASE_COUNT_REMOTE_RPC_CALLS, (Long)scanMetricsMap.get("REMOTE_RPC_CALLS"));
            this.changeMetric(GlobalClientMetrics.GLOBAL_HBASE_COUNT_MILLS_BETWEEN_NEXTS, (Long)scanMetricsMap.get("MILLIS_BETWEEN_NEXTS"));
            this.changeMetric(GlobalClientMetrics.GLOBAL_HBASE_COUNT_NOT_SERVING_REGION_EXCEPTION, (Long)scanMetricsMap.get("NOT_SERVING_REGION_EXCEPTION"));
            this.changeMetric(GlobalClientMetrics.GLOBAL_HBASE_COUNT_BYTES_REGION_SERVER_RESULTS, (Long)scanMetricsMap.get("BYTES_IN_RESULTS"));
            this.changeMetric(GlobalClientMetrics.GLOBAL_HBASE_COUNT_BYTES_IN_REMOTE_RESULTS, (Long)scanMetricsMap.get("BYTES_IN_REMOTE_RESULTS"));
            this.changeMetric(GlobalClientMetrics.GLOBAL_HBASE_COUNT_SCANNED_REGIONS, (Long)scanMetricsMap.get("REGIONS_SCANNED"));
            this.changeMetric(GlobalClientMetrics.GLOBAL_HBASE_COUNT_RPC_RETRIES, (Long)scanMetricsMap.get("RPC_RETRIES"));
            this.changeMetric(GlobalClientMetrics.GLOBAL_HBASE_COUNT_REMOTE_RPC_RETRIES, (Long)scanMetricsMap.get("REMOTE_RPC_RETRIES"));
            this.changeMetric(GlobalClientMetrics.GLOBAL_HBASE_COUNT_ROWS_SCANNED, (Long)scanMetricsMap.get("ROWS_SCANNED"));
            this.changeMetric(GlobalClientMetrics.GLOBAL_HBASE_COUNT_ROWS_FILTERED, (Long)scanMetricsMap.get("ROWS_FILTERED"));
            this.scanMetricsUpdated = true;
        }
    }

    @Override
    public Tuple next() throws SQLException {
        try {
            Result result = this.scanner.next();
            while (result != null && (result.isEmpty() || ScanUtil.isDummy(result))) {
                result = this.scanner.next();
            }
            if (result == null) {
                this.close();
                return null;
            }
            return new ResultTuple(result);
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
    }

    @Override
    public void explain(List<String> planSteps) {
    }

    @Override
    public void explain(List<String> planSteps, ExplainPlanAttributes.ExplainPlanAttributesBuilder explainPlanAttributesBuilder) {
    }

    public String toString() {
        return "ScanningResultIterator [scanner=" + this.scanner + "]";
    }

    public ResultScanner getScanner() {
        return this.scanner;
    }
}

