/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.index;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ColumnInfo;

public class PhoenixIndexDBWritable
implements DBWritable {
    private List<ColumnInfo> columnMetadata;
    private List<Object> values;
    private int columnCount = -1;
    private long rowTs = -1L;

    public void write(PreparedStatement statement) throws SQLException {
        Preconditions.checkNotNull(this.values);
        Preconditions.checkNotNull(this.columnMetadata);
        for (int i = 0; i < this.values.size(); ++i) {
            Object value = this.values.get(i);
            ColumnInfo columnInfo = this.columnMetadata.get(i);
            if (value == null) {
                statement.setNull(i + 1, columnInfo.getSqlType());
                continue;
            }
            statement.setObject(i + 1, value, columnInfo.getSqlType());
        }
    }

    public void readFields(ResultSet resultSet) throws SQLException {
        if (this.columnCount == -1) {
            this.columnCount = resultSet.getMetaData().getColumnCount();
        }
        if (this.columnCount > 0) {
            this.rowTs = resultSet.unwrap(PhoenixResultSet.class).getCurrentRow().getValue(0).getTimestamp();
        }
        this.values = Lists.newArrayListWithCapacity((int)this.columnCount);
        for (int i = 0; i < this.columnCount; ++i) {
            Object value = resultSet.getObject(i + 1);
            this.values.add(value);
        }
    }

    public List<ColumnInfo> getColumnMetadata() {
        return this.columnMetadata;
    }

    public void setColumnMetadata(List<ColumnInfo> columnMetadata) {
        this.columnMetadata = columnMetadata;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public void setValues(List<Object> values) {
        this.values = values;
    }

    public long getRowTs() {
        return this.rowTs;
    }
}

