/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.parse.PSchema;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableRef;
import org.apache.phoenix.schema.PTableRefFactory;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.thirdparty.com.google.common.collect.MinMaxPriorityQueue;
import org.apache.phoenix.thirdparty.com.google.common.primitives.Longs;
import org.apache.phoenix.util.TimeKeeper;

class PMetaDataCache
implements Cloneable {
    private static final int MIN_REMOVAL_SIZE = 3;
    private static final Comparator<PTableRef> COMPARATOR = new Comparator<PTableRef>(){

        @Override
        public int compare(PTableRef tableRef1, PTableRef tableRef2) {
            return Longs.compare((long)tableRef1.getLastAccessTime(), (long)tableRef2.getLastAccessTime());
        }
    };
    private static final MinMaxPriorityQueue.Builder<PTableRef> BUILDER = MinMaxPriorityQueue.orderedBy(COMPARATOR);
    private long currentByteSize;
    private final long maxByteSize;
    private final int expectedCapacity;
    private final TimeKeeper timeKeeper;
    private final PTableRefFactory tableRefFactory;
    private final Map<PTableKey, PTableRef> tables;
    final Map<PTableKey, PFunction> functions;
    final Map<PTableKey, PSchema> schemas;

    private static Map<PTableKey, PTableRef> newMap(int expectedCapacity) {
        return Maps.newHashMapWithExpectedSize((int)expectedCapacity);
    }

    private static Map<PTableKey, PFunction> newFunctionMap(int expectedCapacity) {
        return Maps.newHashMapWithExpectedSize((int)expectedCapacity);
    }

    private static Map<PTableKey, PSchema> newSchemaMap(int expectedCapacity) {
        return Maps.newHashMapWithExpectedSize((int)expectedCapacity);
    }

    private Map<PTableKey, PTableRef> cloneMap(Map<PTableKey, PTableRef> tables, int expectedCapacity) {
        Map<PTableKey, PTableRef> newTables = PMetaDataCache.newMap(Math.max(tables.size(), expectedCapacity));
        for (PTableRef tableAccess : tables.values()) {
            newTables.put(tableAccess.getTable().getKey(), this.tableRefFactory.makePTableRef(tableAccess));
        }
        return newTables;
    }

    private static Map<PTableKey, PSchema> cloneSchemaMap(Map<PTableKey, PSchema> schemas, int expectedCapacity) {
        Map<PTableKey, PSchema> newSchemas = PMetaDataCache.newSchemaMap(Math.max(schemas.size(), expectedCapacity));
        for (PSchema schema : schemas.values()) {
            newSchemas.put(schema.getSchemaKey(), new PSchema(schema));
        }
        return newSchemas;
    }

    private static Map<PTableKey, PFunction> cloneFunctionsMap(Map<PTableKey, PFunction> functions, int expectedCapacity) {
        Map<PTableKey, PFunction> newFunctions = PMetaDataCache.newFunctionMap(Math.max(functions.size(), expectedCapacity));
        for (PFunction functionAccess : functions.values()) {
            newFunctions.put(functionAccess.getKey(), new PFunction(functionAccess));
        }
        return newFunctions;
    }

    PMetaDataCache(PMetaDataCache toClone) {
        this.tableRefFactory = toClone.tableRefFactory;
        this.timeKeeper = toClone.timeKeeper;
        this.maxByteSize = toClone.maxByteSize;
        this.currentByteSize = toClone.currentByteSize;
        this.expectedCapacity = toClone.expectedCapacity;
        this.tables = this.cloneMap(toClone.tables, this.expectedCapacity);
        this.functions = PMetaDataCache.cloneFunctionsMap(toClone.functions, this.expectedCapacity);
        this.schemas = PMetaDataCache.cloneSchemaMap(toClone.schemas, this.expectedCapacity);
    }

    public PMetaDataCache(int initialCapacity, long maxByteSize, TimeKeeper timeKeeper, PTableRefFactory tableRefFactory) {
        this.currentByteSize = 0L;
        this.maxByteSize = maxByteSize;
        this.expectedCapacity = initialCapacity;
        this.tables = PMetaDataCache.newMap(this.expectedCapacity);
        this.functions = PMetaDataCache.newFunctionMap(this.expectedCapacity);
        this.timeKeeper = timeKeeper;
        this.schemas = PMetaDataCache.newSchemaMap(this.expectedCapacity);
        this.tableRefFactory = tableRefFactory;
    }

    public PTableRef get(PTableKey key) {
        PTableRef tableAccess = this.tables.get(key);
        if (tableAccess == null) {
            return null;
        }
        tableAccess.setLastAccessTime(this.timeKeeper.getCurrentTime());
        return tableAccess;
    }

    public PMetaDataCache clone() {
        return new PMetaDataCache(this);
    }

    public PMetaDataCache cloneMinusOverage(long overage) {
        assert (overage > 0L);
        int nToRemove = Math.max(3, (int)Math.ceil((double)(this.currentByteSize - this.maxByteSize) / ((double)this.currentByteSize / (double)this.size())) + 1);
        MinMaxPriorityQueue toRemove = BUILDER.expectedSize(nToRemove).create();
        PMetaDataCache newCache = new PMetaDataCache(this.size(), this.maxByteSize, this.timeKeeper, this.tableRefFactory);
        long toRemoveBytes = 0L;
        for (PTableRef tableRef : this.tables.values()) {
            newCache.put(tableRef.getTable().getKey(), this.tableRefFactory.makePTableRef(tableRef));
            toRemove.add((Object)tableRef);
            toRemoveBytes += (long)tableRef.getEstimatedSize();
            while (toRemoveBytes - (long)((PTableRef)toRemove.peekLast()).getEstimatedSize() >= overage) {
                PTableRef removedRef = (PTableRef)toRemove.removeLast();
                toRemoveBytes -= (long)removedRef.getEstimatedSize();
            }
        }
        for (PTableRef toRemoveRef : toRemove) {
            newCache.remove(toRemoveRef.getTable().getKey());
        }
        return newCache;
    }

    PTable put(PTableKey key, PTableRef ref) {
        this.currentByteSize += (long)ref.getEstimatedSize();
        PTableRef oldTableAccess = this.tables.put(key, ref);
        PTable oldTable = null;
        if (oldTableAccess != null) {
            this.currentByteSize -= (long)oldTableAccess.getEstimatedSize();
            oldTable = oldTableAccess.getTable();
        }
        return oldTable;
    }

    public long getAge(PTableRef ref) {
        return this.timeKeeper.getCurrentTime() - ref.getCreateTime();
    }

    public PTable remove(PTableKey key) {
        PTableRef value = this.tables.remove(key);
        if (value == null) {
            return null;
        }
        this.currentByteSize -= (long)value.getEstimatedSize();
        return value.getTable();
    }

    public Iterator<PTable> iterator() {
        final Iterator<PTableRef> iterator = this.tables.values().iterator();
        return new Iterator<PTable>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public PTable next() {
                return ((PTableRef)iterator.next()).getTable();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int size() {
        return this.tables.size();
    }

    public long getCurrentSize() {
        return this.currentByteSize;
    }

    public long getMaxSize() {
        return this.maxByteSize;
    }
}

