/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.Array;
import java.sql.SQLException;
import java.text.Format;
import java.util.Date;
import java.util.Random;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.types.DataType;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Order;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.ConstraintViolationException;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PDataTypeFactory;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PUnsignedDouble;
import org.apache.phoenix.schema.types.PUnsignedFloat;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PhoenixArray;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.math.LongMath;
import org.apache.phoenix.thirdparty.com.google.common.primitives.Doubles;
import org.apache.phoenix.thirdparty.com.google.common.primitives.Longs;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.ScanUtil;

public abstract class PDataType<T>
implements DataType<T>,
Comparable<PDataType<?>> {
    private final String sqlTypeName;
    private final int sqlType;
    private final Class clazz;
    private final byte[] clazzNameBytes;
    private final byte[] sqlTypeNameBytes;
    private final PDataCodec codec;
    private final int ordinal;
    public static final int MAX_PRECISION = 38;
    public static final int MIN_DECIMAL_AVG_SCALE = 4;
    public static final MathContext DEFAULT_MATH_CONTEXT = new MathContext(38, RoundingMode.HALF_UP);
    public static final int DEFAULT_SCALE = 0;
    protected static final Integer MAX_BIG_DECIMAL_BYTES = 21;
    protected static final Integer MAX_TIMESTAMP_BYTES = 12;
    protected static final byte ZERO_BYTE = -128;
    protected static final byte NEG_TERMINAL_BYTE = 102;
    protected static final int EXP_BYTE_OFFSET = 65;
    protected static final int POS_DIGIT_OFFSET = 1;
    protected static final int NEG_DIGIT_OFFSET = 101;
    protected static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    protected static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    protected static final long MAX_LONG_FOR_DESERIALIZE = 9223372036854775L;
    protected static final BigInteger ONE_HUNDRED = BigInteger.valueOf(100L);
    protected static final byte FALSE_BYTE = 0;
    protected static final byte TRUE_BYTE = 1;
    public static final byte[] FALSE_BYTES = new byte[]{0};
    public static final byte[] TRUE_BYTES = new byte[]{1};
    public static final byte[] NULL_BYTES = ByteUtil.EMPTY_BYTE_ARRAY;
    protected static final Integer BOOLEAN_LENGTH = 1;
    public static final Integer ZERO = 0;
    public static final Integer INT_PRECISION = 10;
    public static final Integer LONG_PRECISION = 19;
    public static final Integer SHORT_PRECISION = 5;
    public static final Integer BYTE_PRECISION = 3;
    public static final Integer DOUBLE_PRECISION = 15;
    public static final int ARRAY_TYPE_BASE = 3000;
    public static final String ARRAY_TYPE_SUFFIX = "ARRAY";
    protected static final ThreadLocal<Random> RANDOM = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random();
        }
    };
    private static final PhoenixArrayFactory DEFAULT_ARRAY_FACTORY = new PhoenixArrayFactory(){

        @Override
        public PhoenixArray newArray(PDataType type, Object[] elements) {
            return new PhoenixArray(type, elements);
        }
    };

    protected PDataType(String sqlTypeName, int sqlType, Class clazz, PDataCodec codec, int ordinal) {
        this.sqlTypeName = sqlTypeName;
        this.sqlType = sqlType;
        this.clazz = clazz;
        this.clazzNameBytes = Bytes.toBytes((String)clazz.getName());
        this.sqlTypeNameBytes = Bytes.toBytes((String)sqlTypeName);
        this.codec = codec;
        this.ordinal = ordinal;
    }

    public static PDataType[] values() {
        return PDataTypeFactory.getInstance().getOrderedTypes();
    }

    public int ordinal() {
        return this.ordinal;
    }

    public Class<T> encodedClass() {
        return this.getJavaClass();
    }

    public boolean isCastableTo(PDataType targetType) {
        return this.isComparableTo(targetType);
    }

    public final PDataCodec getCodec() {
        return this.codec;
    }

    public boolean isBytesComparableWith(PDataType otherType) {
        return PDataType.equalsAny(this, otherType, PVarbinary.INSTANCE, PBinary.INSTANCE);
    }

    public int estimateByteSize(Object o) {
        if (this.isFixedWidth()) {
            return this.getByteSize();
        }
        if (this.isArrayType()) {
            PhoenixArray array = (PhoenixArray)o;
            int noOfElements = array.numElements;
            int totalVarSize = 0;
            for (int i = 0; i < noOfElements; ++i) {
                totalVarSize += array.estimateByteSize(i);
            }
            return totalVarSize;
        }
        throw new UnsupportedOperationException();
    }

    public Integer getMaxLength(Object o) {
        return null;
    }

    public Integer getScale(Object o) {
        return null;
    }

    public Integer estimateByteSizeFromLength(Integer length) {
        if (this.isFixedWidth()) {
            return this.getByteSize();
        }
        if (this.isArrayType()) {
            return null;
        }
        return length;
    }

    public final String getSqlTypeName() {
        return this.sqlTypeName;
    }

    public final int getSqlType() {
        return this.sqlType;
    }

    public final Class getJavaClass() {
        return this.clazz;
    }

    public boolean isArrayType() {
        return false;
    }

    public final int compareTo(byte[] lhs, int lhsOffset, int lhsLength, SortOrder lhsSortOrder, byte[] rhs, int rhsOffset, int rhsLength, SortOrder rhsSortOrder, PDataType rhsType) {
        Preconditions.checkNotNull((Object)((Object)lhsSortOrder));
        Preconditions.checkNotNull((Object)((Object)rhsSortOrder));
        if (!(!this.isBytesComparableWith(rhsType) || this.isArrayType() && rhsType.isArrayType() && PArrayDataType.isRowKeyOrderOptimized(this, lhsSortOrder, lhs, lhsOffset, lhsLength) != PArrayDataType.isRowKeyOrderOptimized(rhsType, rhsSortOrder, rhs, rhsOffset, rhsLength))) {
            if (lhsLength != rhsLength && this.isFixedWidth() && rhsType.isFixedWidth() && this.getByteSize() != null && rhsType.getByteSize() != null) {
                if (lhsLength > rhsLength) {
                    int minOffset = lhsOffset + rhsLength;
                    int i = lhsOffset + lhsLength - 1;
                    while (i >= minOffset && lhsSortOrder.normalize(lhs[i]) == 0) {
                        --i;
                        --lhsLength;
                    }
                } else {
                    int minOffset = rhsOffset + lhsLength;
                    int i = rhsOffset + rhsLength - 1;
                    while (i >= minOffset && rhsSortOrder.normalize(rhs[i]) == 0) {
                        --i;
                        --rhsLength;
                    }
                }
            }
            return this.compareTo(lhs, lhsOffset, lhsLength, lhsSortOrder, rhs, rhsOffset, rhsLength, rhsSortOrder);
        }
        PDataCodec lhsCodec = this.getCodec();
        if (lhsCodec == null) {
            byte[] rhsConverted;
            Object o = this.toObject(rhs, rhsOffset, rhsLength, rhsType, rhsSortOrder);
            if (this.isArrayType() && PArrayDataType.isRowKeyOrderOptimized(this, lhsSortOrder, lhs, lhsOffset, lhsLength) == PArrayDataType.isRowKeyOrderOptimized(rhsType, rhsSortOrder, rhs, rhsOffset, rhsLength)) {
                rhsConverted = ((PArrayDataType)this).toBytes(o, PArrayDataType.arrayBaseType(this), lhsSortOrder, PArrayDataType.isRowKeyOrderOptimized(this, lhsSortOrder, lhs, lhsOffset, lhsLength));
            } else {
                rhsConverted = this.toBytes(o);
                if (rhsSortOrder == SortOrder.DESC) {
                    rhsSortOrder = SortOrder.ASC;
                }
                if (lhsSortOrder == SortOrder.DESC) {
                    lhs = SortOrder.invert(lhs, lhsOffset, new byte[lhsLength], 0, lhsLength);
                    lhsOffset = 0;
                }
            }
            return Bytes.compareTo((byte[])lhs, (int)lhsOffset, (int)lhsLength, (byte[])rhsConverted, (int)0, (int)rhsConverted.length);
        }
        PDataCodec rhsCodec = rhsType.getCodec();
        if (rhsCodec == null) {
            byte[] lhsConverted;
            Object o = rhsType.toObject(lhs, lhsOffset, lhsLength, this, lhsSortOrder);
            if (rhsType.isArrayType() && PArrayDataType.isRowKeyOrderOptimized(rhsType, rhsSortOrder, rhs, rhsOffset, rhsLength) == PArrayDataType.isRowKeyOrderOptimized(this, lhsSortOrder, lhs, lhsOffset, lhsLength)) {
                lhsConverted = ((PArrayDataType)rhsType).toBytes(o, PArrayDataType.arrayBaseType(rhsType), rhsSortOrder, PArrayDataType.isRowKeyOrderOptimized(rhsType, rhsSortOrder, rhs, rhsOffset, rhsLength));
            } else {
                lhsConverted = rhsType.toBytes(o);
                if (lhsSortOrder == SortOrder.DESC) {
                    lhsSortOrder = SortOrder.ASC;
                }
                if (rhsSortOrder == SortOrder.DESC) {
                    rhs = SortOrder.invert(rhs, rhsOffset, new byte[rhsLength], 0, rhsLength);
                }
            }
            return Bytes.compareTo((byte[])lhsConverted, (int)0, (int)lhsConverted.length, (byte[])rhs, (int)rhsOffset, (int)rhsLength);
        }
        if ((this.isCoercibleTo(PLong.INSTANCE) || this.isCoercibleTo(PDate.INSTANCE)) && (rhsType.isCoercibleTo(PLong.INSTANCE) || rhsType.isCoercibleTo(PDate.INSTANCE))) {
            return Longs.compare((long)this.getCodec().decodeLong(lhs, lhsOffset, lhsSortOrder), (long)rhsType.getCodec().decodeLong(rhs, rhsOffset, rhsSortOrder));
        }
        if (PDataType.isDoubleOrFloat(this) && PDataType.isDoubleOrFloat(rhsType)) {
            return Doubles.compare((double)this.getCodec().decodeDouble(lhs, lhsOffset, lhsSortOrder), (double)rhsType.getCodec().decodeDouble(rhs, rhsOffset, rhsSortOrder));
        }
        float fvalue = 0.0f;
        double dvalue = 0.0;
        long lvalue = 0L;
        boolean isFloat = false;
        int invert = 1;
        if (this.isCoercibleTo(PLong.INSTANCE)) {
            lvalue = this.getCodec().decodeLong(lhs, lhsOffset, lhsSortOrder);
        } else if (this.getClass() == PFloat.class) {
            isFloat = true;
            fvalue = this.getCodec().decodeFloat(lhs, lhsOffset, lhsSortOrder);
        } else if (this.isCoercibleTo(PDouble.INSTANCE)) {
            dvalue = this.getCodec().decodeDouble(lhs, lhsOffset, lhsSortOrder);
        }
        if (rhsType.isCoercibleTo(PLong.INSTANCE)) {
            lvalue = rhsType.getCodec().decodeLong(rhs, rhsOffset, rhsSortOrder);
        } else if (rhsType == PFloat.INSTANCE) {
            invert = -1;
            isFloat = true;
            fvalue = rhsType.getCodec().decodeFloat(rhs, rhsOffset, rhsSortOrder);
        } else if (rhsType.isCoercibleTo(PDouble.INSTANCE)) {
            invert = -1;
            dvalue = rhsType.getCodec().decodeDouble(rhs, rhsOffset, rhsSortOrder);
        }
        return invert * (isFloat ? PDataType.compareFloatToLong(fvalue, lvalue) : PDataType.compareDoubleToLong(dvalue, lvalue));
    }

    public static boolean isDoubleOrFloat(PDataType type) {
        return type == PFloat.INSTANCE || type == PDouble.INSTANCE || type == PUnsignedFloat.INSTANCE || type == PUnsignedDouble.INSTANCE;
    }

    private static int compareFloatToLong(float f, long l) {
        if (f > 2.1474836E9f || f < -2.1474836E9f) {
            return f < (float)l ? -1 : (f > (float)l ? 1 : 0);
        }
        long diff = (long)f - l;
        return Long.signum(diff);
    }

    private static int compareDoubleToLong(double d, long l) {
        if (d > 9.223372036854776E18) {
            return 1;
        }
        if (d < -9.223372036854776E18) {
            return -1;
        }
        long diff = (long)d - l;
        return Long.signum(diff);
    }

    protected static void checkForSufficientLength(byte[] b, int offset, int requiredLength) {
        if (b.length < offset + requiredLength) {
            throw new RuntimeException(new SQLExceptionInfo.Builder(SQLExceptionCode.ILLEGAL_DATA).setMessage("Expected length of at least " + requiredLength + " bytes, but had " + (b.length - offset)).build().buildException());
        }
    }

    protected static Void throwConstraintViolationException(PDataType source, PDataType target) {
        throw new ConstraintViolationException(new SQLExceptionInfo.Builder(SQLExceptionCode.TYPE_MISMATCH).setMessage(source + " cannot be coerced to " + target).build().buildException());
    }

    protected static RuntimeException newIllegalDataException() {
        return new IllegalDataException(new SQLExceptionInfo.Builder(SQLExceptionCode.ILLEGAL_DATA).build().buildException());
    }

    protected static RuntimeException newIllegalDataException(String msg) {
        return new IllegalDataException(new SQLExceptionInfo.Builder(SQLExceptionCode.ILLEGAL_DATA).setMessage(msg).build().buildException());
    }

    protected static RuntimeException newIllegalDataException(Exception e) {
        return new IllegalDataException(new SQLExceptionInfo.Builder(SQLExceptionCode.ILLEGAL_DATA).setRootCause(e).build().buildException());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this.getClass() == o.getClass();
    }

    public static boolean equalsAny(PDataType lhs, PDataType ... rhs) {
        for (int i = 0; i < rhs.length; ++i) {
            if (!lhs.equals(rhs[i])) continue;
            return true;
        }
        return false;
    }

    protected static int toBytes(BigDecimal v, byte[] result, int offset, int length) {
        long divBy;
        BigInteger compareAgainst;
        int digitOffset;
        BigInteger divideBy;
        int multiplyBy;
        int scale;
        int signum = v.signum();
        if (signum == 0) {
            result[offset] = -128;
            return 1;
        }
        int index = offset + length;
        int expOffset = scale % 2 * ((scale = v.scale()) < 0 ? -1 : 1);
        if (expOffset == 0) {
            multiplyBy = 1;
            divideBy = ONE_HUNDRED;
        } else {
            multiplyBy = 10;
            divideBy = BigInteger.TEN;
        }
        if (signum == 1) {
            digitOffset = 1;
            compareAgainst = MAX_LONG;
            result[offset] = (byte)(-((scale -= (length - 2) * 2) + expOffset) / 2 + 65 | 0x80);
        } else {
            digitOffset = 101;
            compareAgainst = MIN_LONG;
            result[offset] = (byte)(~(-((scale -= (length - 2 - 1) * 2) + expOffset) / 2 + 65 + 128) & 0x7F);
            if (length <= MAX_BIG_DECIMAL_BYTES) {
                result[--index] = 102;
            } else {
                length = MAX_BIG_DECIMAL_BYTES;
                index = offset + length;
            }
        }
        BigInteger bi = v.unscaledValue();
        while (bi.compareTo(compareAgainst) * signum > 0) {
            BigInteger[] dandr = bi.divideAndRemainder(divideBy);
            bi = dandr[0];
            int digit = dandr[1].intValue();
            result[--index] = (byte)(digit * multiplyBy + digitOffset);
            multiplyBy = 1;
            divideBy = ONE_HUNDRED;
        }
        long l = bi.longValue();
        do {
            divBy = 100 / multiplyBy;
            long digit = l % divBy;
            result[--index] = (byte)(digit * (long)multiplyBy + (long)digitOffset);
            multiplyBy = 1;
        } while ((l /= divBy) != 0L);
        return length;
    }

    protected static BigDecimal toBigDecimal(byte[] bytes, int offset, int length) {
        BigInteger bi;
        int digitOffset;
        int index;
        int scale;
        if (length == 1 && bytes[offset] == -128) {
            return BigDecimal.ZERO;
        }
        int signum = (bytes[offset] & 0x80) == 0 ? -1 : 1;
        long multiplier = 100L;
        int begIndex = offset + 1;
        if (signum == 1) {
            scale = ((bytes[offset] & 0x7F) - 65) * -2;
            index = offset + length;
            digitOffset = 1;
        } else {
            scale = (byte)((~bytes[offset] - 65 - 128) * -2);
            index = offset + length - (bytes[offset + length - 1] == 102 ? 1 : 0);
            digitOffset = -101;
        }
        length = index - offset;
        long l = signum * bytes[--index] - digitOffset;
        if (l % 10L == 0L) {
            --scale;
            l /= 10L;
            multiplier = 10L;
        }
        while (index > begIndex) {
            if (l >= 9223372036854775L || multiplier >= 92233720368547758L) {
                multiplier = LongMath.divide((long)multiplier, (long)100L, (RoundingMode)RoundingMode.UNNECESSARY);
                break;
            }
            int digit100 = signum * bytes[--index] - digitOffset;
            l += (long)digit100 * multiplier;
            multiplier = LongMath.checkedMultiply((long)multiplier, (long)100L);
        }
        if (index > begIndex) {
            bi = BigInteger.valueOf(l);
            BigInteger biMultiplier = BigInteger.valueOf(multiplier).multiply(ONE_HUNDRED);
            do {
                int digit100 = signum * bytes[--index] - digitOffset;
                bi = bi.add(biMultiplier.multiply(BigInteger.valueOf(digit100)));
                biMultiplier = biMultiplier.multiply(ONE_HUNDRED);
            } while (index > begIndex);
            if (signum == -1) {
                bi = bi.negate();
            }
        } else {
            bi = BigInteger.valueOf(l * (long)signum);
        }
        BigDecimal v = new BigDecimal(bi, scale += (length - 2) * 2);
        return v;
    }

    protected static int[] getDecimalPrecisionAndScale(byte[] bytes, int offset, int length, SortOrder sortOrder) {
        int digitOffset;
        int index;
        int scale;
        int signum;
        if (length == 1 && sortOrder.normalize(bytes[offset]) == -128) {
            return new int[]{0, 0};
        }
        int n = signum = (sortOrder.normalize(bytes[offset]) & 0x80) == 0 ? -1 : 1;
        if (signum == 1) {
            scale = ((sortOrder.normalize(bytes[offset]) & 0x7F) - 65) * -2;
            index = offset + length;
            digitOffset = 1;
        } else {
            scale = (byte)((~sortOrder.normalize(bytes[offset]) - 65 - 128) * -2);
            index = offset + length - (sortOrder.normalize(bytes[offset + length - 1]) == 102 ? 1 : 0);
            digitOffset = -101;
        }
        length = index - offset;
        int precision = 2 * (length - 1);
        int d = signum * sortOrder.normalize(bytes[--index]) - digitOffset;
        if (d % 10 == 0) {
            d /= 10;
            --scale;
            --precision;
        }
        if ((d = signum * sortOrder.normalize(bytes[offset + 1]) - digitOffset) < 10) {
            --precision;
        }
        if ((scale += (length - 2) * 2) < 0) {
            precision -= scale;
            scale = 0;
        }
        return new int[]{precision, scale};
    }

    public boolean isCoercibleTo(PDataType targetType) {
        return this.equals(targetType) || targetType.equals(PVarbinary.INSTANCE);
    }

    public boolean isComparableTo(PDataType targetType) {
        return targetType.isCoercibleTo(this) || this.isCoercibleTo(targetType);
    }

    public boolean isCoercibleTo(PDataType targetType, Object value) {
        return this.isCoercibleTo(targetType);
    }

    public boolean isSizeCompatible(ImmutableBytesWritable ptr, Object value, PDataType srcType, SortOrder sortOrder, Integer maxLength, Integer scale, Integer desiredMaxLength, Integer desiredScale) {
        return true;
    }

    public int compareTo(byte[] b1, byte[] b2) {
        return this.compareTo(b1, 0, b1.length, SortOrder.getDefault(), b2, 0, b2.length, SortOrder.getDefault());
    }

    public final int compareTo(ImmutableBytesWritable ptr1, ImmutableBytesWritable ptr2) {
        return this.compareTo(ptr1.get(), ptr1.getOffset(), ptr1.getLength(), SortOrder.getDefault(), ptr2.get(), ptr2.getOffset(), ptr2.getLength(), SortOrder.getDefault());
    }

    public final int compareTo(byte[] ba1, int offset1, int length1, SortOrder so1, byte[] ba2, int offset2, int length2, SortOrder so2) {
        Preconditions.checkNotNull((Object)((Object)so1));
        Preconditions.checkNotNull((Object)((Object)so2));
        if (so1 != so2) {
            int length = Math.min(length1, length2);
            for (int i = 0; i < length; ++i) {
                byte b1 = ba1[offset1 + i];
                byte b2 = ba2[offset2 + i];
                if (so1 == SortOrder.DESC) {
                    b1 = SortOrder.invert(b1);
                } else {
                    b2 = SortOrder.invert(b2);
                }
                int c = b1 - b2;
                if (c == 0) continue;
                return c;
            }
            return length1 - length2;
        }
        return (so1 == SortOrder.DESC ? -1 : 1) * ScanUtil.getComparator(length1 == length2, so1).compare(ba1, offset1, length1, ba2, offset2, length2);
    }

    public final int compareTo(ImmutableBytesWritable ptr1, SortOrder ptr1SortOrder, ImmutableBytesWritable ptr2, SortOrder ptr2SortOrder, PDataType type2) {
        return this.compareTo(ptr1.get(), ptr1.getOffset(), ptr1.getLength(), ptr1SortOrder, ptr2.get(), ptr2.getOffset(), ptr2.getLength(), ptr2SortOrder, type2);
    }

    public int compareTo(Object lhs, Object rhs) {
        return this.compareTo(lhs, rhs, this);
    }

    public final boolean isNull(byte[] value) {
        return value == null || value.length == 0;
    }

    public byte[] toBytes(Object object, SortOrder sortOrder) {
        Preconditions.checkNotNull((Object)((Object)sortOrder));
        byte[] bytes = this.toBytes(object);
        if (sortOrder == SortOrder.DESC) {
            SortOrder.invert(bytes, 0, bytes, 0, bytes.length);
        }
        return bytes;
    }

    public void coerceBytes(ImmutableBytesWritable ptr, Object o, PDataType actualType, Integer actualMaxLength, Integer actualScale, SortOrder actualModifier, Integer desiredMaxLength, Integer desiredScale, SortOrder expectedModifier, boolean expectedRowKeyOrderOptimizable) {
        this.coerceBytes(ptr, o, actualType, actualMaxLength, actualScale, actualModifier, desiredMaxLength, desiredScale, expectedModifier);
    }

    public void coerceBytes(ImmutableBytesWritable ptr, Object o, PDataType actualType, Integer actualMaxLength, Integer actualScale, SortOrder actualModifier, Integer desiredMaxLength, Integer desiredScale, SortOrder expectedModifier) {
        Preconditions.checkNotNull((Object)((Object)actualModifier));
        Preconditions.checkNotNull((Object)((Object)expectedModifier));
        if (ptr.getLength() == 0) {
            return;
        }
        if (this.isBytesComparableWith(actualType)) {
            if (actualModifier == expectedModifier) {
                return;
            }
            byte[] b = ptr.copyBytes();
            SortOrder.invert(b, 0, b, 0, b.length);
            ptr.set(b);
            return;
        }
        if (o == null) {
            o = actualType.toObject(ptr, actualType, actualModifier);
        }
        o = this.toObject(o, actualType);
        byte[] b = this.toBytes(o, expectedModifier);
        ptr.set(b);
    }

    public final void coerceBytes(ImmutableBytesWritable ptr, PDataType actualType, SortOrder actualModifier, SortOrder expectedModifier) {
        this.coerceBytes(ptr, null, actualType, null, null, actualModifier, null, null, expectedModifier);
    }

    public final void coerceBytes(ImmutableBytesWritable ptr, PDataType actualType, SortOrder actualModifier, SortOrder expectedModifier, Integer desiredMaxLength) {
        this.coerceBytes(ptr, null, actualType, null, null, actualModifier, desiredMaxLength, null, expectedModifier);
    }

    protected static boolean isNonNegativeDate(Date date) {
        return date == null || date.getTime() >= 0L;
    }

    protected static void throwIfNonNegativeDate(Date date) {
        if (!PDataType.isNonNegativeDate(date)) {
            throw PDataType.newIllegalDataException("Value may not be negative(" + date + ")");
        }
    }

    protected static boolean isNonNegativeNumber(Number v) {
        return v == null || v.longValue() >= 0L;
    }

    protected static void throwIfNonNegativeNumber(Number v) {
        if (!PDataType.isNonNegativeNumber(v)) {
            throw PDataType.newIllegalDataException("Value may not be negative(" + v + ")");
        }
    }

    public boolean isNullable() {
        return false;
    }

    public abstract Integer getByteSize();

    public int encodedLength(T val) {
        return this.getByteSize();
    }

    public int skip(PositionedByteRange pbr) {
        int len = this.getByteSize();
        pbr.setPosition(pbr.getPosition() + len);
        return len;
    }

    public boolean isOrderPreserving() {
        return true;
    }

    public boolean isSkippable() {
        return true;
    }

    public Order getOrder() {
        return Order.ASCENDING;
    }

    public abstract boolean isFixedWidth();

    public abstract int compareTo(Object var1, Object var2, PDataType var3);

    @Override
    public int compareTo(PDataType<?> other) {
        return Integer.compare(this.ordinal(), other.ordinal());
    }

    public abstract int toBytes(Object var1, byte[] var2, int var3);

    public int encode(PositionedByteRange pbr, T val) {
        int pos = pbr.getPosition();
        pbr.put(this.toBytes(val));
        return pbr.getPosition() - pos;
    }

    public String toString() {
        return this.sqlTypeName;
    }

    public abstract byte[] toBytes(Object var1);

    public abstract Object toObject(String var1);

    public abstract Object toObject(Object var1, PDataType var2);

    public abstract Object toObject(byte[] var1, int var2, int var3, PDataType var4, SortOrder var5, Integer var6, Integer var7);

    public T decode(PositionedByteRange pbr) {
        byte[] b = new byte[this.getByteSize().intValue()];
        pbr.get(b);
        return (T)this.toObject(b, 0, b.length, this, SortOrder.ASC, this.getMaxLength(null), this.getScale(null));
    }

    public abstract Object getSampleValue(Integer var1, Integer var2);

    public final Object getSampleValue() {
        return this.getSampleValue(null);
    }

    public final Object getSampleValue(Integer maxLength) {
        return this.getSampleValue(maxLength, null);
    }

    public final Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder) {
        return this.toObject(bytes, offset, length, actualType, sortOrder, null, null);
    }

    public final Object toObject(byte[] bytes, int offset, int length, PDataType actualType) {
        return this.toObject(bytes, offset, length, actualType, SortOrder.getDefault());
    }

    public final Object toObject(ImmutableBytesWritable ptr, PDataType actualType) {
        return this.toObject(ptr, actualType, SortOrder.getDefault());
    }

    public final Object toObject(ImmutableBytesWritable ptr, PDataType actualType, SortOrder sortOrder) {
        return this.toObject(ptr.get(), ptr.getOffset(), ptr.getLength(), actualType, sortOrder);
    }

    public final Object toObject(ImmutableBytesWritable ptr, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        return this.toObject(ptr.get(), ptr.getOffset(), ptr.getLength(), actualType, sortOrder, maxLength, scale);
    }

    public final Object toObject(ImmutableBytesWritable ptr, SortOrder sortOrder, Integer maxLength, Integer scale) {
        return this.toObject(ptr.get(), ptr.getOffset(), ptr.getLength(), this, sortOrder, maxLength, scale);
    }

    public final Object toObject(ImmutableBytesWritable ptr) {
        return this.toObject(ptr.get(), ptr.getOffset(), ptr.getLength());
    }

    public final Object toObject(ImmutableBytesWritable ptr, SortOrder sortOrder) {
        return this.toObject(ptr.get(), ptr.getOffset(), ptr.getLength(), this, sortOrder);
    }

    public final Object toObject(byte[] bytes, int offset, int length) {
        return this.toObject(bytes, offset, length, this);
    }

    public final Object toObject(byte[] bytes) {
        return this.toObject(bytes, SortOrder.getDefault());
    }

    public final Object toObject(byte[] bytes, SortOrder sortOrder) {
        return this.toObject(bytes, 0, bytes.length, this, sortOrder);
    }

    public final Object toObject(byte[] bytes, SortOrder sortOrder, PDataType actualType) {
        return this.toObject(bytes, 0, bytes.length, actualType, sortOrder);
    }

    public static PDataType fromSqlTypeName(String sqlTypeName) {
        for (PDataType t : PDataTypeFactory.getInstance().getTypes()) {
            if (!t.getSqlTypeName().equalsIgnoreCase(sqlTypeName)) continue;
            return t;
        }
        throw PDataType.newIllegalDataException("Unsupported sql type: " + sqlTypeName);
    }

    public static int sqlArrayType(String sqlTypeName) {
        PDataType fromSqlTypeName = PDataType.fromSqlTypeName(sqlTypeName);
        return fromSqlTypeName.getSqlType() + 3000;
    }

    public static PDataType fromTypeId(int typeId) {
        for (PDataType t : PDataTypeFactory.getInstance().getTypes()) {
            if (t.getSqlType() != typeId) continue;
            return t;
        }
        throw PDataType.newIllegalDataException("Unsupported sql type: " + typeId);
    }

    public String getJavaClassName() {
        return this.getJavaClass().getName();
    }

    public byte[] getJavaClassNameBytes() {
        return this.clazzNameBytes;
    }

    public byte[] getSqlTypeNameBytes() {
        return this.sqlTypeNameBytes;
    }

    public int getResultSetSqlType() {
        return this.sqlType;
    }

    public KeyRange getKeyRange(byte[] point) {
        return this.getKeyRange(point, true, point, true);
    }

    public final String toStringLiteral(ImmutableBytesWritable ptr, Format formatter) {
        return this.toStringLiteral(ptr.get(), ptr.getOffset(), ptr.getLength(), formatter);
    }

    public final String toStringLiteral(byte[] b, Format formatter) {
        return this.toStringLiteral(b, 0, b.length, formatter);
    }

    public String toStringLiteral(byte[] b, int offset, int length, Format formatter) {
        Object o = this.toObject(b, offset, length);
        return this.toStringLiteral(o, formatter);
    }

    public String toStringLiteral(Object o, Format formatter) {
        if (o == null) {
            return String.valueOf(o);
        }
        if (formatter != null) {
            return formatter.format(o);
        }
        return o.toString();
    }

    public String toStringLiteral(Object o) {
        return this.toStringLiteral(o, null);
    }

    public PhoenixArrayFactory getArrayFactory() {
        if (this.getCodec() != null) {
            return this.getCodec().getPhoenixArrayFactory();
        }
        return DEFAULT_ARRAY_FACTORY;
    }

    public static PhoenixArray instantiatePhoenixArray(PDataType actualType, Object[] elements) {
        return actualType.getArrayFactory().newArray(actualType, elements);
    }

    public KeyRange getKeyRange(byte[] lowerRange, boolean lowerInclusive, byte[] upperRange, boolean upperInclusive) {
        if (lowerRange != KeyRange.UNBOUND && !lowerInclusive && this.isFixedWidth()) {
            if ((lowerRange = ByteUtil.nextKey(lowerRange)) == null) {
                lowerRange = KeyRange.UNBOUND;
            }
            lowerInclusive = true;
        }
        return KeyRange.getKeyRange(lowerRange, lowerInclusive, upperRange, upperInclusive);
    }

    public static PDataType fromLiteral(Object value) {
        if (value == null) {
            return null;
        }
        for (PDataType type : PDataType.values()) {
            if (type.isArrayType()) {
                Array arr;
                if (value instanceof PhoenixArray) {
                    arr = (PhoenixArray)value;
                    if (type.getSqlType() != ((PhoenixArray)arr).baseType.sqlType + 3000 || !type.getJavaClass().isInstance(value)) continue;
                    return type;
                }
                arr = (Array)value;
                try {
                    if (arr.getBaseType() == type.getSqlType() - 3000) {
                        return type;
                    }
                }
                catch (SQLException sQLException) {}
                continue;
            }
            if (!type.getJavaClass().isInstance(value)) continue;
            return type;
        }
        throw new UnsupportedOperationException("Unsupported literal value [" + value + "] of type " + value.getClass().getName());
    }

    public int getNanos(ImmutableBytesWritable ptr, SortOrder sortOrder) {
        throw new UnsupportedOperationException("Operation not supported for type " + this);
    }

    public long getMillis(ImmutableBytesWritable ptr, SortOrder sortOrder) {
        throw new UnsupportedOperationException("Operation not supported for type " + this);
    }

    public Object pad(Object object, Integer maxLength) {
        return object;
    }

    public void pad(ImmutableBytesWritable ptr, Integer maxLength, SortOrder sortOrder) {
    }

    public byte[] pad(byte[] b, Integer maxLength, SortOrder sortOrder) {
        return b;
    }

    public static PDataType arrayBaseType(PDataType arrayType) {
        Preconditions.checkArgument((boolean)arrayType.isArrayType(), (Object)"Not a phoenix array type");
        return PDataType.fromTypeId(arrayType.getSqlType() - 3000);
    }

    protected static interface PhoenixArrayFactory {
        public PhoenixArray newArray(PDataType var1, Object[] var2);
    }

    public static abstract class BaseCodec
    implements PDataCodec {
        @Override
        public int decodeInt(ImmutableBytesWritable ptr, SortOrder sortOrder) {
            return this.decodeInt(ptr.get(), ptr.getOffset(), sortOrder);
        }

        @Override
        public long decodeLong(ImmutableBytesWritable ptr, SortOrder sortOrder) {
            return this.decodeLong(ptr.get(), ptr.getOffset(), sortOrder);
        }

        @Override
        public byte decodeByte(ImmutableBytesWritable ptr, SortOrder sortOrder) {
            return this.decodeByte(ptr.get(), ptr.getOffset(), sortOrder);
        }

        @Override
        public short decodeShort(ImmutableBytesWritable ptr, SortOrder sortOrder) {
            return this.decodeShort(ptr.get(), ptr.getOffset(), sortOrder);
        }

        @Override
        public float decodeFloat(ImmutableBytesWritable ptr, SortOrder sortOrder) {
            return this.decodeFloat(ptr.get(), ptr.getOffset(), sortOrder);
        }

        @Override
        public float decodeFloat(byte[] b, int o, SortOrder sortOrder) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double decodeDouble(ImmutableBytesWritable ptr, SortOrder sortOrder) {
            return this.decodeDouble(ptr.get(), ptr.getOffset(), sortOrder);
        }

        @Override
        public double decodeDouble(byte[] b, int o, SortOrder sortOrder) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int encodeInt(int v, ImmutableBytesWritable ptr) {
            return this.encodeInt(v, ptr.get(), ptr.getOffset());
        }

        @Override
        public int encodeLong(long v, ImmutableBytesWritable ptr) {
            return this.encodeLong(v, ptr.get(), ptr.getOffset());
        }

        @Override
        public int encodeByte(byte v, ImmutableBytesWritable ptr) {
            return this.encodeByte(v, ptr.get(), ptr.getOffset());
        }

        @Override
        public int encodeShort(short v, ImmutableBytesWritable ptr) {
            return this.encodeShort(v, ptr.get(), ptr.getOffset());
        }

        @Override
        public int encodeFloat(float v, ImmutableBytesWritable ptr) {
            return this.encodeFloat(v, ptr.get(), ptr.getOffset());
        }

        @Override
        public int encodeDouble(double v, ImmutableBytesWritable ptr) {
            return this.encodeDouble(v, ptr.get(), ptr.getOffset());
        }

        @Override
        public int encodeInt(int v, byte[] b, int o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int encodeLong(long v, byte[] b, int o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int encodeByte(byte v, byte[] b, int o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int encodeShort(short v, byte[] b, int o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int encodeFloat(float v, byte[] b, int o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int encodeDouble(double v, byte[] b, int o) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface PDataCodec {
        public long decodeLong(ImmutableBytesWritable var1, SortOrder var2);

        public long decodeLong(byte[] var1, int var2, SortOrder var3);

        public int decodeInt(ImmutableBytesWritable var1, SortOrder var2);

        public int decodeInt(byte[] var1, int var2, SortOrder var3);

        public byte decodeByte(ImmutableBytesWritable var1, SortOrder var2);

        public byte decodeByte(byte[] var1, int var2, SortOrder var3);

        public short decodeShort(ImmutableBytesWritable var1, SortOrder var2);

        public short decodeShort(byte[] var1, int var2, SortOrder var3);

        public float decodeFloat(ImmutableBytesWritable var1, SortOrder var2);

        public float decodeFloat(byte[] var1, int var2, SortOrder var3);

        public double decodeDouble(ImmutableBytesWritable var1, SortOrder var2);

        public double decodeDouble(byte[] var1, int var2, SortOrder var3);

        public int encodeLong(long var1, ImmutableBytesWritable var3);

        public int encodeLong(long var1, byte[] var3, int var4);

        public int encodeInt(int var1, ImmutableBytesWritable var2);

        public int encodeInt(int var1, byte[] var2, int var3);

        public int encodeByte(byte var1, ImmutableBytesWritable var2);

        public int encodeByte(byte var1, byte[] var2, int var3);

        public int encodeShort(short var1, ImmutableBytesWritable var2);

        public int encodeShort(short var1, byte[] var2, int var3);

        public int encodeFloat(float var1, ImmutableBytesWritable var2);

        public int encodeFloat(float var1, byte[] var2, int var3);

        public int encodeDouble(double var1, ImmutableBytesWritable var3);

        public int encodeDouble(double var1, byte[] var3, int var4);

        public PhoenixArrayFactory getPhoenixArrayFactory();
    }
}

