/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;

public class RepairUtil {
    public static boolean isLocalIndexStoreFilesConsistent(RegionCoprocessorEnvironment environment, Store store) {
        byte[] startKey = environment.getRegion().getRegionInfo().getStartKey();
        byte[] endKey = environment.getRegion().getRegionInfo().getEndKey();
        byte[] indexKeyEmbedded = startKey.length == 0 ? new byte[endKey.length] : startKey;
        for (StoreFile file : store.getStorefiles()) {
            byte[] fileFirstRowKey;
            if (!file.getFirstKey().isPresent() || file.getFirstKey().get() == null || (fileFirstRowKey = CellUtil.cloneRow((Cell)((Cell)file.getFirstKey().get()))) == null || Bytes.compareTo((byte[])fileFirstRowKey, (int)0, (int)indexKeyEmbedded.length, (byte[])indexKeyEmbedded, (int)0, (int)indexKeyEmbedded.length) == 0) continue;
            return false;
        }
        return true;
    }
}

