/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mongo;

import java.util.LinkedList;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.impl.BatchCreator;
import org.apache.drill.exec.physical.impl.ScanBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.store.mongo.BaseMongoSubScanSpec;
import org.apache.drill.exec.store.mongo.MongoRecordReader;
import org.apache.drill.exec.store.mongo.MongoSubScan;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoScanBatchCreator
implements BatchCreator<MongoSubScan> {
    static final Logger logger = LoggerFactory.getLogger(MongoScanBatchCreator.class);

    public ScanBatch getBatch(ExecutorFragmentContext context, MongoSubScan subScan, List<RecordBatch> children) throws ExecutionSetupException {
        Preconditions.checkArgument((boolean)children.isEmpty());
        LinkedList<MongoRecordReader> readers = new LinkedList<MongoRecordReader>();
        for (BaseMongoSubScanSpec scanSpec : subScan.getChunkScanSpecList()) {
            try {
                List columns = subScan.getColumns();
                if (columns == null) {
                    columns = GroupScan.ALL_COLUMNS;
                }
                readers.add(new MongoRecordReader(scanSpec, columns, (FragmentContext)context, subScan.getMongoStoragePlugin()));
            }
            catch (Exception e) {
                logger.error("MongoRecordReader creation failed for subScan: {}.", (Object)subScan);
                logger.error(e.getMessage(), (Throwable)e);
                throw new ExecutionSetupException((Throwable)e);
            }
        }
        logger.info("Number of record readers initialized : {}", (Object)readers.size());
        return new ScanBatch((PhysicalOperator)subScan, (FragmentContext)context, readers);
    }
}

