/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.shaded.esri.core.geometry;

import com.datastax.oss.driver.shaded.esri.core.geometry.AttributeStreamBase;
import com.datastax.oss.driver.shaded.esri.core.geometry.AttributeStreamOfDbl;
import com.datastax.oss.driver.shaded.esri.core.geometry.Geometry;
import com.datastax.oss.driver.shaded.esri.core.geometry.GeometryException;
import com.datastax.oss.driver.shaded.esri.core.geometry.MultiPoint;
import com.datastax.oss.driver.shaded.esri.core.geometry.MultiVertexGeometryImpl;
import com.datastax.oss.driver.shaded.esri.core.geometry.Point;
import com.datastax.oss.driver.shaded.esri.core.geometry.Point2D;
import com.datastax.oss.driver.shaded.esri.core.geometry.Point3D;
import com.datastax.oss.driver.shaded.esri.core.geometry.Transformation2D;
import com.datastax.oss.driver.shaded.esri.core.geometry.Transformation3D;
import com.datastax.oss.driver.shaded.esri.core.geometry.VertexDescription;
import com.datastax.oss.driver.shaded.esri.core.geometry.VertexDescriptionDesignerImpl;

final class MultiPointImpl
extends MultiVertexGeometryImpl {
    public MultiPointImpl() {
        this.m_description = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
        this.m_pointCount = 0;
    }

    public MultiPointImpl(VertexDescription description) {
        if (description == null) {
            throw new IllegalArgumentException();
        }
        this.m_description = description;
        this.m_pointCount = 0;
    }

    @Override
    public Geometry createInstance() {
        return new MultiPoint(this.m_description);
    }

    public void add(Point point) {
        this.resize(this.m_pointCount + 1);
        this.setPoint(this.m_pointCount - 1, point);
    }

    public void add(double x, double y) {
        this.resize(this.m_pointCount + 1);
        Point2D pt = new Point2D();
        pt.setCoords(x, y);
        this.setXY(this.m_pointCount - 1, pt);
    }

    public void add(double x, double y, double z) {
        this.resize(this.m_pointCount + 1);
        Point3D pt = new Point3D();
        pt.setCoords(x, y, z);
        this.setXYZ(this.m_pointCount - 1, pt);
    }

    public void add(MultiVertexGeometryImpl src, int beginIndex, int endIndex) {
        int endIndexC;
        int n = endIndexC = endIndex < 0 ? src.getPointCount() : endIndex;
        if (beginIndex < 0 || beginIndex > src.getPointCount() || endIndexC < beginIndex) {
            throw new IllegalArgumentException();
        }
        if (beginIndex == endIndexC) {
            return;
        }
        this.mergeVertexDescription(src.getDescription());
        int count = endIndexC - beginIndex;
        int oldPointCount = this.m_pointCount;
        this.resize(this.m_pointCount + count);
        this._verifyAllStreams();
        int nattrib = src.getDescription().getAttributeCount();
        for (int iattrib = 0; iattrib < nattrib; ++iattrib) {
            int semantics = src.getDescription()._getSemanticsImpl(iattrib);
            int ncomps = VertexDescription.getComponentCount(semantics);
            AttributeStreamBase stream = this.getAttributeStreamRef(semantics);
            AttributeStreamBase srcStream = src.getAttributeStreamRef(semantics);
            stream.insertRange(oldPointCount * ncomps, srcStream, beginIndex * ncomps, count * ncomps, true, 1, oldPointCount * ncomps);
        }
    }

    public void addPoints(Point2D[] points) {
        int count = points.length;
        int oldPointCount = this.m_pointCount;
        this.resize(this.m_pointCount + count);
        for (int i = 0; i < count; ++i) {
            this.setXY(oldPointCount + i, points[i]);
        }
    }

    public void insertPoint(int beforePointIndex, Point pt) {
        if (beforePointIndex > this.getPointCount()) {
            throw new GeometryException("index out of bounds");
        }
        if (beforePointIndex < 0) {
            beforePointIndex = this.getPointCount();
        }
        this.mergeVertexDescription(pt.getDescription());
        int oldPointCount = this.m_pointCount;
        this._resizeImpl(this.m_pointCount + 1);
        this._verifyAllStreams();
        int nattr = this.m_description.getAttributeCount();
        for (int iattr = 0; iattr < nattr; ++iattr) {
            int semantics = this.m_description._getSemanticsImpl(iattr);
            int comp = VertexDescription.getComponentCount(semantics);
            AttributeStreamBase stream = AttributeStreamBase.createAttributeStreamWithSemantics(semantics, 1);
            if (pt.hasAttribute(semantics)) {
                this.m_vertexAttributes[iattr].insertAttributes(comp * beforePointIndex, pt, semantics, comp * oldPointCount);
                continue;
            }
            double v = VertexDescription.getDefaultValue(semantics);
            this.m_vertexAttributes[iattr].insertRange(comp * beforePointIndex, v, comp, comp * oldPointCount);
        }
        this.notifyModified(1993);
    }

    void removePoint(int pointIndex) {
        if (pointIndex < 0 || pointIndex >= this.getPointCount()) {
            throw new GeometryException("index out of bounds");
        }
        this._verifyAllStreams();
        int nattr = this.m_description.getAttributeCount();
        for (int iattr = 0; iattr < nattr; ++iattr) {
            if (this.m_vertexAttributes[iattr] == null) continue;
            int semantics = this.m_description._getSemanticsImpl(iattr);
            int comp = VertexDescription.getComponentCount(semantics);
            this.m_vertexAttributes[iattr].eraseRange(comp * pointIndex, comp, comp * this.m_pointCount);
        }
        --this.m_pointCount;
        --this.m_reservedPointCount;
        this.notifyModified(1993);
    }

    public void resize(int pointCount) {
        this._resizeImpl(pointCount);
    }

    @Override
    void _copyToImpl(MultiVertexGeometryImpl mvg) {
    }

    @Override
    public void setEmpty() {
        super._setEmptyImpl();
    }

    @Override
    public void applyTransformation(Transformation2D transform) {
        if (this.isEmpty()) {
            return;
        }
        this._verifyAllStreams();
        AttributeStreamOfDbl points = (AttributeStreamOfDbl)this.m_vertexAttributes[0];
        Point2D pt2 = new Point2D();
        for (int ipoint = 0; ipoint < this.m_pointCount; ++ipoint) {
            pt2.x = points.read(ipoint * 2);
            pt2.y = points.read(ipoint * 2 + 1);
            transform.transform(pt2, pt2);
            points.write(ipoint * 2, pt2.x);
            points.write(ipoint * 2 + 1, pt2.y);
        }
        this.notifyModified(1993);
    }

    @Override
    void applyTransformation(Transformation3D transform) {
        if (this.isEmpty()) {
            return;
        }
        this._verifyAllStreams();
        this.addAttribute(1);
        this._verifyAllStreams();
        AttributeStreamOfDbl points = (AttributeStreamOfDbl)this.m_vertexAttributes[0];
        AttributeStreamOfDbl zs = (AttributeStreamOfDbl)this.m_vertexAttributes[1];
        Point3D pt3 = new Point3D();
        for (int ipoint = 0; ipoint < this.m_pointCount; ++ipoint) {
            pt3.x = points.read(ipoint * 2);
            pt3.y = points.read(ipoint * 2 + 1);
            pt3.z = zs.read(ipoint);
            Point3D res = transform.transform(pt3);
            points.write(ipoint * 2, res.x);
            points.write(ipoint * 2 + 1, res.y);
            zs.write(ipoint, res.z);
        }
        this.notifyModified(1993);
    }

    @Override
    public int getDimension() {
        return 0;
    }

    @Override
    public Geometry.Type getType() {
        return Geometry.Type.MultiPoint;
    }

    @Override
    public double calculateArea2D() {
        return 0.0;
    }

    @Override
    public double calculateLength2D() {
        return 0.0;
    }

    @Override
    public Object _getImpl() {
        return this;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MultiPointImpl)) {
            return false;
        }
        return super.equals(other);
    }

    public void addPoints(Point[] points) {
        int count = points.length;
        this.resize(this.m_pointCount + count);
        for (int i = 0; i < count; ++i) {
            this.setPoint(i, points[i]);
        }
    }

    @Override
    public int queryCoordinates(Point2D[] dst, int dstSize, int beginIndex, int endIndex) {
        int endIndexC = endIndex < 0 ? this.m_pointCount : endIndex;
        endIndexC = Math.min(endIndexC, beginIndex + dstSize);
        if (beginIndex < 0 || beginIndex >= this.m_pointCount || endIndexC < beginIndex || dst.length != dstSize) {
            throw new IllegalArgumentException();
        }
        AttributeStreamOfDbl xy = (AttributeStreamOfDbl)this.getAttributeStreamRef(0);
        int pointCountToRead = endIndexC - beginIndex;
        double[] dstArray = new double[pointCountToRead * 2];
        xy.readRange(2 * beginIndex, pointCountToRead * 2, dstArray, 0, true);
        for (int i = 0; i < pointCountToRead; ++i) {
            dst[i] = new Point2D(dstArray[i * 2], dstArray[i * 2 + 1]);
        }
        return endIndexC;
    }

    @Override
    protected void _notifyModifiedAllImpl() {
    }

    @Override
    protected void _verifyStreamsImpl() {
    }

    @Override
    public boolean _buildRasterizedGeometryAccelerator(double toleranceXY, Geometry.GeometryAccelerationDegree accelDegree) {
        return false;
    }

    @Override
    public boolean _buildQuadTreeAccelerator(Geometry.GeometryAccelerationDegree accelDegree) {
        return false;
    }

    @Override
    public Geometry getBoundary() {
        return null;
    }
}

