/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.storage;

import io.jhdf.Superblock;
import io.jhdf.exceptions.InMemoryHdfException;
import io.jhdf.storage.HdfBackingStorage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class HdfInMemoryByteBuffer
implements HdfBackingStorage {
    private final ByteBuffer byteBuffer;
    private final Superblock superblock;

    public HdfInMemoryByteBuffer(ByteBuffer byteBuffer, Superblock superblock) {
        this.byteBuffer = byteBuffer.asReadOnlyBuffer();
        this.superblock = superblock;
    }

    @Override
    public ByteBuffer readBufferFromAddress(long address, int length) {
        return this.map(address, length);
    }

    @Override
    public ByteBuffer map(long address, long length) {
        return this.mapNoOffset(address + this.superblock.getBaseAddressByte(), length);
    }

    @Override
    public synchronized ByteBuffer mapNoOffset(long address, long length) {
        this.byteBuffer.limit(Math.toIntExact(address + length));
        this.byteBuffer.position(Math.toIntExact(address));
        return this.byteBuffer.slice().order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public long getUserBlockSize() {
        return this.superblock.getBaseAddressByte();
    }

    @Override
    public Superblock getSuperblock() {
        return this.superblock;
    }

    @Override
    public FileChannel getFileChannel() {
        throw new InMemoryHdfException();
    }

    @Override
    public int getSizeOfOffsets() {
        return this.superblock.getSizeOfOffsets();
    }

    @Override
    public int getSizeOfLengths() {
        return this.superblock.getSizeOfLengths();
    }

    @Override
    public void close() {
    }

    @Override
    public long size() {
        return this.byteBuffer.capacity();
    }

    @Override
    public boolean inMemory() {
        return true;
    }
}

