/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIResponse;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class BoxAPIResponseException
extends BoxAPIException {
    static final long serialVersionUID = -7515717760101647173L;
    private String message;

    public BoxAPIResponseException(String message, BoxAPIResponse responseObj) {
        super(message, responseObj.getResponseCode(), responseObj.bodyToString());
        String requestId = "";
        String apiMessage = "";
        JsonObject responseJSON = null;
        TreeMap<String, List<String>> responseHeaders = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        for (String headerKey : responseObj.getHeaders().keySet()) {
            ArrayList<String> headerValues = new ArrayList<String>();
            headerValues.add(responseObj.getHeaderField(headerKey));
            responseHeaders.put(headerKey, headerValues);
        }
        this.setHeaders(responseHeaders);
        if (this.getHeaders().containsKey("BOX-REQUEST-ID")) {
            requestId = requestId + "." + this.getHeaders().get("BOX-REQUEST-ID").get(0);
        }
        try {
            responseJSON = Json.parse((String)responseObj.bodyToString()).asObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (responseJSON != null) {
            if (responseJSON.get("request_id") != null) {
                requestId = responseJSON.get("request_id").asString() + requestId;
            }
            if (responseJSON.get("code") != null) {
                apiMessage = apiMessage + " " + responseJSON.get("code").asString();
            } else if (responseJSON.get("error") != null) {
                apiMessage = apiMessage + " " + responseJSON.get("error").asString();
            }
            if (responseJSON.get("message") != null) {
                apiMessage = apiMessage + " - " + responseJSON.get("message").asString();
            } else if (responseJSON.get("error_description") != null) {
                apiMessage = apiMessage + " - " + responseJSON.get("error_description").asString();
            }
        }
        if (!requestId.isEmpty()) {
            this.setMessage(message + " [" + responseObj.getResponseCode() + " | " + requestId + "]" + apiMessage);
        } else {
            this.setMessage(message + " [" + responseObj.getResponseCode() + "]" + apiMessage);
        }
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    protected void setMessage(String message) {
        this.message = message;
    }
}

