/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.mongo.components.tables;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import org.apache.drill.metastore.components.tables.TableMetadataUnit;
import org.apache.drill.metastore.components.tables.Tables;
import org.apache.drill.metastore.components.tables.TablesMetadataTypeValidator;
import org.apache.drill.metastore.mongo.MongoMetastoreContext;
import org.apache.drill.metastore.mongo.components.tables.TablesTransformer;
import org.apache.drill.metastore.mongo.operate.MongoMetadata;
import org.apache.drill.metastore.mongo.operate.MongoModify;
import org.apache.drill.metastore.mongo.operate.MongoRead;
import org.apache.drill.metastore.mongo.transform.Transformer;
import org.apache.drill.metastore.operate.Metadata;
import org.apache.drill.metastore.operate.MetadataTypeValidator;
import org.apache.drill.metastore.operate.Modify;
import org.apache.drill.metastore.operate.Read;
import org.bson.Document;

public class MongoTables
implements Tables,
MongoMetastoreContext<TableMetadataUnit> {
    private final MongoClient client;
    private final MongoCollection<Document> tableCollection;

    public MongoTables(MongoCollection<Document> tableCollection, MongoClient client) {
        this.tableCollection = tableCollection;
        this.client = client;
    }

    public MongoMetastoreContext<TableMetadataUnit> context() {
        return this;
    }

    public Metadata metadata() {
        return new MongoMetadata();
    }

    public Read<TableMetadataUnit> read() {
        return new MongoRead<TableMetadataUnit>((MetadataTypeValidator)TablesMetadataTypeValidator.INSTANCE, this.context());
    }

    public Modify<TableMetadataUnit> modify() {
        return new MongoModify<TableMetadataUnit>((MetadataTypeValidator)TablesMetadataTypeValidator.INSTANCE, this.context());
    }

    @Override
    public MongoCollection<Document> table() {
        return this.tableCollection;
    }

    @Override
    public MongoClient client() {
        return this.client;
    }

    @Override
    public Transformer<TableMetadataUnit> transformer() {
        return new TablesTransformer(this.context());
    }
}

