/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.hdfs.caching;

import com.oracle.bmc.hdfs.caching.CachingObjectStorage;
import com.oracle.bmc.hdfs.caching.ConsistencyPolicy;
import com.oracle.bmc.objectstorage.ObjectStorage;
import com.oracle.bmc.objectstorage.requests.GetObjectRequest;
import com.oracle.bmc.objectstorage.responses.GetObjectResponse;
import com.oracle.bmc.objectstorage.transfer.DownloadManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoOpConsistencyPolicy
implements ConsistencyPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(NoOpConsistencyPolicy.class);

    @Override
    public CachingObjectStorage.GetObjectRequestCacheKey constructKey(GetObjectRequest request) {
        return new CachingObjectStorage.GetObjectRequestCacheKey(GetObjectRequest.builder().copy(request).opcClientRequestId(null).retryConfiguration(null).invocationCallback(null).build());
    }

    @Override
    public GetObjectResponse initiateRequest(ObjectStorage client, DownloadManager downloadManager, GetObjectRequest request, CachingObjectStorage.GetObjectRequestCacheKey key, CachingObjectStorage.GetObjectResponseCacheValue previousValue) {
        if (previousValue != null) {
            LOG.debug("Reusing cached request with ETag='{}' check for key '{}'", (Object)previousValue, (Object)key);
            return null;
        }
        GetObjectRequest.Builder builder = GetObjectRequest.builder().copy(request);
        builder = CachingObjectStorage.Handler.updateRequestId(builder, request);
        LOG.debug("Making new getObject request for key '{}'", (Object)key);
        return downloadManager.getObject(builder.build());
    }
}

