/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.hdfs.store;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.oracle.bmc.hdfs.BmcProperties;
import com.oracle.bmc.hdfs.caching.CachingObjectStorage;
import com.oracle.bmc.hdfs.caching.ConsistencyPolicy;
import com.oracle.bmc.hdfs.store.BmcDirectFSInputStream;
import com.oracle.bmc.hdfs.store.BmcFileBackedOutputStream;
import com.oracle.bmc.hdfs.store.BmcInMemoryFSInputStream;
import com.oracle.bmc.hdfs.store.BmcInMemoryOutputStream;
import com.oracle.bmc.hdfs.store.BmcMultipartOutputStream;
import com.oracle.bmc.hdfs.store.BmcPropertyAccessor;
import com.oracle.bmc.hdfs.store.BmcReadAheadFSInputStream;
import com.oracle.bmc.hdfs.store.MultipartUploadRequest;
import com.oracle.bmc.hdfs.store.RenameOperation;
import com.oracle.bmc.hdfs.store.RequestBuilder;
import com.oracle.bmc.hdfs.util.BiFunction;
import com.oracle.bmc.hdfs.util.BlockingRejectionHandler;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.objectstorage.ObjectStorage;
import com.oracle.bmc.objectstorage.model.CreateMultipartUploadDetails;
import com.oracle.bmc.objectstorage.model.ObjectSummary;
import com.oracle.bmc.objectstorage.requests.CreateMultipartUploadRequest;
import com.oracle.bmc.objectstorage.requests.GetObjectRequest;
import com.oracle.bmc.objectstorage.requests.ListObjectsRequest;
import com.oracle.bmc.objectstorage.requests.PutObjectRequest;
import com.oracle.bmc.objectstorage.responses.GetObjectResponse;
import com.oracle.bmc.objectstorage.responses.HeadObjectResponse;
import com.oracle.bmc.objectstorage.responses.ListObjectsResponse;
import com.oracle.bmc.objectstorage.responses.PutObjectResponse;
import com.oracle.bmc.objectstorage.transfer.UploadConfiguration;
import com.oracle.bmc.objectstorage.transfer.UploadManager;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BmcDataStore {
    private static final Logger LOG = LoggerFactory.getLogger(BmcDataStore.class);
    private static final int MiB = 0x100000;
    private static final int BLOCK_REPLICATION = 1;
    private static final long LAST_MODIFICATION_TIME = 0L;
    private final ObjectStorage objectStorage;
    private final FileSystem.Statistics statistics;
    private final BmcPropertyAccessor propertyAccessor;
    private final UploadManager uploadManager;
    private final ExecutorService parallelUploadExecutor;
    private final ExecutorService parallelRenameExecutor;
    private final RequestBuilder requestBuilder;
    private final long blockSizeInBytes;
    private final boolean useInMemoryReadBuffer;
    private final boolean useInMemoryWriteBuffer;
    private final boolean useMultipartUploadWriteBuffer;
    private final CreateMultipartUploadRequest.Builder multipartUploadRequestBuilder;
    private final LoadingCache<String, HeadPair> objectMetadataCache;
    private final boolean useReadAhead;
    private final int readAheadSizeInBytes;
    private final String parquetCacheString;
    private final String customReadStreamClass;
    private final String customWriteStreamClass;

    public BmcDataStore(BmcPropertyAccessor propertyAccessor, ObjectStorage objectStorage, String namespace, String bucket, FileSystem.Statistics statistics) {
        this.propertyAccessor = propertyAccessor;
        this.objectStorage = this.configureObjectStorage(objectStorage, propertyAccessor);
        this.statistics = statistics;
        UploadConfiguration.UploadConfigurationBuilder uploadConfigurationBuilder = this.createUploadConfiguration(propertyAccessor);
        this.parallelUploadExecutor = this.createExecutor(propertyAccessor, uploadConfigurationBuilder);
        UploadConfiguration uploadConfiguration = uploadConfigurationBuilder.build();
        LOG.info("Using upload configuration: {}", (Object)uploadConfiguration);
        this.uploadManager = new UploadManager(this.configureObjectStorage(objectStorage, propertyAccessor), uploadConfiguration);
        this.requestBuilder = new RequestBuilder(namespace, bucket);
        this.blockSizeInBytes = propertyAccessor.asLong().get(BmcProperties.BLOCK_SIZE_IN_MB) * 0x100000L;
        this.multipartUploadRequestBuilder = CreateMultipartUploadRequest.builder().bucketName(bucket).namespaceName(namespace);
        this.useInMemoryReadBuffer = propertyAccessor.asBoolean().get(BmcProperties.IN_MEMORY_READ_BUFFER);
        this.useInMemoryWriteBuffer = propertyAccessor.asBoolean().get(BmcProperties.IN_MEMORY_WRITE_BUFFER);
        this.useMultipartUploadWriteBuffer = propertyAccessor.asBoolean().get(BmcProperties.MULTIPART_IN_MEMORY_WRITE_BUFFER_ENABLED);
        this.useReadAhead = propertyAccessor.asBoolean().get(BmcProperties.READ_AHEAD);
        this.readAheadSizeInBytes = BmcDataStore.getReadAheadSizeInBytes(propertyAccessor);
        this.customReadStreamClass = propertyAccessor.asString().get(BmcProperties.READ_STREAM_CLASS);
        this.customWriteStreamClass = propertyAccessor.asString().get(BmcProperties.WRITE_STREAM_CLASS);
        if (this.useInMemoryWriteBuffer && this.useMultipartUploadWriteBuffer) {
            throw new IllegalArgumentException(BmcProperties.IN_MEMORY_WRITE_BUFFER.getPropertyName() + " and " + BmcProperties.MULTIPART_IN_MEMORY_WRITE_BUFFER_ENABLED.getPropertyName() + " are mutually exclusive");
        }
        if (this.useInMemoryReadBuffer && this.useReadAhead) {
            throw new IllegalArgumentException(BmcProperties.IN_MEMORY_READ_BUFFER.getPropertyName() + " and " + BmcProperties.READ_AHEAD.getPropertyName() + " are mutually exclusive");
        }
        this.objectMetadataCache = this.configureHeadObjectCache(propertyAccessor);
        this.parquetCacheString = BmcDataStore.configureParquetCacheString(propertyAccessor);
        this.parallelRenameExecutor = this.createParallelRenameExecutor(propertyAccessor);
    }

    public static int getReadAheadSizeInBytes(BmcPropertyAccessor propertyAccessor) {
        return propertyAccessor.asInteger().get(BmcProperties.READ_AHEAD_BLOCK_SIZE);
    }

    private ExecutorService createParallelRenameExecutor(BmcPropertyAccessor propertyAccessor) {
        Integer numThreadsForRenameDirectoryOperation = propertyAccessor.asInteger().get(BmcProperties.RENAME_DIRECTORY_NUM_THREADS);
        ExecutorService executorService = numThreadsForRenameDirectoryOperation == null || numThreadsForRenameDirectoryOperation <= 1 ? Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("bmcs-hdfs-rename-%d").build()) : Executors.newFixedThreadPool(numThreadsForRenameDirectoryOperation, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("bmcs-hdfs-rename-%d").build());
        return executorService;
    }

    private ObjectStorage configureObjectStorage(ObjectStorage originalObjectStorage, BmcPropertyAccessor propertyAccessor) {
        ObjectStorage objectStorage = originalObjectStorage;
        boolean usePayloadCaching = propertyAccessor.asBoolean().get(BmcProperties.OBJECT_PAYLOAD_CACHING_ENABLED);
        if (usePayloadCaching) {
            try {
                Integer expireAfterWrite;
                Integer expireAfterAccess;
                Long maxWeight;
                String cachingDirectoryProperty = propertyAccessor.asString().get(BmcProperties.OBJECT_PAYLOAD_CACHING_DIRECTORY);
                Path directory = cachingDirectoryProperty != null ? Paths.get(cachingDirectoryProperty, new String[0]) : Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve("oci-hdfs-payload-cache");
                LOG.debug("Payload caching directory is '{}'", (Object)directory);
                Class<?> consistencyPolicyClass = Class.forName(propertyAccessor.asString().get(BmcProperties.OBJECT_PAYLOAD_CACHING_CONSISTENCY_POLICY_CLASS));
                ConsistencyPolicy consistencyPolicy = (ConsistencyPolicy)consistencyPolicyClass.newInstance();
                LOG.debug("Consistency policy is '{}'", (Object)consistencyPolicy.getClass().getName());
                boolean recordStatistics = propertyAccessor.asBoolean().get(BmcProperties.OBJECT_PAYLOAD_CACHING_RECORD_STATS_ENABLED);
                CachingObjectStorage.Configuration.ConfigurationBuilder configurationBuilder = CachingObjectStorage.newConfiguration().client(objectStorage).cacheDirectory(directory).recordStats(recordStatistics).initialCapacity(propertyAccessor.asInteger().get(BmcProperties.OBJECT_PAYLOAD_CACHING_INITIAL_CAPACITY)).consistencyPolicy(consistencyPolicy);
                Integer maxSize = propertyAccessor.asInteger().get(BmcProperties.OBJECT_PAYLOAD_CACHING_MAXIMUM_SIZE);
                if (maxSize != null) {
                    configurationBuilder = configurationBuilder.maximumSize(maxSize);
                }
                if ((maxWeight = propertyAccessor.asLong().get(BmcProperties.OBJECT_PAYLOAD_CACHING_MAXIMUM_WEIGHT_IN_BYTES)) != null) {
                    configurationBuilder = configurationBuilder.maximumWeight(maxWeight);
                }
                if ((expireAfterAccess = propertyAccessor.asInteger().get(BmcProperties.OBJECT_PAYLOAD_CACHING_EXPIRE_AFTER_ACCESS_SECONDS)) != null) {
                    configurationBuilder = configurationBuilder.expireAfterAccess(Duration.ofSeconds(expireAfterAccess.intValue()));
                }
                if ((expireAfterWrite = propertyAccessor.asInteger().get(BmcProperties.OBJECT_PAYLOAD_CACHING_EXPIRE_AFTER_WRITE_SECONDS)) != null) {
                    configurationBuilder = configurationBuilder.expireAfterWrite(Duration.ofSeconds(expireAfterWrite.intValue()));
                }
                CachingObjectStorage cachingObjectStorage = CachingObjectStorage.build(configurationBuilder.build());
                objectStorage = cachingObjectStorage;
                long period = propertyAccessor.asLong().get(BmcProperties.OBJECT_PAYLOAD_CACHING_RECORD_STATS_TIME_INTERVAL_IN_SECONDS);
                if (recordStatistics) {
                    this.logCacheStatistics(period, cachingObjectStorage);
                }
            }
            catch (Exception e) {
                LOG.error("Failed to configure Object Storage payload caching; payload caching disabled", (Throwable)e);
            }
        }
        return objectStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logCacheStatistics(long period, CachingObjectStorage cachingObjectStorage) {
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            }
        });
        try {
            executorService.scheduleAtFixedRate(() -> LOG.info("Cache statistics: {}", (Object)cachingObjectStorage.getCacheStatistics()), 30L, period, TimeUnit.SECONDS);
        }
        finally {
            executorService.shutdown();
        }
    }

    private LoadingCache<String, HeadPair> configureHeadObjectCache(BmcPropertyAccessor propertyAccessor) {
        boolean headObjectCachingEnabled = propertyAccessor.asBoolean().get(BmcProperties.OBJECT_METADATA_CACHING_ENABLED);
        final String loadMessage = headObjectCachingEnabled ? "Not in object metadata cache, getting actual metadata for key: '{}'" : "Getting metadata for key: '{}'";
        CacheLoader<String, HeadPair> loader = new CacheLoader<String, HeadPair>(){

            public HeadPair load(String key) throws Exception {
                LOG.info(loadMessage, (Object)key);
                return BmcDataStore.this.getObjectMetadataUncached(key);
            }
        };
        if (!headObjectCachingEnabled) {
            LOG.info("Object metadata caching disabled");
            return CacheBuilder.newBuilder().maximumSize(0L).build((CacheLoader)loader);
        }
        String headObjectCachingSpec = propertyAccessor.asString().get(BmcProperties.OBJECT_METADATA_CACHING_SPEC);
        CacheBuilderSpec cacheBuilderSpec = CacheBuilderSpec.parse((String)headObjectCachingSpec);
        LOG.info("Object metadata caching enabled with cache spec: '{}'", (Object)cacheBuilderSpec);
        return CacheBuilder.from((CacheBuilderSpec)cacheBuilderSpec).removalListener((RemovalListener)new RemovalListener<String, HeadPair>(){

            public void onRemoval(RemovalNotification<String, HeadPair> removalNotification) {
                LOG.info("Object metadata cache entry '{}' removed (cause '{}', was evicted '{}')", new Object[]{removalNotification.getKey(), removalNotification.getCause(), removalNotification.wasEvicted()});
            }
        }).build((CacheLoader)loader);
    }

    public static String configureParquetCacheString(BmcPropertyAccessor propertyAccessor) {
        String spec = "maximumSize=0";
        if (propertyAccessor.asBoolean().get(BmcProperties.OBJECT_PARQUET_CACHING_ENABLED).booleanValue()) {
            spec = propertyAccessor.asString().get(BmcProperties.OBJECT_PARQUET_CACHING_SPEC);
            LOG.info("{} is enabled, setting parquet cache spec to '{}'", (Object)BmcProperties.OBJECT_PARQUET_CACHING_ENABLED.getPropertyName(), (Object)spec);
        } else {
            LOG.info("{} is disabled, setting parquet cache spec to '{}', which disables the cache", (Object)BmcProperties.OBJECT_PARQUET_CACHING_ENABLED.getPropertyName(), (Object)spec);
        }
        return spec;
    }

    private UploadConfiguration.UploadConfigurationBuilder createUploadConfiguration(BmcPropertyAccessor propertyAccessor) {
        UploadConfiguration.UploadConfigurationBuilder uploadConfigurationBuilder = UploadConfiguration.builder();
        boolean allowMultipartUploads = propertyAccessor.asBoolean().get(BmcProperties.MULTIPART_ALLOWED);
        uploadConfigurationBuilder.allowMultipartUploads(Boolean.valueOf(allowMultipartUploads));
        Integer minimumLengthForMultipartUpload = propertyAccessor.asInteger().get(BmcProperties.MULTIPART_MIN_SIZE_OF_OBJECT_IN_MB);
        uploadConfigurationBuilder.minimumLengthForMultipartUpload(minimumLengthForMultipartUpload);
        Integer deprecatedMinLengthPerUploadPart = propertyAccessor.asInteger().get(BmcProperties.MULTIPART_MIN_PART_SIZE_IN_MB);
        Integer lengthPerUploadPart = propertyAccessor.asInteger().get(BmcProperties.MULTIPART_PART_SIZE_IN_MB);
        if (lengthPerUploadPart != null) {
            uploadConfigurationBuilder.lengthPerUploadPart(lengthPerUploadPart);
        } else if (deprecatedMinLengthPerUploadPart != null) {
            LOG.warn("Using deprecated configuration option to specify the length per upload part: [{}] Consider defining the value for {} instead", (Object)deprecatedMinLengthPerUploadPart, (Object)BmcProperties.MULTIPART_PART_SIZE_IN_MB.getPropertyName());
            uploadConfigurationBuilder.lengthPerUploadPart(deprecatedMinLengthPerUploadPart);
        }
        return uploadConfigurationBuilder;
    }

    private ExecutorService createExecutor(BmcPropertyAccessor propertyAccessor, UploadConfiguration.UploadConfigurationBuilder uploadConfigurationBuilder) {
        Integer numThreadsForParallelUpload = propertyAccessor.asInteger().get(BmcProperties.MULTIPART_NUM_UPLOAD_THREADS);
        boolean streamMultipartEnabled = propertyAccessor.asBoolean().get(BmcProperties.MULTIPART_IN_MEMORY_WRITE_BUFFER_ENABLED);
        if (!(streamMultipartEnabled || numThreadsForParallelUpload != null && numThreadsForParallelUpload > 0)) {
            return null;
        }
        if (!streamMultipartEnabled && numThreadsForParallelUpload == 1) {
            uploadConfigurationBuilder.allowParallelUploads(Boolean.valueOf(false));
            return null;
        }
        if (numThreadsForParallelUpload == null) {
            throw new IllegalArgumentException(BmcProperties.MULTIPART_IN_MEMORY_WRITE_BUFFER_ENABLED.getPropertyName() + " requires " + BmcProperties.MULTIPART_NUM_UPLOAD_THREADS.getPropertyName() + " to be set");
        }
        if (streamMultipartEnabled) {
            int taskTimeout = propertyAccessor.asInteger().get(BmcProperties.MULTIPART_IN_MEMORY_WRITE_TASK_TIMEOUT_SECONDS);
            BlockingRejectionHandler rejectedExecutionHandler = new BlockingRejectionHandler(taskTimeout);
            return new ThreadPoolExecutor(numThreadsForParallelUpload, numThreadsForParallelUpload, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(numThreadsForParallelUpload), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("bmcs-hdfs-blocking-upload-%d").build(), rejectedExecutionHandler);
        }
        return Executors.newFixedThreadPool(numThreadsForParallelUpload, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("bmcs-hdfs-upload-%d").build());
    }

    public void renameFile(org.apache.hadoop.fs.Path source, org.apache.hadoop.fs.Path destination) throws IOException {
        String sourceObject = this.pathToObject(source);
        String destinationObject = this.pathToObject(destination);
        LOG.debug("Attempting to rename path {} to {} (object {} to {})", new Object[]{source, destination, sourceObject, destinationObject});
        this.rename(sourceObject, destinationObject);
    }

    public void renameDirectory(org.apache.hadoop.fs.Path sourceDirectoryPath, org.apache.hadoop.fs.Path destinationDirectoryPath) throws IOException {
        String sourceDirectory = this.pathToDirectory(sourceDirectoryPath);
        String destinationDirectory = this.pathToDirectory(destinationDirectoryPath);
        LOG.debug("Attempting to rename path {} to {} (object {} to {})", new Object[]{sourceDirectoryPath, destinationDirectoryPath, sourceDirectory, destinationDirectory});
        ArrayList<String> objectsToRename = new ArrayList<String>();
        try {
            ListObjectsResponse response;
            String nextToken = null;
            do {
                LOG.debug("Making request with next token {}", nextToken);
                ListObjectsRequest request = this.requestBuilder.listObjects(sourceDirectory, nextToken, null, 1000);
                response = this.objectStorage.listObjects(request);
                this.statistics.incrementReadOps(1);
                List summaries = response.getListObjects().getObjects();
                for (ObjectSummary summary : summaries) {
                    objectsToRename.add(summary.getName());
                }
            } while ((nextToken = response.getListObjects().getNextStartWith()) != null);
        }
        catch (BmcException e) {
            LOG.debug("Failed to list objects for path {}", (Object)sourceDirectory, (Object)e);
            throw new IOException("Failed to rename directory", e);
        }
        this.renameOperationsUsingExecutor(objectsToRename, sourceDirectory, destinationDirectory);
    }

    private void renameOperationsUsingExecutor(ArrayList<String> objectsToRename, String sourceDirectory, String destinationDirectory) throws IOException {
        ArrayList<RenameResponse> renameResponses = new ArrayList<RenameResponse>();
        for (String objectToRename : objectsToRename) {
            String newObjectName = objectToRename.replaceFirst(Pattern.quote(sourceDirectory), destinationDirectory);
            Future<String> futureResponse = this.parallelRenameExecutor.submit(new RenameOperation(this.objectStorage, this.requestBuilder.renameObject(objectToRename, newObjectName)));
            renameResponses.add(new RenameResponse(objectToRename, newObjectName, futureResponse));
        }
        this.awaitRenameOperationTermination(renameResponses);
    }

    private void awaitRenameOperationTermination(List<RenameResponse> renameResponses) throws IOException {
        LOG.debug("Attempting to rename objects in parallel");
        for (RenameResponse renameResponse : renameResponses) {
            try {
                LOG.debug("Attempting to rename {} to {}", (Object)renameResponse.getOldName(), (Object)renameResponse.getNewName());
                Future<String> renameFuture = renameResponse.getRenameOperationFuture();
                String newEntityTag = renameFuture.get();
                this.statistics.incrementWriteOps(1);
                LOG.debug("{} renamed to {}", (Object)renameResponse.getOldName(), (Object)renameResponse.getNewName());
                LOG.debug("{} has eTag {}", (Object)renameResponse.getNewName(), (Object)newEntityTag);
            }
            catch (InterruptedException e) {
                LOG.debug("Thread interrupted while waiting for rename completion", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                LOG.debug("Execution exception while waiting for rename completion", (Throwable)e);
            }
            catch (Exception e) {
                LOG.debug("Failed to rename {} to {}", new Object[]{renameResponse.getOldName(), renameResponse.getNewName(), e});
                throw new IOException("Unable to perform rename", e);
            }
        }
    }

    private void rename(String sourceObject, String destinationObject) throws IOException {
        LOG.debug("Attempting to rename {} to {}", (Object)sourceObject, (Object)destinationObject);
        try {
            String newEntityTag = new RenameOperation(this.objectStorage, this.requestBuilder.renameObject(sourceObject, destinationObject)).call();
            this.statistics.incrementWriteOps(1);
            LOG.debug("Newly renamed object has eTag {}", (Object)newEntityTag);
        }
        catch (Exception e) {
            LOG.debug("Failed to rename {} to {}", new Object[]{sourceObject, destinationObject, e});
            throw new IOException("Unable to perform rename", e);
        }
    }

    public void delete(org.apache.hadoop.fs.Path path) throws IOException {
        block2: {
            String object = this.pathToObject(path);
            LOG.debug("Attempting to delete object {} from path {}", (Object)object, (Object)path);
            try {
                this.objectStorage.deleteObject(this.requestBuilder.deleteObject(object));
                this.statistics.incrementWriteOps(1);
            }
            catch (BmcException e) {
                if (e.getStatusCode() == 404) break block2;
                LOG.debug("Failed to delete object {}", (Object)object, (Object)e);
                throw new IOException("Error attempting to delete object", e);
            }
        }
    }

    public void deleteDirectory(org.apache.hadoop.fs.Path path) throws IOException {
        block3: {
            if (path.isRoot()) {
                LOG.debug("Deleting root directory is a no-op");
                return;
            }
            String directory = this.pathToDirectory(path);
            LOG.debug("Attempting to delete directory {} from path {}", (Object)directory, (Object)path);
            try {
                this.objectStorage.deleteObject(this.requestBuilder.deleteObject(directory));
                this.statistics.incrementWriteOps(1);
            }
            catch (BmcException e) {
                if (e.getStatusCode() == 404) break block3;
                LOG.debug("Failed to delete directory {}", (Object)directory, (Object)e);
                throw new IOException("Error attempting to delete directory", e);
            }
        }
    }

    public void createDirectory(org.apache.hadoop.fs.Path path) throws IOException {
        if (this.isRootDirectory(path)) {
            LOG.debug("Root directory specified, nothing to create");
            return;
        }
        String key = this.pathToDirectory(path);
        LOG.debug("Attempting to create directory {} with object {}", (Object)path, (Object)key);
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[0]);
        try {
            PutObjectResponse response = this.objectStorage.putObject(this.requestBuilder.putObject(key, bais, 0L));
            this.statistics.incrementWriteOps(1);
            LOG.debug("Created directory at {} with etag {}", (Object)path, (Object)response.getETag());
        }
        catch (BmcException e) {
            if (e.getStatusCode() != 409 && e.getStatusCode() != 412) {
                LOG.debug("Failed to create directory for {}", (Object)key, (Object)e);
                throw new IOException("Unable to put object", e);
            }
            LOG.debug("Exception while creating directory, ignoring {} {}", (Object)e.getStatusCode(), (Object)e.getMessage());
        }
    }

    public boolean isEmptyDirectory(org.apache.hadoop.fs.Path path) throws IOException {
        boolean hasSubDirectories;
        ListObjectsResponse response;
        String key = this.pathToDirectory(path);
        LOG.debug("Checking to see if directory path {} is empty (object key {})", (Object)path, (Object)key);
        ListObjectsRequest request = this.requestBuilder.listObjects(key, null, "/", 2);
        this.statistics.incrementReadOps(1);
        try {
            response = this.objectStorage.listObjects(request);
        }
        catch (BmcException e) {
            LOG.debug("Failed to list objects for {}", (Object)key, (Object)e);
            throw new IOException("Unable to determine if path is a directory", e);
        }
        boolean bl = hasSubDirectories = !response.getListObjects().getPrefixes().isEmpty();
        if (hasSubDirectories) {
            return false;
        }
        if (response.getListObjects().getObjects().isEmpty()) {
            return true;
        }
        if (response.getListObjects().getObjects().size() > 1) {
            return false;
        }
        return ((ObjectSummary)response.getListObjects().getObjects().get(0)).getName().equals(key);
    }

    public List<FileStatus> listDirectory(org.apache.hadoop.fs.Path path) throws IOException {
        String key = this.pathToDirectory(path);
        LOG.debug("Listing directory for path {}, object {}", (Object)path, (Object)key);
        ArrayList<FileStatus> entries = new ArrayList<FileStatus>();
        try {
            ListObjectsRequest request = null;
            ListObjectsResponse response = null;
            String nextToken = null;
            HashSet<String> prefixes = new HashSet<String>();
            do {
                LOG.debug("Listing objects with next token {}", nextToken);
                request = this.requestBuilder.listObjects(key, nextToken, "/", 1000);
                response = this.objectStorage.listObjects(request);
                nextToken = BmcDataStore.calculateNextToken(response.getListObjects().getNextStartWith(), response.getListObjects().getPrefixes());
                this.statistics.incrementReadOps(1);
                List summaries = response.getListObjects().getObjects();
                for (ObjectSummary summary : summaries) {
                    if (summary.getName().equals(key)) continue;
                    entries.add(this.createFileStatus(path, summary));
                }
                for (String prefix : response.getListObjects().getPrefixes()) {
                    if (prefixes.contains(prefix)) continue;
                    prefixes.add(prefix);
                    entries.add(this.createDirectoryFileStatus(path, prefix));
                }
            } while (nextToken != null);
        }
        catch (BmcException e) {
            LOG.debug("Failed to list objects for {}", (Object)key, (Object)e);
            throw new IOException("Unable to determine if path is a directory", e);
        }
        return entries;
    }

    private static String calculateNextToken(String token, List<String> prefixes) {
        if (token == null) {
            return null;
        }
        if (prefixes.isEmpty()) {
            return token;
        }
        String lastPrefix = prefixes.get(prefixes.size() - 1);
        if (token.startsWith(lastPrefix)) {
            token = lastPrefix.substring(0, lastPrefix.length() - 1) + "0";
        }
        return token;
    }

    private FileStatus createFileStatus(org.apache.hadoop.fs.Path parentPath, ObjectSummary summary) throws IOException {
        return new FileStatus(summary.getSize().longValue(), this.isDirectory(summary), 1, this.blockSizeInBytes, summary.getTimeCreated().getTime(), this.objectToPath(parentPath, summary.getName()));
    }

    private FileStatus createDirectoryFileStatus(org.apache.hadoop.fs.Path parentPath, String prefix) throws IOException {
        return new FileStatus(0L, true, 1, this.blockSizeInBytes, 0L, this.objectToPath(parentPath, prefix));
    }

    public FileStatus getFileStatus(org.apache.hadoop.fs.Path path) throws IOException {
        if (this.isRootDirectory(path)) {
            LOG.debug("Requested file status for root directory");
            return new FileStatus(0L, true, 1, this.blockSizeInBytes, 0L, path);
        }
        String key = this.pathToObject(path);
        LOG.debug("Getting file status for path {}, object {}", (Object)path, (Object)key);
        HeadPair headData = this.getObjectMetadata(key);
        if (headData != null) {
            return new FileStatus(headData.response.getContentLength().longValue(), this.isDirectory(headData), 1, this.blockSizeInBytes, headData.response.getLastModified().getTime(), path);
        }
        if (!this.isEmptyDirectory(path)) {
            LOG.debug("No placeholder file, but found non-empty directory anyway");
            return new FileStatus(0L, true, 1, this.blockSizeInBytes, 0L, path);
        }
        return null;
    }

    private HeadPair getObjectMetadata(String key) throws IOException {
        try {
            return (HeadPair)this.objectMetadataCache.getUnchecked((Object)key);
        }
        catch (UncheckedExecutionException ee) {
            if (ee.getCause() instanceof IOException) {
                throw (IOException)ee.getCause();
            }
            if (ee.getCause() instanceof ObjectMetadataNotFoundException) {
                return null;
            }
            throw ee;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HeadPair getObjectMetadataUncached(String key) throws IOException {
        HeadObjectResponse response = null;
        String keyUsed = key;
        try {
            response = this.objectStorage.headObject(this.requestBuilder.headObject(key));
            this.statistics.incrementReadOps(1);
            return new HeadPair(response, keyUsed);
        }
        catch (BmcException e) {
            boolean throwEx = true;
            if (e.getStatusCode() == 404) {
                if (key.endsWith("/")) {
                    this.statistics.incrementReadOps(1);
                    throw new ObjectMetadataNotFoundException(key);
                }
                try {
                    keyUsed = key + "/";
                    response = this.objectStorage.headObject(this.requestBuilder.headObject(keyUsed));
                    throwEx = false;
                }
                catch (BmcException e1) {
                    if (e1.getStatusCode() == 404) {
                        throw new ObjectMetadataNotFoundException(key);
                    }
                }
                finally {
                    this.statistics.incrementReadOps(2);
                }
            }
            if (!throwEx) return new HeadPair(response, keyUsed);
            LOG.debug("Failed to get object metadata for {}", (Object)key, (Object)e);
            throw new IOException("Unable to fetch file status for: " + key, e);
        }
    }

    public FSInputStream openReadStream(FileStatus status, org.apache.hadoop.fs.Path path, int bufferSizeInBytes, FileSystem.Statistics statistics) {
        LOG.debug("Opening read stream for {}", (Object)path);
        GetObjectRequestFunction requestBuilder = new GetObjectRequestFunction(path);
        if (!StringUtils.isBlank((CharSequence)this.customReadStreamClass)) {
            FSInputStream readStreamInstance = (FSInputStream)this.createCustomReadStreamClass(this.customReadStreamClass, this.objectStorage, status, requestBuilder, this.statistics);
            return readStreamInstance;
        }
        if (this.useInMemoryReadBuffer) {
            return new BmcInMemoryFSInputStream(this.objectStorage, status, requestBuilder, this.statistics);
        }
        if (this.useReadAhead) {
            return new BmcReadAheadFSInputStream(this.objectStorage, status, (Supplier<GetObjectRequest.Builder>)requestBuilder, this.statistics, this.readAheadSizeInBytes, this.parquetCacheString);
        }
        return new BmcDirectFSInputStream(this.objectStorage, status, requestBuilder, this.statistics);
    }

    public OutputStream openWriteStream(org.apache.hadoop.fs.Path path, int bufferSizeInBytes, Progressable progress) {
        LOG.debug("Opening write stream to {}", (Object)path);
        boolean allowOverwrite = this.propertyAccessor.asBoolean().get(BmcProperties.MULTIPART_ALLOW_OVERWRITE);
        LOG.debug("Allowing overwrites when using Multipart uploads");
        UploadDetailsFunction requestBuilderFn = new UploadDetailsFunction(this.pathToObject(path), allowOverwrite, progress);
        if (!StringUtils.isBlank((CharSequence)this.customWriteStreamClass)) {
            LOG.debug("Using custom write stream class: {}", (Object)this.customWriteStreamClass);
            OutputStream writeStreamInstance = (OutputStream)this.createCustomWriteStreamClass(this.customWriteStreamClass, this.propertyAccessor, this.uploadManager, bufferSizeInBytes, requestBuilderFn);
            return writeStreamInstance;
        }
        if (this.useMultipartUploadWriteBuffer) {
            String objectName = this.pathToObject(path);
            CreateMultipartUploadDetails details = CreateMultipartUploadDetails.builder().object(objectName).build();
            this.multipartUploadRequestBuilder.createMultipartUploadDetails(details);
            MultipartUploadRequest multipartUploadRequest = MultipartUploadRequest.builder().objectStorage(this.objectStorage).multipartUploadRequest(this.multipartUploadRequestBuilder.buildWithoutInvocationCallback()).allowOverwrite(allowOverwrite).build();
            return new BmcMultipartOutputStream(this.propertyAccessor, multipartUploadRequest, bufferSizeInBytes);
        }
        if (this.useInMemoryWriteBuffer) {
            return new BmcInMemoryOutputStream(this.uploadManager, bufferSizeInBytes, requestBuilderFn);
        }
        return new BmcFileBackedOutputStream(this.propertyAccessor, this.uploadManager, requestBuilderFn);
    }

    public long getBlockSizeInBytes() {
        return this.blockSizeInBytes;
    }

    private boolean isRootDirectory(org.apache.hadoop.fs.Path path) {
        return path.isRoot();
    }

    private boolean isDirectory(HeadPair headData) {
        return headData.response.getContentLength() == 0L && headData.objectKey.endsWith("/");
    }

    private boolean isDirectory(ObjectSummary summary) {
        return summary.getSize() == 0L && summary.getName().endsWith("/");
    }

    private String pathToDirectory(org.apache.hadoop.fs.Path path) {
        String objectKey = this.pathToObject(path);
        if (objectKey.isEmpty()) {
            return objectKey;
        }
        if (objectKey.endsWith("/")) {
            return objectKey;
        }
        return objectKey + "/";
    }

    private String pathToObject(org.apache.hadoop.fs.Path path) {
        return path.toUri().getPath().substring(1);
    }

    private org.apache.hadoop.fs.Path objectToPath(org.apache.hadoop.fs.Path parentPath, String object) {
        return new org.apache.hadoop.fs.Path(parentPath, "/" + object);
    }

    private <T> T createCustomReadStreamClass(String className, ObjectStorage objectStorage, FileStatus status, Supplier<GetObjectRequest.Builder> requestBuilder, FileSystem.Statistics statistics) {
        try {
            Class<?> customClass = Class.forName(className);
            Constructor<?> customClassConstructor = customClass.getConstructor(BmcPropertyAccessor.class, ObjectStorage.class, FileStatus.class, Supplier.class, FileSystem.Statistics.class);
            try {
                return (T)customClassConstructor.newInstance(this.propertyAccessor, objectStorage, status, requestBuilder, statistics);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                throw new IllegalStateException("Unable to create new custom client instance", e);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Configured to create custom class '" + className + "', but none exists");
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Custom client class does not have the required constructor", e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Unable to create new custom client instance", e);
        }
    }

    private <T> T createCustomWriteStreamClass(String className, BmcPropertyAccessor propertyAccessor, UploadManager uploadManager, int bufferSizeInBytes, BiFunction<Long, InputStream, UploadManager.UploadRequest> requestBuilderFn) {
        try {
            Class<?> customClass = Class.forName(className);
            Constructor<?> customClassConstructor = customClass.getConstructor(BmcPropertyAccessor.class, UploadManager.class, Integer.TYPE, BiFunction.class);
            try {
                return (T)customClassConstructor.newInstance(propertyAccessor, uploadManager, bufferSizeInBytes, requestBuilderFn);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                throw new IllegalStateException("Unable to create new custom client instance", e);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Configured to create custom class '" + className + "', but none exists");
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Custom client class does not have the required constructor", e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Unable to create new custom client instance", e);
        }
    }

    private static final class HeadPair {
        private final HeadObjectResponse response;
        private final String objectKey;

        @ConstructorProperties(value={"response", "objectKey"})
        public HeadPair(HeadObjectResponse response, String objectKey) {
            this.response = response;
            this.objectKey = objectKey;
        }
    }

    private final class UploadDetailsFunction
    implements BiFunction<Long, InputStream, UploadManager.UploadRequest> {
        private final String objectName;
        private final boolean allowOverwrite;
        private final Progressable progressable;

        @Override
        public UploadManager.UploadRequest apply(Long contentLengthInBytes, InputStream inputStream) {
            return BmcDataStore.this.requestBuilder.uploadRequest(this.objectName, inputStream, contentLengthInBytes, this.progressable, this.allowOverwrite, BmcDataStore.this.parallelUploadExecutor);
        }

        @ConstructorProperties(value={"objectName", "allowOverwrite", "progressable"})
        public UploadDetailsFunction(String objectName, boolean allowOverwrite, Progressable progressable) {
            this.objectName = objectName;
            this.allowOverwrite = allowOverwrite;
            this.progressable = progressable;
        }
    }

    private final class PutObjectFromGetRequestFunction
    implements Function<GetObjectResponse, PutObjectRequest> {
        private final String objectName;

        public PutObjectRequest apply(GetObjectResponse getResponse) {
            return BmcDataStore.this.requestBuilder.putObject(this.objectName, getResponse.getInputStream(), getResponse.getContentLength(), getResponse.getContentMd5());
        }

        @ConstructorProperties(value={"objectName"})
        public PutObjectFromGetRequestFunction(String objectName) {
            this.objectName = objectName;
        }
    }

    private final class GetObjectRequestFunction
    implements Supplier<GetObjectRequest.Builder> {
        private final org.apache.hadoop.fs.Path path;

        public GetObjectRequest.Builder get() {
            return BmcDataStore.this.requestBuilder.getObjectBuilder(BmcDataStore.this.pathToObject(this.path));
        }

        @ConstructorProperties(value={"path"})
        public GetObjectRequestFunction(org.apache.hadoop.fs.Path path) {
            this.path = path;
        }
    }

    private static class ObjectMetadataNotFoundException
    extends RuntimeException {
        private final String key;

        public ObjectMetadataNotFoundException(String key) {
            super("Object metadata not found for key: " + key);
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }

    private static class RenameResponse {
        private final String oldName;
        private final String newName;
        private final Future<String> renameOperationFuture;

        @ConstructorProperties(value={"oldName", "newName", "renameOperationFuture"})
        public RenameResponse(String oldName, String newName, Future<String> renameOperationFuture) {
            this.oldName = oldName;
            this.newName = newName;
            this.renameOperationFuture = renameOperationFuture;
        }

        public String getOldName() {
            return this.oldName;
        }

        public String getNewName() {
            return this.newName;
        }

        public Future<String> getRenameOperationFuture() {
            return this.renameOperationFuture;
        }
    }
}

