/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.openid;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.openid.AuthError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class ErrUnion {
    public static final ErrUnion OTHER = new ErrUnion().withTag(Tag.OTHER);
    private Tag _tag;
    private AuthError authErrorValue;

    private ErrUnion() {
    }

    private ErrUnion withTag(Tag _tag) {
        ErrUnion result = new ErrUnion();
        result._tag = _tag;
        return result;
    }

    private ErrUnion withTagAndAuthError(Tag _tag, AuthError authErrorValue) {
        ErrUnion result = new ErrUnion();
        result._tag = _tag;
        result.authErrorValue = authErrorValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isAuthError() {
        return this._tag == Tag.AUTH_ERROR;
    }

    public static ErrUnion authError(AuthError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new ErrUnion().withTagAndAuthError(Tag.AUTH_ERROR, value);
    }

    public AuthError getAuthErrorValue() {
        if (this._tag != Tag.AUTH_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.AUTH_ERROR, but was Tag." + this._tag.name());
        }
        return this.authErrorValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.authErrorValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ErrUnion) {
            ErrUnion other = (ErrUnion)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case AUTH_ERROR: {
                    return this.authErrorValue == other.authErrorValue || this.authErrorValue.equals((Object)other.authErrorValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<ErrUnion> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ErrUnion value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case AUTH_ERROR: {
                    g.writeStartObject();
                    this.writeTag("auth_error", g);
                    g.writeFieldName("auth_error");
                    AuthError.Serializer.INSTANCE.serialize(value.authErrorValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public ErrUnion deserialize(JsonParser p) throws IOException, JsonParseException {
            ErrUnion value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("auth_error".equals(tag)) {
                AuthError fieldValue = null;
                Serializer.expectField("auth_error", p);
                fieldValue = AuthError.Serializer.INSTANCE.deserialize(p);
                value = ErrUnion.authError(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        AUTH_ERROR,
        OTHER;

    }
}

