/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.MaskingCallback;
import org.jline.reader.Parser;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import sqlline.Application;
import sqlline.AttributedStyles;
import sqlline.BuiltInProperty;
import sqlline.CommandHandler;
import sqlline.ConnectionConfigParser;
import sqlline.DatabaseConnection;
import sqlline.DatabaseConnections;
import sqlline.DispatchCallback;
import sqlline.OutputFile;
import sqlline.PromptHandler;
import sqlline.SqlLine;
import sqlline.SqlLineOpts;
import sqlline.SqlLineParser;

public class Commands {
    private static final String[] METHODS = new String[]{"allProceduresAreCallable", "allTablesAreSelectable", "dataDefinitionCausesTransactionCommit", "dataDefinitionIgnoredInTransactions", "doesMaxRowSizeIncludeBlobs", "getCatalogSeparator", "getCatalogTerm", "getDatabaseProductName", "getDatabaseProductVersion", "getDefaultTransactionIsolation", "getDriverMajorVersion", "getDriverMinorVersion", "getDriverName", "getDriverVersion", "getExtraNameCharacters", "getIdentifierQuoteString", "getMaxBinaryLiteralLength", "getMaxCatalogNameLength", "getMaxCharLiteralLength", "getMaxColumnNameLength", "getMaxColumnsInGroupBy", "getMaxColumnsInIndex", "getMaxColumnsInOrderBy", "getMaxColumnsInSelect", "getMaxColumnsInTable", "getMaxConnections", "getMaxCursorNameLength", "getMaxIndexLength", "getMaxProcedureNameLength", "getMaxRowSize", "getMaxSchemaNameLength", "getMaxStatementLength", "getMaxStatements", "getMaxTableNameLength", "getMaxTablesInSelect", "getMaxUserNameLength", "getNumericFunctions", "getProcedureTerm", "getSchemaTerm", "getSearchStringEscape", "getSQLKeywords", "getStringFunctions", "getSystemFunctions", "getTimeDateFunctions", "getURL", "getUserName", "isCatalogAtStart", "isReadOnly", "nullPlusNonNullIsNull", "nullsAreSortedAtEnd", "nullsAreSortedAtStart", "nullsAreSortedHigh", "nullsAreSortedLow", "storesLowerCaseIdentifiers", "storesLowerCaseQuotedIdentifiers", "storesMixedCaseIdentifiers", "storesMixedCaseQuotedIdentifiers", "storesUpperCaseIdentifiers", "storesUpperCaseQuotedIdentifiers", "supportsAlterTableWithAddColumn", "supportsAlterTableWithDropColumn", "supportsANSI92EntryLevelSQL", "supportsANSI92FullSQL", "supportsANSI92IntermediateSQL", "supportsBatchUpdates", "supportsCatalogsInDataManipulation", "supportsCatalogsInIndexDefinitions", "supportsCatalogsInPrivilegeDefinitions", "supportsCatalogsInProcedureCalls", "supportsCatalogsInTableDefinitions", "supportsColumnAliasing", "supportsConvert", "supportsCoreSQLGrammar", "supportsCorrelatedSubqueries", "supportsDataDefinitionAndDataManipulationTransactions", "supportsDataManipulationTransactionsOnly", "supportsDifferentTableCorrelationNames", "supportsExpressionsInOrderBy", "supportsExtendedSQLGrammar", "supportsFullOuterJoins", "supportsGroupBy", "supportsGroupByBeyondSelect", "supportsGroupByUnrelated", "supportsIntegrityEnhancementFacility", "supportsLikeEscapeClause", "supportsLimitedOuterJoins", "supportsMinimumSQLGrammar", "supportsMixedCaseIdentifiers", "supportsMixedCaseQuotedIdentifiers", "supportsMultipleResultSets", "supportsMultipleTransactions", "supportsNonNullableColumns", "supportsOpenCursorsAcrossCommit", "supportsOpenCursorsAcrossRollback", "supportsOpenStatementsAcrossCommit", "supportsOpenStatementsAcrossRollback", "supportsOrderByUnrelated", "supportsOuterJoins", "supportsPositionedDelete", "supportsPositionedUpdate", "supportsSchemasInDataManipulation", "supportsSchemasInIndexDefinitions", "supportsSchemasInPrivilegeDefinitions", "supportsSchemasInProcedureCalls", "supportsSchemasInTableDefinitions", "supportsSelectForUpdate", "supportsStoredProcedures", "supportsSubqueriesInComparisons", "supportsSubqueriesInExists", "supportsSubqueriesInIns", "supportsSubqueriesInQuantifieds", "supportsTableCorrelationNames", "supportsTransactions", "supportsUnion", "supportsUnionAll", "usesLocalFilePerTable", "usesLocalFiles"};
    private final SqlLine sqlLine;
    private final ConnectionConfigParser conConfParser;

    Commands(SqlLine sqlLine) {
        this.sqlLine = sqlLine;
        this.conConfParser = new ConnectionConfigParser(sqlLine);
    }

    public void metadata(String line, DispatchCallback callback) {
        this.sqlLine.debug(line);
        String[] parts = this.sqlLine.split(line);
        if (parts == null || parts.length == 0) {
            this.dbinfo("", callback);
            return;
        }
        if (parts.length == 1) {
            this.sqlLine.error("Usage: metadata <methodname> <params...>");
            callback.setToFailure();
            return;
        }
        LinkedList<Object> params = new LinkedList<Object>(Arrays.asList(parts));
        params.remove(0);
        params.remove(0);
        this.sqlLine.debug(((Object)params).toString());
        this.metadata(parts[1], params, callback);
    }

    public void metadata(String cmd, List<Object> argList, DispatchCallback callback) {
        block17: {
            if (!this.sqlLine.assertConnection()) {
                callback.setToFailure();
                return;
            }
            try {
                TreeSet<String> methodNames = new TreeSet<String>();
                TreeSet<String> methodNamesUpper = new TreeSet<String>();
                Class<?> currentClass = this.sqlLine.getConnection().getMetaData().getClass();
                Object res = null;
                do {
                    for (Method method : currentClass.getDeclaredMethods()) {
                        int modifiers = method.getModifiers();
                        if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers)) continue;
                        methodNames.add(method.getName());
                        methodNamesUpper.add(method.getName().toUpperCase(Locale.ROOT));
                        if (!methodNamesUpper.contains(cmd.toUpperCase(Locale.ROOT))) continue;
                        try {
                            res = this.sqlLine.getReflector().invoke((Object)this.sqlLine.getDatabaseMetaData(), this.sqlLine.getDatabaseMetaData().getClass(), cmd, argList);
                        }
                        catch (Exception e) {
                            this.sqlLine.handleException(e);
                            callback.setToFailure();
                            return;
                        }
                        if (res != null) break;
                    }
                    currentClass = currentClass.getSuperclass();
                } while (res == null && DatabaseMetaData.class.isAssignableFrom(currentClass));
                if (!methodNamesUpper.contains(cmd.toUpperCase(Locale.ROOT))) {
                    this.sqlLine.error(this.sqlLine.loc("no-such-method", cmd));
                    this.sqlLine.error(this.sqlLine.loc("possible-methods", new Object[0]));
                    for (String methodName : methodNames) {
                        this.sqlLine.error("   " + methodName);
                    }
                    callback.setToFailure();
                    return;
                }
                if (res instanceof ResultSet) {
                    try (ResultSet rs = (ResultSet)res;){
                        this.sqlLine.print(rs, callback);
                        break block17;
                    }
                }
                if (res != null) {
                    this.sqlLine.output(res.toString());
                }
            }
            catch (Exception e) {
                callback.setToFailure();
                this.sqlLine.error(e);
            }
        }
        callback.setToSuccess();
    }

    public void history(String line, DispatchCallback callback) {
        try {
            String[] stringArray;
            String argsLine = line.substring("history".length());
            LineReader lineReader = this.sqlLine.getLineReader();
            PrintStream printStream = this.sqlLine.getOutputStream();
            PrintStream printStream2 = this.sqlLine.getErrorStream();
            Path path = Paths.get("", new String[0]).toAbsolutePath();
            if (argsLine.isEmpty()) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.sqlLine.getOpts().getHistoryFlags();
            } else {
                stringArray = this.sqlLine.split(argsLine, " ");
            }
            org.jline.builtins.Commands.history((LineReader)lineReader, (PrintStream)printStream, (PrintStream)printStream2, (Path)path, (String[])stringArray);
        }
        catch (Exception e) {
            callback.setToFailure();
        }
        callback.setToSuccess();
    }

    public void rerun(String line, DispatchCallback callback) {
        int offset;
        String[] cmd = this.sqlLine.split(line);
        History history = this.sqlLine.getLineReader().getHistory();
        int size = history.size();
        if (cmd.length > 2 || cmd.length == 2 && !cmd[1].matches("-?\\d+")) {
            if (size == 0) {
                this.sqlLine.error("Usage: rerun <offset>, history should not be empty");
            } else {
                this.sqlLine.error("Usage: rerun <offset>, available range of offset is -" + (size - 1) + ".." + size);
            }
            callback.setToFailure();
            return;
        }
        int n = offset = cmd.length == 1 ? -1 : Integer.parseInt(cmd[1]);
        if (size < offset || size - 1 < -offset || offset == 0) {
            if (offset == 0) {
                this.sqlLine.error("Usage: rerun <offset>, offset should be positive or negative");
            }
            if (size == 0) {
                this.sqlLine.error("Usage: rerun <offset>, history should not be empty");
            } else {
                this.sqlLine.error("Usage: rerun <offset>, available range of offset is -" + (size - 1) + ".." + size);
            }
            callback.setToFailure();
            return;
        }
        this.sqlLine.dispatch(this.calculateCommand(offset, new HashSet<Integer>()), callback);
    }

    private String calculateCommand(int currentOffset, Set<Integer> offsets) {
        if (!offsets.add(currentOffset)) {
            throw new IllegalArgumentException("Cycled rerun of commands from history " + offsets);
        }
        History history = this.sqlLine.getLineReader().getHistory();
        Iterator iterator = currentOffset > 0 ? history.iterator(currentOffset - 1) : history.reverseIterator(history.size() - 1 + currentOffset);
        String command = ((History.Entry)iterator.next()).line();
        if (command.trim().startsWith("!/") || command.startsWith("!rerun")) {
            int offset;
            String[] cmd = this.sqlLine.split(command);
            if (cmd.length > 2 || cmd.length == 2 && !cmd[1].matches("-?\\d+")) {
                return command;
            }
            int n = offset = cmd.length == 1 ? -1 : Integer.parseInt(cmd[1]);
            if (history.size() < offset || history.size() - 1 < -offset) {
                return command;
            }
            return this.calculateCommand(offset, offsets);
        }
        return command;
    }

    String arg1(String line, String paramName) {
        return this.arg1(line, paramName, null);
    }

    String arg1(String line, String paramName, String def) {
        String[] ret = this.sqlLine.split(line);
        if (ret == null || ret.length != 2) {
            if (def != null) {
                return def;
            }
            throw new IllegalArgumentException(this.sqlLine.loc("arg-usage", ret == null || ret.length == 0 ? "" : ret[0], paramName));
        }
        return ret[1];
    }

    private List<Object> buildMetadataArgs(String line, String paramName, String[] defaultValues) {
        String[] compound;
        ArrayList<Object> list = new ArrayList<Object>();
        String[][] ret = this.sqlLine.splitCompound(line);
        if (ret == null || ret.length != 2) {
            if (defaultValues[defaultValues.length - 1] == null) {
                throw new IllegalArgumentException(this.sqlLine.loc("arg-usage", ret == null || ret.length == 0 ? "" : ret[0][0], paramName));
            }
            compound = new String[]{};
        } else {
            compound = ret[1];
        }
        if (compound.length <= defaultValues.length) {
            list.addAll(Arrays.asList(defaultValues).subList(0, defaultValues.length - compound.length));
            list.addAll(Arrays.asList(compound));
        } else {
            list.addAll(Arrays.asList(compound).subList(0, defaultValues.length));
        }
        return list;
    }

    private void setSchemaOrSchemaAndEntityArgs(Object[] args, String[][] splitResult) {
        if (splitResult.length == 2) {
            args[2] = splitResult[1][0];
        } else if (splitResult.length > 2) {
            args[1] = splitResult[1][0];
            args[2] = splitResult[2][0];
        }
    }

    public void indexes(String line, DispatchCallback callback) throws Exception {
        String[][] ret = this.sqlLine.splitCompound(line);
        Object[] args = new Object[]{this.sqlLine.getConnection().getCatalog(), null, "%", ret != null && ret.length > 3 ? Boolean.valueOf(ret[3][0]) : Boolean.FALSE, ret != null && ret.length > 4 ? Boolean.valueOf(ret[4][0]) : Boolean.TRUE};
        if (ret == null || ret.length > args.length) {
            throw new IllegalArgumentException("Usage: !indexes <table name>\nor !indexes <schema name> <table name>\nor !indexes <schema name> <table name> <unique>\nor !indexes <schema name> <table name> <unique> <approximate>\n");
        }
        this.setSchemaOrSchemaAndEntityArgs(args, ret);
        this.metadata("getIndexInfo", Arrays.asList(args), callback);
    }

    public void primarykeys(String line, DispatchCallback callback) throws Exception {
        String[][] ret = this.sqlLine.splitCompound(line);
        Object[] args = new Object[]{this.sqlLine.getConnection().getCatalog(), null, "%"};
        if (ret == null || ret.length > args.length) {
            throw new IllegalArgumentException("Usage: !primarykeys <table name>\nor !primarykeys <schema name> <table name>");
        }
        this.setSchemaOrSchemaAndEntityArgs(args, ret);
        this.metadata("getPrimaryKeys", Arrays.asList(args), callback);
    }

    public void exportedkeys(String line, DispatchCallback callback) throws Exception {
        String[] strings = new String[]{this.sqlLine.getConnection().getCatalog(), null, "%"};
        List<Object> args = this.buildMetadataArgs(line, "table name", strings);
        this.metadata("getExportedKeys", args, callback);
    }

    public void importedkeys(String line, DispatchCallback callback) throws Exception {
        String[] strings = new String[]{this.sqlLine.getConnection().getCatalog(), null, "%"};
        List<Object> args = this.buildMetadataArgs(line, "table name", strings);
        this.metadata("getImportedKeys", args, callback);
    }

    public void procedures(String line, DispatchCallback callback) throws Exception {
        String[][] ret = this.sqlLine.splitCompound(line);
        Object[] args = new Object[]{this.sqlLine.getConnection().getCatalog(), null, "%"};
        if (ret == null || ret.length > args.length) {
            throw new IllegalArgumentException("Usage: !procedures <procedure name pattern>\nor !procedures <schema name pattern> <procedure name pattern>");
        }
        this.setSchemaOrSchemaAndEntityArgs(args, ret);
        this.metadata("getProcedures", Arrays.asList(args), callback);
    }

    public void tables(String line, DispatchCallback callback) throws SQLException {
        Object[] args = new Object[]{this.sqlLine.getConnection().getCatalog(), null, "%", null};
        String[][] ret = this.sqlLine.splitCompound(line);
        if (ret == null) {
            throw new IllegalArgumentException("Usage: !tables <table name pattern>\nor !tables <schema name pattern> <table name pattern>\nor !tables <schema name pattern> <table name pattern> (<table type name>)*");
        }
        this.setSchemaOrSchemaAndEntityArgs(args, ret);
        if (ret.length > 3) {
            String[] tableTypes = new String[ret.length - 3];
            ret = this.sqlLine.splitCompound(line, false, true);
            for (int i = 3; i < ret.length; ++i) {
                tableTypes[i - 3] = ret[i][0];
            }
            args[3] = tableTypes;
        }
        this.metadata("getTables", Arrays.asList(args), callback);
    }

    public void schemas(String line, DispatchCallback callback) {
        this.metadata("getSchemas", Collections.emptyList(), callback);
    }

    public void typeinfo(String line, DispatchCallback callback) {
        this.metadata("getTypeInfo", Collections.emptyList(), callback);
    }

    public void nativesql(String sql, DispatchCallback callback) throws Exception {
        if (sql.startsWith("!")) {
            sql = sql.substring(1);
        }
        if (sql.startsWith("native")) {
            sql = sql.substring("native".length() + 1);
        }
        String nat = this.sqlLine.getConnection().nativeSQL(sql);
        this.sqlLine.output(nat);
        callback.setToSuccess();
    }

    public void columns(String line, DispatchCallback callback) throws SQLException {
        String[][] ret = this.sqlLine.splitCompound(line);
        Object[] args = new Object[]{this.sqlLine.getConnection().getCatalog(), null, "%", "%"};
        if (ret == null || ret.length > args.length) {
            throw new IllegalArgumentException("Usage: !columns <table name pattern>\nor !columns <schema name pattern> <table name pattern>\nor !columns <schema name pattern> <table name pattern> <column name pattern>");
        }
        this.setSchemaOrSchemaAndEntityArgs(args, ret);
        if (ret.length == 4) {
            args[3] = ret[3][0];
        }
        this.metadata("getColumns", Arrays.asList(args), callback);
    }

    public void dropall(String line, DispatchCallback callback) {
        String[] parts = this.sqlLine.split(line);
        if (parts.length > 2) {
            this.sqlLine.error("Usage: !dropall [schema_pattern]");
            callback.setToFailure();
            return;
        }
        DatabaseConnection databaseConnection = this.sqlLine.getDatabaseConnection();
        if (databaseConnection == null || databaseConnection.getUrl() == null) {
            this.sqlLine.error(this.sqlLine.loc("no-current-connection", new Object[0]));
            callback.setToFailure();
            return;
        }
        try {
            String question = this.sqlLine.loc("really-drop-all", new Object[0]);
            int userResponse = this.getUserAnswer(question, 121, 110, 89, 78);
            if (userResponse != 121 && userResponse != 89) {
                this.sqlLine.error("abort-drop-all");
                callback.setToFailure();
                return;
            }
            LinkedList<String> cmds = new LinkedList<String>();
            char openQuote = this.sqlLine.getDialect().getOpenQuote();
            char closeQuote = this.sqlLine.getDialect().getOpenQuote();
            try (ResultSet rs = this.sqlLine.getTables(parts.length > 1 ? parts[1] : null);){
                while (rs.next()) {
                    cmds.add("DROP TABLE " + openQuote + rs.getString("TABLE_SCHEM") + closeQuote + "." + openQuote + rs.getString("TABLE_NAME") + closeQuote + ";");
                }
            }
            if (this.sqlLine.runCommands(cmds, callback) == cmds.size()) {
                callback.setToSuccess();
            } else {
                callback.setToFailure();
            }
        }
        catch (Exception e) {
            callback.setToFailure();
            this.sqlLine.error(e);
        }
    }

    int getUserAnswer(String question, int ... allowedAnswers) throws IOException {
        int c;
        Set allowedAnswerSet = IntStream.of(allowedAnswers).boxed().collect(Collectors.toSet());
        Terminal terminal = this.sqlLine.getLineReader().getTerminal();
        PrintWriter writer = terminal.writer();
        writer.write(question);
        writer.write(10);
        writer.flush();
        while ((c = terminal.reader().read(100L)) != -1 && !allowedAnswerSet.contains(c)) {
        }
        return c;
    }

    public void reconnect(String line, DispatchCallback callback) {
        DatabaseConnection databaseConnection = this.sqlLine.getDatabaseConnection();
        if (databaseConnection == null || databaseConnection.getUrl() == null) {
            this.sqlLine.error(this.sqlLine.loc("no-current-connection", new Object[0]));
            callback.setToFailure();
            return;
        }
        this.sqlLine.info(this.sqlLine.loc("reconnecting", databaseConnection.getUrl()));
        try {
            databaseConnection.reconnect();
        }
        catch (Exception e) {
            this.sqlLine.error(e);
            callback.setToFailure();
            return;
        }
        callback.setToSuccess();
    }

    public void scan(String line, DispatchCallback callback) {
        TreeMap<String, Driver> driverNames = new TreeMap<String, Driver>();
        if (this.sqlLine.getDrivers() == null) {
            this.sqlLine.setDrivers(this.sqlLine.scanDrivers());
        }
        this.sqlLine.info(this.sqlLine.loc("drivers-found-count", this.sqlLine.getDrivers().size()));
        for (Driver driver : this.sqlLine.getDrivers()) {
            driverNames.put(driver.getClass().getName(), driver);
        }
        String header = SqlLine.rpad(this.sqlLine.loc("compliant", new Object[0]), 10) + SqlLine.rpad(this.sqlLine.loc("jdbc-version", new Object[0]), 8) + this.sqlLine.loc("driver-class", new Object[0]);
        this.sqlLine.output(new AttributedString((CharSequence)header, AttributedStyle.BOLD));
        for (Map.Entry driverEntry : driverNames.entrySet()) {
            String name = (String)driverEntry.getKey();
            try {
                Class<?> klass = Class.forName(name);
                Driver driver = (Driver)klass.getConstructor(new Class[0]).newInstance(new Object[0]);
                String msg = SqlLine.rpad(driver.jdbcCompliant() ? "yes" : "no", 10) + SqlLine.rpad(driver.getMajorVersion() + "." + driver.getMinorVersion(), 8) + name;
                if (driver.jdbcCompliant()) {
                    this.sqlLine.output(msg);
                    continue;
                }
                this.sqlLine.output(new AttributedString((CharSequence)msg, AttributedStyles.RED));
            }
            catch (Throwable t) {
                this.sqlLine.output(new AttributedString((CharSequence)name, AttributedStyles.RED));
            }
        }
        callback.setToSuccess();
    }

    public void save(String line, DispatchCallback callback) throws IOException {
        this.sqlLine.info(this.sqlLine.loc("saving-options", this.sqlLine.getOpts().getPropertiesFile()));
        this.sqlLine.getOpts().save();
        callback.setToSuccess();
    }

    public void load(String line, DispatchCallback callback) throws IOException {
        this.sqlLine.getOpts().load();
        this.sqlLine.info(this.sqlLine.loc("loaded-options", this.sqlLine.getOpts().getPropertiesFile()));
        callback.setToSuccess();
    }

    public void config(String line, DispatchCallback callback) {
        try {
            Properties props = this.sqlLine.getOpts().toProperties();
            TreeSet<String> keys = new TreeSet<String>(Commands.asMap(props).keySet());
            for (String key : keys) {
                this.sqlLine.outputProperty(key.substring("sqlline.".length()), props.getProperty(key));
            }
        }
        catch (Exception e) {
            callback.setToFailure();
            this.sqlLine.error(e);
            return;
        }
        callback.setToSuccess();
    }

    public void set(String line, DispatchCallback callback) {
        if (line == null || line.trim().equals("set") || line.length() == 0) {
            this.config(null, callback);
            return;
        }
        String[] parts = this.sqlLine.split(line);
        if (parts.length > 3) {
            this.sqlLine.error("Usage: set [all | <property name> [<value>]]");
            callback.setToFailure();
            return;
        }
        String propertyName = parts[1].toLowerCase(Locale.ROOT);
        if ("all".equals(propertyName)) {
            this.config(null, callback);
            return;
        }
        if (!this.sqlLine.getOpts().hasProperty(propertyName)) {
            this.sqlLine.error(this.sqlLine.loc("no-specified-prop", propertyName));
            callback.setToFailure();
            return;
        }
        if (parts.length == 2) {
            try {
                this.sqlLine.outputProperty(propertyName, this.sqlLine.getOpts().get(propertyName));
                callback.setToSuccess();
            }
            catch (Exception e) {
                this.sqlLine.error(e);
                callback.setToFailure();
            }
        } else {
            this.setProperty(propertyName, parts[2], null, callback);
        }
    }

    public void reset(String line, DispatchCallback callback) {
        String[] split = this.sqlLine.split(line, 2, "Usage: reset (all | <property name>)");
        if (split == null) {
            callback.setToFailure();
            return;
        }
        String propertyName = split[1].toLowerCase(Locale.ROOT);
        if ("all".equals(propertyName)) {
            this.sqlLine.setOpts(new SqlLineOpts(this.sqlLine));
            this.sqlLine.info(this.sqlLine.loc("reset-all-props", new Object[0]));
            callback.setToSuccess();
            return;
        }
        if (!this.sqlLine.getOpts().hasProperty(propertyName)) {
            this.sqlLine.error(this.sqlLine.loc("no-specified-prop", propertyName));
            callback.setToFailure();
            return;
        }
        try {
            String defaultValue = new SqlLineOpts(this.sqlLine).get(propertyName);
            this.setProperty(propertyName, defaultValue, "reset-prop", callback);
        }
        catch (Exception e) {
            callback.setToFailure();
            this.sqlLine.error(e);
        }
    }

    private void setProperty(String key, String value, String res, DispatchCallback callback) {
        boolean success = this.sqlLine.getOpts().set(key, value, false);
        if (success) {
            if (this.sqlLine.getOpts().getAutoSave()) {
                try {
                    this.sqlLine.getOpts().save();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (res != null) {
                this.sqlLine.info(this.sqlLine.loc(res, key, value));
            }
            callback.setToSuccess();
        } else {
            callback.setToFailure();
        }
    }

    private void reportResult(String action, long start, long end) {
        if (this.sqlLine.getOpts().getShowElapsedTime()) {
            this.sqlLine.info(action + " " + this.sqlLine.locElapsedTime(end - start));
        } else {
            this.sqlLine.info(action);
        }
    }

    public void commit(String line, DispatchCallback callback) {
        if (!this.sqlLine.assertConnection()) {
            callback.setToFailure();
            return;
        }
        if (!this.sqlLine.assertAutoCommit()) {
            callback.setToFailure();
            return;
        }
        try {
            long start = System.currentTimeMillis();
            this.sqlLine.getDatabaseConnection().connection.commit();
            long end = System.currentTimeMillis();
            this.sqlLine.showWarnings();
            this.reportResult(this.sqlLine.loc("commit-complete", new Object[0]), start, end);
            callback.setToSuccess();
        }
        catch (Exception e) {
            callback.setToFailure();
            this.sqlLine.error(e);
        }
    }

    public void rollback(String line, DispatchCallback callback) {
        if (!this.sqlLine.assertConnection()) {
            callback.setToFailure();
            return;
        }
        if (!this.sqlLine.assertAutoCommit()) {
            callback.setToFailure();
            return;
        }
        try {
            long start = System.currentTimeMillis();
            this.sqlLine.getDatabaseConnection().connection.rollback();
            long end = System.currentTimeMillis();
            this.sqlLine.showWarnings();
            this.reportResult(this.sqlLine.loc("rollback-complete", new Object[0]), start, end);
            callback.setToSuccess();
        }
        catch (Exception e) {
            callback.setToFailure();
            this.sqlLine.error(e);
        }
    }

    public void autocommit(String line, DispatchCallback callback) throws SQLException {
        if (!this.sqlLine.assertConnection()) {
            callback.setToFailure();
            return;
        }
        if (line.endsWith("on")) {
            this.sqlLine.getDatabaseConnection().connection.setAutoCommit(true);
        } else if (line.endsWith("off")) {
            this.sqlLine.getDatabaseConnection().connection.setAutoCommit(false);
        }
        this.sqlLine.showWarnings();
        this.sqlLine.autocommitStatus(this.sqlLine.getDatabaseConnection().connection);
        callback.setToSuccess();
    }

    public void readonly(String line, DispatchCallback callback) throws SQLException {
        if (!this.sqlLine.assertConnection()) {
            callback.setToFailure();
            return;
        }
        if (line.endsWith("on")) {
            this.sqlLine.getDatabaseConnection().connection.setReadOnly(true);
        } else if (line.endsWith("off")) {
            this.sqlLine.getDatabaseConnection().connection.setReadOnly(false);
        }
        this.sqlLine.showWarnings();
        this.sqlLine.readonlyStatus(this.sqlLine.getDatabaseConnection().connection);
        callback.setToSuccess();
    }

    public void dbinfo(String line, DispatchCallback callback) {
        if (!this.sqlLine.assertConnection()) {
            callback.setToFailure();
            return;
        }
        this.sqlLine.showWarnings();
        int padlen = 50;
        for (String method : METHODS) {
            try {
                String s = String.valueOf(this.sqlLine.getReflector().invoke((Object)this.sqlLine.getDatabaseMetaData(), method, new Object[0]));
                this.sqlLine.output(new AttributedStringBuilder().append((CharSequence)SqlLine.rpad(method, padlen)).append((CharSequence)s).toAttributedString());
            }
            catch (Exception e) {
                this.sqlLine.handleException(e);
            }
        }
        callback.setToSuccess();
    }

    public void verbose(String line, DispatchCallback callback) {
        this.sqlLine.info("verbose: on");
        this.set("set verbose true", callback);
    }

    public void outputformat(String line, DispatchCallback callback) {
        try {
            String[] lines = this.sqlLine.split(line);
            this.sqlLine.getOpts().setOutputFormat(lines[1]);
            if ("csv".equals(lines[1])) {
                if (lines.length > 2) {
                    this.sqlLine.getOpts().set(BuiltInProperty.CSV_DELIMITER, (Object)lines[2]);
                }
                if (lines.length > 3) {
                    this.sqlLine.getOpts().setCsvQuoteCharacter(lines[3]);
                }
            } else if ("table".equals(lines[1]) && lines.length > 2) {
                this.sqlLine.getOpts().set(BuiltInProperty.MAX_COLUMN_WIDTH, (Object)lines[2]);
            }
            callback.setToSuccess();
        }
        catch (Exception e) {
            callback.setToFailure();
        }
    }

    public void brief(String line, DispatchCallback callback) {
        this.sqlLine.info("verbose: off");
        this.set("set verbose false", callback);
    }

    public void isolation(String line, DispatchCallback callback) throws SQLException {
        int i;
        if (!this.sqlLine.assertConnection()) {
            callback.setToFailure();
            return;
        }
        if ((line = line.toUpperCase(Locale.ROOT)).endsWith("default".toUpperCase(Locale.ROOT))) {
            i = this.sqlLine.getDatabaseMetaData().getDefaultTransactionIsolation();
        } else if (line.endsWith("TRANSACTION_NONE")) {
            i = 0;
        } else if (line.endsWith("TRANSACTION_READ_COMMITTED")) {
            i = 2;
        } else if (line.endsWith("TRANSACTION_READ_UNCOMMITTED")) {
            i = 1;
        } else if (line.endsWith("TRANSACTION_REPEATABLE_READ")) {
            i = 4;
        } else if (line.endsWith("TRANSACTION_SERIALIZABLE")) {
            i = 8;
        } else {
            callback.setToFailure();
            this.sqlLine.error("Usage: isolation <TRANSACTION_NONE | TRANSACTION_READ_COMMITTED | TRANSACTION_READ_UNCOMMITTED | TRANSACTION_REPEATABLE_READ | TRANSACTION_SERIALIZABLE | DEFAULT>");
            return;
        }
        if (!this.sqlLine.getDatabaseMetaData().supportsTransactionIsolationLevel(i)) {
            callback.setToFailure();
            int defaultTransactionIsolation = this.sqlLine.getDatabaseMetaData().getDefaultTransactionIsolation();
            this.sqlLine.error(this.sqlLine.loc("isolation-level-not-supported", this.getTransactionIsolationName(i), this.getTransactionIsolationName(defaultTransactionIsolation)));
            return;
        }
        Connection connection = this.sqlLine.getDatabaseConnection().getConnection();
        connection.setTransactionIsolation(i);
        this.sqlLine.debug(this.sqlLine.loc("isolation-status", this.getTransactionIsolationName(i)));
        callback.setToSuccess();
    }

    private String getTransactionIsolationName(int i) {
        switch (i) {
            case 0: {
                return "TRANSACTION_NONE";
            }
            case 2: {
                return "TRANSACTION_READ_COMMITTED";
            }
            case 1: {
                return "TRANSACTION_READ_UNCOMMITTED";
            }
            case 4: {
                return "TRANSACTION_REPEATABLE_READ";
            }
            case 8: {
                return "TRANSACTION_SERIALIZABLE";
            }
        }
        return "UNKNOWN";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batch(String line, DispatchCallback callback) {
        if (!this.sqlLine.assertConnection()) {
            callback.setToFailure();
            return;
        }
        if (this.sqlLine.getBatch() == null) {
            this.sqlLine.setBatch(new LinkedList<String>());
            this.sqlLine.info(this.sqlLine.loc("batch-start", new Object[0]));
            callback.setToSuccess();
        } else {
            this.sqlLine.info(this.sqlLine.loc("running-batch", new Object[0]));
            try {
                this.sqlLine.runBatch(this.sqlLine.getBatch());
                callback.setToSuccess();
            }
            catch (Exception e) {
                callback.setToFailure();
                this.sqlLine.error(e);
            }
            finally {
                this.sqlLine.setBatch(null);
            }
        }
    }

    public void sql(String line, DispatchCallback callback) {
        this.execute(line, false, callback);
    }

    public void call(String line, DispatchCallback callback) {
        this.execute(line, true, callback);
    }

    private void execute(String line, boolean call, DispatchCallback callback) {
        String prefix;
        if (line == null || line.length() == 0) {
            callback.setStatus(DispatchCallback.Status.FAILURE);
            return;
        }
        if (!this.sqlLine.assertConnection()) {
            callback.setToFailure();
            return;
        }
        String fullLine = line;
        if (fullLine.startsWith("!")) {
            fullLine = fullLine.substring(1);
        }
        String string = prefix = call ? "call" : "sql";
        if (fullLine.startsWith(prefix)) {
            fullLine = fullLine.substring(prefix.length());
        }
        StringBuilder sql2execute = new StringBuilder();
        for (String sqlItem : fullLine.split(";")) {
            sql2execute.append(sqlItem).append(";");
            if (this.sqlLine.isOneLineComment(sql2execute.toString()) || this.stateIsNotOk(sql2execute.toString())) continue;
            String flushed = Commands.flush(sql2execute);
            String skipLast = Commands.skipLast(flushed);
            String sql = !this.stateIsNot(skipLast, SqlLineParser.SqlParserState.CODE_BLOCK_END_REQUIRED) ? flushed : (!this.sqlLine.getOpts().getKeepSemicolon() ? skipLast : flushed);
            this.executeSingleQuery(sql, call, callback);
        }
        if (!callback.isFailure()) {
            callback.setToSuccess();
        }
    }

    static String flush(StringBuilder buf) {
        String s = buf.toString();
        buf.setLength(0);
        return s;
    }

    private static String skipLast(String s) {
        return s.substring(0, s.length() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSingleQuery(String sql, boolean call, DispatchCallback callback) {
        if (this.sqlLine.getBatch() != null) {
            this.sqlLine.getBatch().add(sql);
            return;
        }
        try {
            Statement stmnt = null;
            try {
                boolean hasResults;
                String question;
                int userResponse;
                long start = System.currentTimeMillis();
                if (this.sqlLine.getOpts().getCompiledConfirmPattern().matcher(sql).find() && this.sqlLine.getOpts().getConfirm() && (userResponse = this.getUserAnswer(question = this.sqlLine.loc("really-perform-action", new Object[0]), 121, 110, 89, 78)) != 121 && userResponse != 89) {
                    this.sqlLine.error(this.sqlLine.loc("abort-action", new Object[0]));
                    callback.setToFailure();
                    return;
                }
                if (call) {
                    stmnt = this.sqlLine.getDatabaseConnection().connection.prepareCall(sql);
                    callback.trackSqlQuery(stmnt);
                    hasResults = ((CallableStatement)stmnt).execute();
                } else {
                    stmnt = this.sqlLine.createStatement();
                    callback.trackSqlQuery(stmnt);
                    hasResults = stmnt.execute(sql);
                }
                this.sqlLine.showWarnings();
                this.sqlLine.showWarnings(stmnt.getWarnings());
                if (hasResults) {
                    do {
                        try (ResultSet rs = stmnt.getResultSet();){
                            int count = this.sqlLine.print(rs, callback);
                            long end = System.currentTimeMillis();
                            this.reportResult(this.sqlLine.loc("rows-selected", count), start, end);
                        }
                    } while (SqlLine.getMoreResults(stmnt));
                } else {
                    int count = stmnt.getUpdateCount();
                    long end = System.currentTimeMillis();
                    if (!this.stateIsNot(Commands.skipLast(sql), SqlLineParser.SqlParserState.CODE_BLOCK_END_REQUIRED)) {
                        this.reportResult(this.sqlLine.loc("script-executed", new Object[0]), start, end);
                    } else {
                        this.reportResult(this.sqlLine.loc("rows-affected", count), start, end);
                    }
                }
            }
            finally {
                if (stmnt != null) {
                    this.sqlLine.showWarnings(stmnt.getWarnings());
                    stmnt.close();
                }
            }
        }
        catch (UserInterruptException uie) {
            callback.setStatus(DispatchCallback.Status.CANCELED);
            this.sqlLine.info(this.sqlLine.loc("command-canceled", new Object[0]));
            return;
        }
        catch (Exception e) {
            callback.setToFailure();
            this.sqlLine.error(e);
        }
        this.sqlLine.showWarnings();
    }

    public void quit(String line, DispatchCallback callback) {
        this.sqlLine.setExit(true);
        this.close(null, callback);
        callback.setToSuccess();
    }

    public void closeall(String line, DispatchCallback callback) {
        this.close(null, callback);
        if (callback.isSuccess()) {
            while (callback.isSuccess()) {
                this.close(null, callback);
            }
            callback.setToSuccess();
        }
        callback.setToFailure();
    }

    public void close(String line, DispatchCallback callback) {
        DatabaseConnection databaseConnection;
        if (this.sqlLine.getRecordOutputFile() != null) {
            this.stopRecording(line, callback);
        }
        if ((databaseConnection = this.sqlLine.getDatabaseConnection()) == null) {
            callback.setToFailure();
            return;
        }
        try {
            Connection connection = databaseConnection.getConnection();
            if (connection != null && !connection.isClosed()) {
                this.sqlLine.debug(this.sqlLine.loc("closing", connection.getClass().getName()));
                connection.close();
            } else {
                this.sqlLine.debug(this.sqlLine.loc("already-closed", new Object[0]));
            }
        }
        catch (Exception e) {
            callback.setToFailure();
            this.sqlLine.error(e);
            return;
        }
        this.sqlLine.getDatabaseConnections().remove();
        callback.setToSuccess();
    }

    public void properties(String line, DispatchCallback callback) throws Exception {
        String example = "";
        example = example + "Usage: properties <properties file>" + SqlLine.getSeparator();
        String[] parts = this.sqlLine.split(line);
        if (parts.length < 2) {
            callback.setToFailure();
            this.sqlLine.error(example);
            return;
        }
        int successes = 0;
        for (int i = 1; i < parts.length; ++i) {
            Properties props = new Properties();
            props.load(new FileInputStream(parts[i]));
            this.connect(props, callback);
            if (!callback.isSuccess()) continue;
            ++successes;
            String nickname = this.getProperty(props, "nickname", "ConnectionNickname");
            if (nickname == null) continue;
            this.sqlLine.getDatabaseConnection().setNickname(nickname);
        }
        if (successes != parts.length - 1) {
            callback.setToFailure();
        } else {
            callback.setToSuccess();
        }
    }

    public void connect(String line, DispatchCallback callback) {
        String driver;
        boolean nickNameFromConfig;
        String example = "Usage: connect [-p property value]* (-(c|cn) <connectionName> | <url>) [username] [password] [driver]" + SqlLine.getSeparator();
        String[] parts = this.sqlLine.split(line);
        if (parts == null) {
            callback.setToFailure();
            return;
        }
        Properties connectProps = new Properties();
        int offset = 1;
        for (int i = 1; i < parts.length; ++i) {
            if (!"-p".equals(parts[i])) continue;
            if (parts.length - i > 2) {
                connectProps.setProperty(parts[i + 1], parts[i + 2]);
                i += 2;
                offset += 3;
                continue;
            }
            callback.setToFailure();
            this.sqlLine.error(example);
            return;
        }
        Properties props = this.conConfParser.getConnectionProperties("global-conf");
        if (props != null) {
            for (String propName : props.stringPropertyNames()) {
                this.setProperty(propName, props.getProperty(propName), null, callback);
            }
        }
        String url = null;
        String nickname = null;
        boolean bl = nickNameFromConfig = parts.length >= offset && "-cn".equals(parts[offset]);
        if (nickNameFromConfig || parts.length >= offset && "-c".equals(parts[offset])) {
            if (parts.length == offset + 1) {
                this.sqlLine.error(example);
                return;
            }
            props = this.conConfParser.getConnectionProperties(parts[offset + 1]);
            if (props == null) {
                this.sqlLine.error(parts[offset + 1] + " not found in connection config");
                return;
            }
            nickname = nickNameFromConfig ? parts[offset + 1] : nickname;
            ++offset;
        } else {
            String string = url = parts.length < offset + 1 ? null : parts[offset];
        }
        if (props == null) {
            props = new Properties();
        }
        String user = parts.length < offset + 2 ? null : parts[offset + 1];
        String pass = parts.length < offset + 3 ? null : parts[offset + 2];
        String string = driver = parts.length < offset + 4 ? null : parts[offset + 3];
        if (url != null) {
            props.setProperty(ConnectionProperties.URL.getSqllineName(), url);
        }
        if (driver != null) {
            props.setProperty(ConnectionProperties.DRIVER.getSqllineName(), driver);
        }
        if (user != null) {
            props.setProperty(ConnectionProperties.USER.getSqllineName(), user);
        }
        if (pass != null) {
            props.setProperty(ConnectionProperties.PASSWORD.getSqllineName(), pass);
        }
        if (!connectProps.isEmpty()) {
            for (String propName : connectProps.stringPropertyNames()) {
                if (props.getProperty(propName) != null) continue;
                props.put(propName, connectProps.getProperty(propName));
            }
        }
        int numberOfConnections = this.sqlLine.getDatabaseConnections().size();
        this.connect(props, callback);
        DatabaseConnection databaseConnection = this.sqlLine.getDatabaseConnection();
        if (nickNameFromConfig && databaseConnection != null && numberOfConnections + 1 == this.sqlLine.getDatabaseConnections().size()) {
            databaseConnection.setNickname(nickname);
        }
    }

    public void nickname(String line, DispatchCallback callback) {
        String nickname;
        String example = "Usage: nickname <nickname for current connection>" + SqlLine.getSeparator();
        String[] parts = this.sqlLine.split(line);
        if (parts == null) {
            callback.setToFailure();
            this.sqlLine.error(example);
            return;
        }
        String string = nickname = parts.length < 2 ? null : parts[1];
        if (nickname != null) {
            DatabaseConnection current = this.sqlLine.getDatabaseConnection();
            if (current != null) {
                current.setNickname(nickname);
                callback.setToSuccess();
            } else {
                this.sqlLine.error("nickname command requires active connection");
            }
        } else {
            this.sqlLine.error(example);
        }
    }

    private String getProperty(Properties props, String ... keys) {
        HashSet<String> keySet = new HashSet<String>(keys.length);
        keySet.addAll(Arrays.asList(keys));
        return this.getProperty(props, keySet);
    }

    private String getProperty(Properties props, Set<String> keys) {
        for (String key : keys) {
            String val = props.getProperty(key);
            if (val == null) continue;
            return val;
        }
        for (String key : Commands.asMap(props).keySet()) {
            for (String key1 : keys) {
                if (!key.endsWith(key1)) continue;
                return props.getProperty(key);
            }
        }
        return null;
    }

    public void connect(Properties props, DispatchCallback callback) {
        String url = this.getProperty(props, ConnectionProperties.URL.getAllNames());
        String driver = this.getProperty(props, ConnectionProperties.DRIVER.getAllNames());
        String username = this.getProperty(props, ConnectionProperties.USER.getAllNames());
        String password = this.getProperty(props, ConnectionProperties.PASSWORD.getAllNames());
        url = url == null ? props.getProperty("url") : url;
        driver = driver == null ? props.getProperty("driver") : driver;
        username = username == null ? props.getProperty("user") : username;
        password = password == null ? props.getProperty("password") : password;
        Properties info = new Properties();
        for (String propName : props.stringPropertyNames()) {
            if (ConnectionProperties.of(propName) != null) continue;
            info.put(propName, props.getProperty(propName));
        }
        String connectInteractionMode = this.sqlLine.getOpts().get(BuiltInProperty.CONNECT_INTERACTION_MODE);
        if (this.isBlank(username) && this.isBlank(password) && "useNPTogetherOrEmpty".equals(connectInteractionMode)) {
            password = "";
            username = "";
        }
        if (url == null || url.length() == 0) {
            callback.setToFailure();
            this.sqlLine.error(this.sqlLine.loc("no-url", new Object[0]));
            return;
        }
        if (driver == null || driver.length() == 0) {
            if (this.sqlLine.scanForDriver(url) == null) {
                callback.setToFailure();
                this.sqlLine.error(this.sqlLine.loc("no-driver", url));
                return;
            }
        } else {
            try {
                Class.forName(driver);
            }
            catch (ClassNotFoundException cnfe) {
                String specifiedDriver = driver;
                driver = this.sqlLine.scanForDriver(url);
                if (driver == null) {
                    callback.setToFailure();
                    this.sqlLine.error(this.sqlLine.loc("no-specified-driver", specifiedDriver));
                    return;
                }
                this.sqlLine.info(this.sqlLine.loc("no-specified-driver-use-existing", specifiedDriver, driver));
            }
        }
        this.sqlLine.debug("Connecting to " + url);
        if (!"notAskCredentials".equals(connectInteractionMode)) {
            if (username == null) {
                username = this.readUsername(url);
                String string = username = this.isBlank(username) ? null : username;
            }
            if (password == null) {
                password = this.readPassword(url);
                password = this.isBlank(password) ? null : password;
            }
        }
        DatabaseConnection connection = new DatabaseConnection(this.sqlLine, driver, url, username, password, info);
        try {
            this.sqlLine.getDatabaseConnections().setConnection(connection);
            this.sqlLine.getDatabaseConnection().getConnection();
            callback.setToSuccess();
        }
        catch (Exception e) {
            connection.close();
            this.sqlLine.getDatabaseConnections().removeConnection(connection);
            callback.setToFailure();
            this.sqlLine.error(e);
        }
    }

    private boolean isBlank(String s) {
        return s == null || s.isEmpty();
    }

    String readUsername(String url) {
        return this.sqlLine.withPrompting(() -> this.sqlLine.getLineReader().readLine("Enter username for " + url + ": "));
    }

    String readPassword(String url) {
        return this.sqlLine.withPrompting(() -> this.sqlLine.getLineReader().readLine("Enter password for " + url + ": ", null, (MaskingCallback)new MaskingCallbackImpl(Character.valueOf('*')), null));
    }

    public void rehash(String line, DispatchCallback callback) {
        try {
            if (!this.sqlLine.assertConnection()) {
                callback.setToFailure();
            }
            if (this.sqlLine.getDatabaseConnection() != null) {
                this.sqlLine.getDatabaseConnection().setCompletions(false);
            }
            callback.setToSuccess();
        }
        catch (Exception e) {
            callback.setToFailure();
            this.sqlLine.error(e);
        }
    }

    public void showconfconnections(String line, DispatchCallback callback) {
        String connectionConfig = this.sqlLine.getOpts().getConnectionConfig();
        if (connectionConfig == null || connectionConfig.isEmpty()) {
            this.sqlLine.error("Configuration file is not specified");
            return;
        }
        Path path = Paths.get(connectionConfig, new String[0]);
        if (Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0])) {
            try (FileInputStream in = new FileInputStream(path.toFile());){
                this.less(in);
            }
            catch (IOException e) {
                callback.setToFailure();
                this.sqlLine.error(e);
            }
        } else {
            this.sqlLine.error("Configuration file '" + path + "' does not exist or is a directory");
        }
    }

    public void rereadconfconnections(String line, DispatchCallback callback) {
        String example = "Usage: rereadconfconnections [new_config]" + SqlLine.getSeparator();
        try {
            String[] parts = this.sqlLine.split(line);
            if (parts == null || parts.length > 2) {
                callback.setToFailure();
                this.sqlLine.error(example);
                return;
            }
            if (parts.length == 2) {
                this.sqlLine.getOpts().setConnectionConfig(parts[1]);
            } else {
                this.resetconfconnections();
            }
            callback.setToSuccess();
        }
        catch (Exception e) {
            callback.setToFailure();
            this.sqlLine.error(e);
        }
    }

    void resetconfconnections() {
        this.conConfParser.resetConnectionProperties();
    }

    void resize() {
        Terminal terminal = this.sqlLine.getTerminal();
        if (terminal == null || terminal.getWidth() == 0 || terminal.getHeight() == 0) {
            return;
        }
        this.sqlLine.getOpts().set(BuiltInProperty.MAX_HEIGHT, terminal.getHeight());
        this.sqlLine.getOpts().set(BuiltInProperty.MAX_WIDTH, terminal.getWidth());
        this.sqlLine.debug(this.sqlLine.loc("new-size-after-resize", terminal.getHeight(), terminal.getWidth()));
    }

    public void resize(String line, DispatchCallback callback) {
        try {
            this.resize();
            callback.setToSuccess();
        }
        catch (Exception e) {
            callback.setToFailure();
            this.sqlLine.error(e);
        }
    }

    public void list(String line, DispatchCallback callback) {
        int index = 0;
        DatabaseConnections databaseConnections = this.sqlLine.getDatabaseConnections();
        this.sqlLine.info(this.sqlLine.loc("active-connections", databaseConnections.size()));
        for (DatabaseConnection databaseConnection : databaseConnections) {
            boolean closed;
            try {
                closed = databaseConnection.connection.isClosed();
            }
            catch (Exception e) {
                closed = true;
            }
            this.sqlLine.output(SqlLine.rpad(" #" + index++ + "", 5) + SqlLine.rpad(closed ? this.sqlLine.loc("closed", new Object[0]) : this.sqlLine.loc("open", new Object[0]), 9) + SqlLine.rpad(databaseConnection.getNickname(), 20) + " " + databaseConnection.getUrl());
        }
        callback.setToSuccess();
    }

    public void all(String line, DispatchCallback callback) {
        int index = this.sqlLine.getDatabaseConnections().getIndex();
        boolean success = true;
        for (int i = 0; i < this.sqlLine.getDatabaseConnections().size(); ++i) {
            this.sqlLine.getDatabaseConnections().setIndex(i);
            this.sqlLine.output(this.sqlLine.loc("executing-con", this.sqlLine.getDatabaseConnection()));
            this.sql(line.substring("all ".length()), callback);
            success = callback.isSuccess() && success;
        }
        this.sqlLine.getDatabaseConnections().setIndex(index);
        if (success) {
            callback.setToSuccess();
        } else {
            callback.setToFailure();
        }
    }

    public void go(String line, DispatchCallback callback) {
        boolean isNumber;
        String[] parts = this.sqlLine.split(line, 2, "Usage: go <connection index>");
        if (parts == null) {
            callback.setToFailure();
            return;
        }
        int index = Integer.MIN_VALUE;
        try {
            index = Integer.parseInt(parts[1]);
            isNumber = true;
        }
        catch (Exception e) {
            isNumber = false;
        }
        if (!isNumber || !this.sqlLine.getDatabaseConnections().setIndex(index)) {
            this.sqlLine.error(this.sqlLine.loc("invalid-connection", parts[1]));
            this.list("", callback);
            callback.setToFailure();
            return;
        }
        callback.setToSuccess();
    }

    public void script(String line, DispatchCallback callback) {
        if (this.sqlLine.getScriptOutputFile() == null) {
            this.startScript(line, callback);
        } else {
            this.stopScript(line, callback);
        }
    }

    private void stopScript(String line, DispatchCallback callback) {
        try {
            this.sqlLine.getScriptOutputFile().close();
        }
        catch (Exception e) {
            this.sqlLine.handleException(e);
        }
        this.sqlLine.info(this.sqlLine.loc("script-closed", this.sqlLine.getScriptOutputFile()));
        this.sqlLine.setScriptOutputFile(null);
        callback.setToSuccess();
    }

    private void startScript(String line, DispatchCallback callback) {
        String filename;
        OutputFile outFile = this.sqlLine.getScriptOutputFile();
        if (outFile != null) {
            callback.setToFailure();
            this.sqlLine.error(this.sqlLine.loc("script-already-running", outFile));
            return;
        }
        if (line.length() == "script".length() || (filename = this.sqlLine.dequote(line.substring("script".length() + 1))) == null) {
            this.sqlLine.error("Usage: script <file name>");
            callback.setToFailure();
            return;
        }
        try {
            outFile = new OutputFile(Commands.expand(filename));
            this.sqlLine.setScriptOutputFile(outFile);
            this.sqlLine.info(this.sqlLine.loc("script-started", outFile));
            callback.setToSuccess();
        }
        catch (Exception e) {
            callback.setToFailure();
            this.sqlLine.error(e);
        }
    }

    public void run(String line, DispatchCallback callback) {
        String filename;
        if (line.length() == "run".length() || (filename = this.sqlLine.dequote(line.substring("run".length() + 1))) == null) {
            this.sqlLine.error("Usage: run <file name>");
            callback.setToFailure();
            return;
        }
        LinkedList<String> cmds = new LinkedList<String>();
        try {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(Commands.expand(filename)), StandardCharsets.UTF_8));){
                String scriptLine;
                StringBuilder cmd = new StringBuilder();
                while ((scriptLine = reader.readLine()) != null) {
                    cmd.append(" \n");
                    cmd.append(scriptLine);
                    boolean needsContinuation = this.stateIsNotOk(cmd.toString());
                    if (needsContinuation || cmd.toString().trim().isEmpty()) continue;
                    cmds.add(this.maybeTrim(Commands.flush(cmd)));
                }
                if (SqlLineParser.isSql(this.sqlLine, cmd.toString(), Parser.ParseContext.ACCEPT_LINE)) {
                    cmd.append(";");
                    cmds.add(cmd.toString());
                }
            }
            if (this.sqlLine.runCommands(cmds, callback) == cmds.size()) {
                callback.setToSuccess();
            } else {
                callback.setToFailure();
            }
        }
        catch (Exception e) {
            callback.setToFailure();
            this.sqlLine.error(e);
        }
    }

    private String maybeTrim(String line) {
        return this.sqlLine.getOpts().getTrimScripts() ? line.trim() : line;
    }

    public static String expand(String filename) {
        if (filename.startsWith("~" + File.separator)) {
            try {
                String home = System.getProperty("user.home");
                if (home != null) {
                    return home + filename.substring(1);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return filename;
    }

    public void record(String line, DispatchCallback callback) {
        if (this.sqlLine.getRecordOutputFile() == null) {
            this.startRecording(line, callback);
        } else {
            this.stopRecording(line, callback);
        }
    }

    public void commandhandler(String line, DispatchCallback callback) {
        String[] cmd = this.sqlLine.split(line);
        if (cmd.length < 2) {
            this.sqlLine.error("Usage: commandhandler <commandHandler class name> [<commandHandler class name>]*");
            callback.setToFailure();
            return;
        }
        ArrayList<CommandHandler> commandHandlers = new ArrayList<CommandHandler>(this.sqlLine.getCommandHandlers());
        HashSet<String> existingNames = new HashSet<String>();
        for (CommandHandler existingCommandHandler : commandHandlers) {
            existingNames.addAll(existingCommandHandler.getNames());
        }
        int commandHandlerUpdateCount = 0;
        for (int i = 1; i < cmd.length; ++i) {
            try {
                Class<?> commandHandlerClass = Class.forName(cmd[i]);
                Constructor<?> constructor = commandHandlerClass.getConstructor(SqlLine.class);
                CommandHandler commandHandler = (CommandHandler)constructor.newInstance(this.sqlLine);
                if (Commands.intersects(existingNames, commandHandler.getNames())) {
                    this.sqlLine.error("Could not add command handler " + cmd[i] + " as one of commands " + commandHandler.getNames() + " is already present");
                    continue;
                }
                commandHandlers.add(commandHandler);
                existingNames.addAll(commandHandler.getNames());
                ++commandHandlerUpdateCount;
                continue;
            }
            catch (Exception e) {
                this.sqlLine.error(e);
                callback.setToFailure();
            }
        }
        if (commandHandlerUpdateCount > 0) {
            this.sqlLine.updateCommandHandlers(commandHandlers);
        }
        if (!callback.isFailure()) {
            callback.setToSuccess();
        }
    }

    private static <E> boolean intersects(Collection<E> c1, Collection<E> c2) {
        for (E e : c2) {
            if (!c1.contains(e)) continue;
            return true;
        }
        return false;
    }

    private void stopRecording(String line, DispatchCallback callback) {
        try {
            this.sqlLine.getRecordOutputFile().close();
        }
        catch (Exception e) {
            this.sqlLine.handleException(e);
        }
        this.sqlLine.info(this.sqlLine.loc("record-closed", this.sqlLine.getRecordOutputFile()));
        this.sqlLine.setRecordOutputFile(null);
        callback.setToSuccess();
    }

    private void startRecording(String line, DispatchCallback callback) {
        OutputFile outputFile = this.sqlLine.getRecordOutputFile();
        if (outputFile != null) {
            callback.setToFailure();
            this.sqlLine.error(this.sqlLine.loc("record-already-running", outputFile));
            return;
        }
        String[] cmd = this.sqlLine.split(line);
        if (cmd.length != 2) {
            this.sqlLine.error("Usage: record <file name>");
            callback.setToFailure();
            return;
        }
        String filename = cmd[1];
        try {
            outputFile = new OutputFile(Commands.expand(filename));
            this.sqlLine.setRecordOutputFile(outputFile);
            this.sqlLine.info(this.sqlLine.loc("record-started", outputFile));
            callback.setToSuccess();
        }
        catch (Exception e) {
            callback.setToFailure();
            this.sqlLine.error(e);
        }
    }

    public void describe(String line, DispatchCallback callback) throws SQLException {
        String[][] cmd = this.sqlLine.splitCompound(line);
        if (cmd.length != 2) {
            this.sqlLine.error("Usage: describe <table name>");
            callback.setToFailure();
            return;
        }
        if (cmd[1].length == 1 && cmd[1][0] != null && cmd[1][0].equalsIgnoreCase("tables")) {
            this.tables("tables", callback);
        } else {
            this.columns(line, callback);
        }
    }

    public void help(String line, DispatchCallback callback) {
        String[] parts = this.sqlLine.split(line);
        String cmd = parts.length > 1 ? parts[1] : "";
        TreeSet<String> clist = new TreeSet<String>();
        for (CommandHandler commandHandler : this.sqlLine.getCommandHandlers()) {
            if (cmd.length() != 0 && !commandHandler.getNames().contains(cmd)) continue;
            String help = commandHandler.getHelpText();
            help = this.sqlLine.wrap(help, 60, 20);
            if (cmd.equals("set")) {
                help = help + this.sqlLine.loc("variables", new Object[0]);
            }
            clist.add(SqlLine.rpad("!" + commandHandler.getName(), 20) + help);
        }
        for (String c : clist) {
            this.sqlLine.output(c);
        }
        if (cmd.length() == 0) {
            this.sqlLine.output(this.sqlLine.loc("variables", new Object[0]));
            this.sqlLine.output("");
            this.sqlLine.output(this.sqlLine.loc("comments", SqlLine.getApplicationContactInformation()));
        }
        callback.setToSuccess();
    }

    public void manual(String line, DispatchCallback callback) throws IOException {
        InputStream in = SqlLine.class.getResourceAsStream("manual.txt");
        if (in == null) {
            callback.setToFailure();
            this.sqlLine.error(this.sqlLine.loc("no-manual", new Object[0]));
            return;
        }
        if (this.less(in)) {
            callback.setToSuccess();
        } else {
            callback.setToFailure();
        }
    }

    private boolean less(InputStream in) throws IOException {
        if (System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("windows")) {
            this.sillyLess(in);
        } else {
            try {
                org.jline.builtins.Commands.less((Terminal)this.sqlLine.getLineReader().getTerminal(), (InputStream)in, (PrintStream)this.sqlLine.getOutputStream(), (PrintStream)this.sqlLine.getErrorStream(), null, (String[])new String[]{"-I", "--syntax=none"});
            }
            catch (Exception e) {
                this.sqlLine.error(e);
                return false;
            }
        }
        return true;
    }

    private void sillyLess(InputStream in) throws IOException {
        String man;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        int index = 0;
        while ((man = reader.readLine()) != null) {
            int userInput;
            this.sqlLine.output(man);
            if (++index % (this.sqlLine.getOpts().getMaxHeight() - 1) != 0 || (userInput = this.getUserAnswer(this.sqlLine.loc("enter-for-more", new Object[0]), 113, 13)) != -1 && userInput != 113) continue;
            this.sqlLine.getLineReader().getTerminal().writer().write(10);
            break;
        }
        reader.close();
    }

    public void appconfig(String line, DispatchCallback callback) {
        String example = "Usage: appconfig <class name for application configuration>" + SqlLine.getSeparator();
        String[] parts = this.sqlLine.split(line);
        if (parts == null || parts.length != 2) {
            callback.setToFailure();
            this.sqlLine.error(example);
            return;
        }
        try {
            Application appConfig = (Application)Class.forName(parts[1]).getConstructor(new Class[0]).newInstance(new Object[0]);
            this.sqlLine.setAppConfig(appConfig);
            callback.setToSuccess();
        }
        catch (Exception e) {
            callback.setToFailure();
            this.sqlLine.error("Could not initialize " + parts[1]);
        }
    }

    public void prompthandler(String line, DispatchCallback callback) {
        PromptHandler promptHandler;
        String example = "Usage: prompthandler <prompt handler class name>" + SqlLine.getSeparator();
        String[] parts = this.sqlLine.split(line);
        if (parts == null || parts.length != 2) {
            callback.setToFailure();
            this.sqlLine.error(example);
            return;
        }
        String className = parts[1];
        if ("default".equalsIgnoreCase(className)) {
            promptHandler = new PromptHandler(this.sqlLine);
        } else {
            try {
                promptHandler = (PromptHandler)Class.forName(className).getConstructor(SqlLine.class).newInstance(this.sqlLine);
            }
            catch (Exception e) {
                callback.setToFailure();
                this.sqlLine.error("Could not initialize " + className);
                return;
            }
        }
        this.sqlLine.updatePromptHandler(promptHandler);
        callback.setToSuccess();
    }

    static Map<String, String> asMap(Properties properties) {
        return properties;
    }

    private boolean stateIsNotOk(String sql) {
        return this.stateIsNot(sql, SqlLineParser.SqlParserState.OK);
    }

    private boolean stateIsNot(String sql, SqlLineParser.SqlParserState state) {
        if (this.sqlLine.getLineReader() == null) {
            return false;
        }
        return state != ((SqlLineParser)this.sqlLine.getLineReader().getParser()).parseState(sql, sql.length(), Parser.ParseContext.ACCEPT_LINE).getState();
    }

    private static enum ConnectionProperties {
        DRIVER("driver", "javax.jdo.option.ConnectionDriverName", "ConnectionDriverName"),
        PASSWORD("password", "javax.jdo.option.ConnectionUserName", "ConnectionUserName"),
        URL("url", "javax.jdo.option.ConnectionURL", "ConnectionURL"),
        USER("user", "javax.jdo.option.ConnectionUserName", "ConnectionUserName");

        private final String sqllineName;
        private final Set<String> allNames;

        private ConnectionProperties(String sqllineName, String ... otherNames) {
            this.sqllineName = sqllineName;
            if (otherNames == null) {
                this.allNames = Collections.singleton(sqllineName);
            } else {
                HashSet<String> names = new HashSet<String>(otherNames.length + 1);
                names.addAll(Arrays.asList(otherNames));
                names.add(sqllineName);
                this.allNames = Collections.unmodifiableSet(names);
            }
        }

        public static ConnectionProperties of(String value) {
            for (ConnectionProperties prop : ConnectionProperties.values()) {
                if (!prop.sqllineName.equals(value) && !prop.allNames.contains(value)) continue;
                return prop;
            }
            return null;
        }

        public String getSqllineName() {
            return this.sqllineName;
        }

        public Set<String> getAllNames() {
            return this.allNames;
        }
    }

    private static class MaskingCallbackImpl
    implements MaskingCallback {
        private final Character mask;

        MaskingCallbackImpl(Character mask) {
            this.mask = Objects.requireNonNull(mask);
        }

        public String display(String line) {
            if (this.mask.equals(Character.valueOf('\u0000'))) {
                return "";
            }
            StringBuilder sb = new StringBuilder(line.length());
            for (char c : line.toCharArray()) {
                if (c == '\n') {
                    sb.append(c);
                    continue;
                }
                sb.append(this.mask.charValue());
            }
            return sb.toString();
        }

        public String history(String line) {
            return null;
        }
    }
}

